/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.dcerpc;

import kg.apc.jmeter.dcerpc.BinaryUtils;
import kg.apc.jmeter.dcerpc.RPCCallException;
import org.apache.jorphan.util.JOrphanUtils;

public abstract class RPCPacket {
    public static final byte PACKET_TYPE_UNKNOWN = -1;
    public static final byte PACKET_TYPE_REQUEST = 0;
    public static final byte PACKET_TYPE_RESPONSE = 2;
    public static final byte PACKET_TYPE_FAULT = 3;
    public static final byte PACKET_TYPE_BIND = 11;
    public static final byte PACKET_TYPE_BINDACK = 12;
    public static final byte PACKET_TYPE_BINDNACK = 13;
    public static final byte PACKET_FLAG_FIRST = 1;
    public static final byte PACKET_FLAG_LAST = 2;
    public static final short COMMONHEADERLENGTH = 16;
    protected static byte version = (byte)5;
    protected static byte versionminor = 0;
    protected byte packetType = (byte)-1;
    protected byte packetFlags = (byte)3;
    protected static byte byteOrder = (byte)16;
    protected static byte character = 0;
    protected static byte floatingPoint = 0;
    protected short fragLength;
    protected static short authLength = 0;
    protected int callID = 1;

    protected final byte[] getCommonHeaderBytes() {
        byte[] header = new byte[]{version, versionminor, this.packetType, this.packetFlags, byteOrder, character, floatingPoint, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        int curPos = 8;
        System.arraycopy(BinaryUtils.shortToByteArray(this.fragLength), 0, header, curPos, 2);
        System.arraycopy(BinaryUtils.shortToByteArray(authLength), 0, header, curPos += 2, 2);
        System.arraycopy(BinaryUtils.intToByteArray(this.callID), 0, header, curPos += 2, 4);
        curPos += 4;
        return header;
    }

    public final byte[] getBytes() {
        byte[] body = this.getBodyBytes();
        byte[] header = this.getHeaderBytes();
        this.fragLength = (short)(16 + header.length + body.length);
        byte[] commonheader = this.getCommonHeaderBytes();
        byte[] result = new byte[this.fragLength];
        System.arraycopy(commonheader, 0, result, 0, commonheader.length);
        System.arraycopy(header, 0, result, commonheader.length, header.length);
        System.arraycopy(body, 0, result, commonheader.length + header.length, body.length);
        return result;
    }

    protected abstract byte[] getHeaderBytes();

    protected abstract byte[] getBodyBytes();

    public static byte getPacketFlags(byte[] toByteArray) {
        return toByteArray[3];
    }

    public static byte[] getPacketWithoutHeader(byte[] resultBytes) throws RPCCallException {
        byte packetType = resultBytes[2];
        byte[] returnBytes = null;
        int offset = 16;
        switch (packetType) {
            case 13: {
                throw new RPCCallException("BindNack received");
            }
            case 3: {
                throw new RPCCallException("RPC Fault received");
            }
            case 12: {
                break;
            }
            case 2: {
                offset = (short)(offset + 8);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported packet type: " + Byte.toString(packetType) + ", full HEX: " + JOrphanUtils.baToHexString((byte[])resultBytes));
            }
        }
        returnBytes = new byte[resultBytes.length - offset];
        System.arraycopy(resultBytes, offset, returnBytes, 0, resultBytes.length - offset);
        return returnBytes;
    }

    public static short fragLenFromRPCHeader(byte[] buffer) {
        return BinaryUtils.twoBytesToShortVal(buffer[8], buffer[9]);
    }
}

