/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.modifiers;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;

public class FifoMap
extends ConcurrentHashMap<String, LinkedBlockingDeque<String>> {
    public static final String TIMEOUT_PROP = "kg.apc.jmeter.functions.FifoTimeout";
    private static FifoMap instance;

    private FifoMap() {
    }

    public static FifoMap getInstance() {
        if (instance == null) {
            instance = new FifoMap();
        }
        return instance;
    }

    private LinkedBlockingDeque<String> getFifo(String fifoName) {
        if (super.containsKey(fifoName)) {
            return (LinkedBlockingDeque)super.get(fifoName);
        }
        LinkedBlockingDeque<String> fifo = new LinkedBlockingDeque<String>();
        super.put(fifoName, fifo);
        return fifo;
    }

    public String get(String fifoName) {
        LinkedBlockingDeque<String> fifo = this.getFifo(fifoName);
        String value = fifo.peekLast();
        return value == null ? "" : value;
    }

    public String pop(String fifoName, long timeout) throws InterruptedException {
        LinkedBlockingDeque<String> fifo = this.getFifo(fifoName);
        String value = fifo.pollLast(timeout, TimeUnit.SECONDS);
        return value;
    }

    public int length(String fifoName) {
        LinkedBlockingDeque<String> fifo = this.getFifo(fifoName);
        int size = fifo.size();
        return size;
    }

    @Override
    public void put(String fifoName, String v) throws InterruptedException {
        this.getFifo(fifoName).offerFirst(v, Long.MAX_VALUE, TimeUnit.SECONDS);
    }
}

