/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.reporters;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.zip.GZIPOutputStream;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.reporters.LoadosophiaUploaderGui;
import kg.apc.jmeter.reporters.LoadosophiaUploadingNotifier;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.FilePartSource;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.samplers.SampleSaveConfiguration;
import org.apache.jmeter.testelement.TestListener;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class LoadosophiaUploader
extends ResultCollector
implements TestListener {
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String ADDRESS = "address";
    public static final String TITLE = "title";
    public static final String COLOR = "color";
    public static final String UPLOAD_TOKEN = "uploadToken";
    public static final String PROJECT = "project";
    public static final String STORE_DIR = "storeDir";
    private String fileName;
    private static final Object LOCK = new Object();
    private boolean isSaving;
    private LoadosophiaUploadingNotifier perfMonNotifier = LoadosophiaUploadingNotifier.getInstance();
    private String address = JMeterUtils.getPropDefault((String)"loadosophia.address", (String)"https://loadosophia.org/");
    public static final String COLOR_NONE = "none";
    public static final String[] colors = new String[]{"none", "red", "green", "blue", "gray", "orange", "violet", "cyan", "black"};
    private static final String STATUS_DONE = "4";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStarted(String host) {
        Object object = LOCK;
        synchronized (object) {
            try {
                if (!this.isSaving) {
                    this.isSaving = true;
                    this.setupSaving();
                }
            }
            catch (IOException ex) {
                log.error("Error setting up saving", (Throwable)ex);
            }
        }
        super.testStarted(host);
        this.perfMonNotifier.startCollecting();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEnded(String host) {
        super.testEnded(host);
        Object object = LOCK;
        synchronized (object) {
            try {
                String results;
                if (this.fileName == null) {
                    throw new IOException("File for upload was not set, search for errors above in log");
                }
                this.isSaving = false;
                int queueID = this.sendFilesToLoadosophia(new File(this.fileName), this.perfMonNotifier.getFiles());
                if (!this.getTitle().trim().isEmpty() || !this.getColorFlag().equals(COLOR_NONE)) {
                    int testID = this.getTestByUpload(queueID);
                    if (!this.getTitle().trim().isEmpty()) {
                        this.setTestTitle(testID, this.getTitle().trim());
                    }
                    if (!this.getColorFlag().equals(COLOR_NONE)) {
                        this.setTestColor(testID, this.getColorFlag());
                    }
                    results = this.address + "gui/" + testID + "/";
                } else {
                    results = this.address + "api/file/status/" + queueID + "/?redirect=true";
                }
                this.informUser("Uploaded successfully, go to results: " + results);
            }
            catch (IOException ex) {
                this.informUser("Failed to upload results to Loadosophia.org, see log for detais");
                log.error("Failed to upload results to loadosophia", (Throwable)ex);
            }
        }
        this.clearData();
        this.perfMonNotifier.endCollecting();
    }

    private void setupSaving() throws IOException {
        File tmpFile;
        String dir = this.getStoreDir();
        if (!dir.endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        try {
            tmpFile = File.createTempFile("Loadosophia_", ".jtl", new File(dir));
        }
        catch (IOException ex) {
            this.informUser("Unable to create temp file: " + ex.getMessage());
            this.informUser("Try to set another directory in the above field.");
            throw ex;
        }
        this.fileName = tmpFile.getAbsolutePath();
        tmpFile.delete();
        this.informUser("Storing results for upload to Loadosophia.org: " + this.fileName);
        this.setFilename(this.fileName);
        this.clearTemporary(this.getProperty("filename"));
        SampleSaveConfiguration conf = this.getSaveConfig();
        JMeterPluginsUtils.doBestCSVSetup(conf);
        this.setSaveConfig(conf);
    }

    private int sendFilesToLoadosophia(File targetFile, LinkedList<String> perfMonFiles) throws IOException {
        if (targetFile.length() == 0L) {
            throw new IOException("Cannot send empty file to Loadosophia.org");
        }
        log.info("Preparing files to send");
        LinkedList<Part> partsList = new LinkedList<Part>();
        partsList.add((Part)new StringPart("projectKey", this.getProject()));
        partsList.add((Part)new FilePart("jtl_file", (PartSource)new FilePartSource(this.gzipFile(targetFile))));
        targetFile.delete();
        Iterator it = perfMonFiles.iterator();
        int index = 0;
        while (it.hasNext()) {
            File perfmonFile = new File((String)it.next());
            if (!perfmonFile.exists()) {
                log.warn("File not exists, skipped: " + perfmonFile.getAbsolutePath());
                continue;
            }
            partsList.add((Part)new FilePart("perfmon_" + index, (PartSource)new FilePartSource(this.gzipFile(perfmonFile))));
            perfmonFile.delete();
            ++index;
        }
        this.informUser("Starting upload to Loadosophia.org");
        String[] fields = this.doRequest(partsList, this.getUploaderURI(), 200);
        return Integer.parseInt(fields[0]);
    }

    private File gzipFile(File src) throws IOException {
        int len;
        String outFilename = src.getAbsolutePath() + ".gz";
        this.informUser("Gzipping " + src.getAbsolutePath());
        GZIPOutputStream out = new GZIPOutputStream(new FileOutputStream(outFilename));
        FileInputStream in = new FileInputStream(src);
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        in.close();
        out.finish();
        out.close();
        return new File(outFilename);
    }

    public void setProject(String proj) {
        this.setProperty(PROJECT, proj);
    }

    public String getProject() {
        return this.getPropertyAsString(PROJECT);
    }

    public void setUploadToken(String token) {
        this.setProperty(UPLOAD_TOKEN, token);
    }

    public String getUploadToken() {
        return this.getPropertyAsString(UPLOAD_TOKEN);
    }

    public void setTitle(String prefix) {
        this.setProperty(TITLE, prefix);
    }

    public String getTitle() {
        return this.getPropertyAsString(TITLE);
    }

    private void informUser(String string) {
        log.info(string);
        if (this.getVisualizer() != null && this.getVisualizer() instanceof LoadosophiaUploaderGui) {
            ((LoadosophiaUploaderGui)this.getVisualizer()).inform(string);
        } else {
            log.info(string);
        }
    }

    public String getStoreDir() {
        return this.getPropertyAsString(STORE_DIR);
    }

    public void setStoreDir(String prefix) {
        this.setProperty(STORE_DIR, prefix);
    }

    public void testIterationStart(LoopIterationEvent lie) {
    }

    public void setColorFlag(String color) {
        this.setProperty(COLOR, color);
    }

    public String getColorFlag() {
        return this.getPropertyAsString(COLOR);
    }

    private String getUploaderURI() {
        return this.address + "api/file/upload/?format=csv";
    }

    private int getTestByUpload(int queueID) throws IOException {
        String[] status;
        do {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException("Failed to get test ID");
            }
            status = this.get_upload_status(queueID);
            if (status.length <= 2 || status[2].isEmpty()) continue;
            throw new RuntimeException("Loadosophia processing error: " + status[2]);
        } while (!status[1].equals(STATUS_DONE));
        return Integer.parseInt(status[0]);
    }

    private void setTestTitle(int testID, String trim) throws IOException {
        String uri = this.address + "api/test/edit/title/" + testID + "/?title=" + URLEncoder.encode(trim, "UTF-8");
        this.doRequest(new LinkedList<Part>(), uri, 204);
    }

    private void setTestColor(int testID, String colorFlag) throws IOException {
        String uri = this.address + "api/test/edit/color/" + testID + "/?color=" + colorFlag;
        this.doRequest(new LinkedList<Part>(), uri, 204);
    }

    protected String[] get_upload_status(int queueID) throws IOException {
        String uri = this.address + "api/file/status/" + queueID + "/?format=csv";
        return this.doRequest(new LinkedList<Part>(), uri, 200);
    }

    private String[] doRequest(LinkedList<Part> parts, String URL2, int expectedSC) throws IOException {
        log.debug("Request " + URL2);
        parts.add((Part)new StringPart("token", this.getUploadToken()));
        HttpClient uploader = new HttpClient();
        PostMethod postRequest = new PostMethod(URL2);
        MultipartRequestEntity multipartRequest = new MultipartRequestEntity(parts.toArray(new Part[0]), postRequest.getParams());
        postRequest.setRequestEntity((RequestEntity)multipartRequest);
        int result = uploader.executeMethod((HttpMethod)postRequest);
        if (result != expectedSC) {
            String fname = File.createTempFile("error_", ".html").getAbsolutePath();
            this.informUser("Saving server error response to: " + fname);
            FileOutputStream fos = new FileOutputStream(fname);
            FileChannel resultFile = fos.getChannel();
            resultFile.write(ByteBuffer.wrap(postRequest.getResponseBody()));
            resultFile.close();
            HttpException $e = new HttpException("Request returned not " + expectedSC + " status code: " + result);
            throw $e;
        }
        byte[] bytes = postRequest.getResponseBody();
        if (bytes == null) {
            bytes = new byte[]{};
        }
        String response = new String(bytes);
        String[] fields = response.trim().split(";");
        return fields;
    }
}

