/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.samplers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.gui.GuiBuilderHelper;
import kg.apc.jmeter.samplers.HexStringUDPDecoder;
import kg.apc.jmeter.samplers.UDPSampler;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;

public class UDPSamplerGui
extends AbstractSamplerGui {
    private static final String WIKIPAGE = "UDPRequest";
    private JTextField hostName;
    private JTextField port;
    private JCheckBox waitResponse;
    private JCheckBox closeChannel;
    private JTextField timeout;
    private JTextField messageEncodeClass;
    private JTextArea requestData;

    public UDPSamplerGui() {
        this.init();
        this.initFields();
    }

    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel("UDP Request");
    }

    public String getLabelResource() {
        return ((Object)((Object)this)).getClass().getCanonicalName();
    }

    public void configure(TestElement element) {
        super.configure(element);
        if (element instanceof UDPSampler) {
            UDPSampler sampler = (UDPSampler)element;
            this.hostName.setText(sampler.getHostName());
            this.port.setText(sampler.getPort());
            this.timeout.setText(sampler.getTimeout());
            this.waitResponse.setSelected(sampler.isWaitResponse());
            this.closeChannel.setSelected(sampler.isCloseChannel());
            this.messageEncodeClass.setText(sampler.getEncoderClass());
            this.requestData.setText(sampler.getRequestData());
        }
    }

    public TestElement createTestElement() {
        UDPSampler sampler = new UDPSampler();
        this.modifyTestElement((TestElement)sampler);
        sampler.setComment(JMeterPluginsUtils.getWikiLinkText(WIKIPAGE));
        return sampler;
    }

    public void modifyTestElement(TestElement el) {
        super.configureTestElement(el);
        if (el instanceof UDPSampler) {
            UDPSampler sampler = (UDPSampler)el;
            sampler.setHostName(this.hostName.getText());
            sampler.setPort(this.port.getText());
            sampler.setWaitResponse(this.waitResponse.isSelected());
            sampler.setCloseChannel(this.closeChannel.isSelected());
            sampler.setTimeout(this.timeout.getText());
            sampler.setRequestData(this.transformCRLF(this.requestData.getText()));
            sampler.setEncoderClass(this.messageEncodeClass.getText());
        }
    }

    private String transformCRLF(String str) {
        return str.replace("\r\n", "\n").replace("\r", "").replace("\n", "\r\n");
    }

    public void clearGui() {
        super.clearGui();
        this.initFields();
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(JMeterPluginsUtils.addHelpLinkToPanel(this.makeTitlePanel(), WIKIPAGE), "North");
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.anchor = 24;
        GridBagConstraints editConstraints = new GridBagConstraints();
        editConstraints.anchor = 23;
        editConstraints.weightx = 1.0;
        editConstraints.fill = 2;
        this.addToPanel(mainPanel, labelConstraints, 0, 1, new JLabel("Hostname/IP: ", 4));
        this.hostName = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, 1, this.hostName);
        editConstraints.insets = new Insets(2, 0, 0, 0);
        labelConstraints.insets = new Insets(2, 0, 0, 0);
        this.addToPanel(mainPanel, labelConstraints, 0, 2, new JLabel("UDP Port: ", 4));
        this.port = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, 2, this.port);
        this.addToPanel(mainPanel, labelConstraints, 0, 3, new JLabel("Wait for Response: ", 4));
        this.waitResponse = new JCheckBox();
        this.addToPanel(mainPanel, editConstraints, 1, 3, this.waitResponse);
        this.addToPanel(mainPanel, labelConstraints, 0, 4, new JLabel("Close UDP Socket: ", 4));
        this.closeChannel = new JCheckBox();
        this.addToPanel(mainPanel, editConstraints, 1, 4, this.closeChannel);
        this.addToPanel(mainPanel, labelConstraints, 0, 5, new JLabel("Response Timeout: ", 4));
        this.timeout = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, 5, this.timeout);
        this.addToPanel(mainPanel, labelConstraints, 0, 6, new JLabel("Data Encode/Decode class: ", 4));
        this.messageEncodeClass = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, 6, this.messageEncodeClass);
        editConstraints.insets = new Insets(4, 0, 0, 0);
        labelConstraints.insets = new Insets(4, 0, 0, 0);
        this.addToPanel(mainPanel, labelConstraints, 0, 7, new JLabel("Request Data: ", 4));
        editConstraints.fill = 1;
        this.requestData = new JTextArea();
        this.addToPanel(mainPanel, editConstraints, 1, 7, GuiBuilderHelper.getTextAreaScrollPaneContainer(this.requestData, 10));
        JPanel container = new JPanel(new BorderLayout());
        container.add((Component)mainPanel, "North");
        this.add(container, "Center");
    }

    private void addToPanel(JPanel panel, GridBagConstraints constraints, int col, int row, JComponent component) {
        constraints.gridx = col;
        constraints.gridy = row;
        panel.add((Component)component, constraints);
    }

    private void initFields() {
        this.hostName.setText("");
        this.port.setText("");
        this.timeout.setText("1000");
        this.waitResponse.setSelected(true);
        this.closeChannel.setSelected(false);
        this.messageEncodeClass.setText(HexStringUDPDecoder.class.getCanonicalName());
        this.requestData.setText("");
    }
}

