/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.threads;

import kg.apc.jmeter.threads.AbstractSimpleThreadGroup;
import org.apache.jmeter.threads.JMeterThread;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class SteppingThreadGroup
extends AbstractSimpleThreadGroup {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String THREAD_GROUP_DELAY = "Threads initial delay";
    private static final String INC_USER_PERIOD = "Start users period";
    private static final String INC_USER_COUNT = "Start users count";
    private static final String DEC_USER_PERIOD = "Stop users period";
    private static final String DEC_USER_COUNT = "Stop users count";
    private static final String FLIGHT_TIME = "flighttime";
    private static final String RAMPUP = "rampUp";

    @Override
    protected void scheduleThread(JMeterThread thread, long tgStartTime) {
        int inUserCount = this.getInUserCountAsInt();
        int outUserCount = this.getOutUserCountAsInt();
        if (inUserCount == 0) {
            inUserCount = this.getNumThreads();
        }
        if (outUserCount == 0) {
            outUserCount = this.getNumThreads();
        }
        int threadGroupDelay = 1000 * this.getThreadGroupDelayAsInt();
        long ascentPoint = tgStartTime + (long)threadGroupDelay;
        int inUserPeriod = 1000 * this.getInUserPeriodAsInt();
        int additionalRampUp = 1000 * this.getRampUpAsInt() / inUserCount;
        int flightTime = 1000 * this.getFlightTimeAsInt();
        int outUserPeriod = 1000 * this.getOutUserPeriodAsInt();
        long rampUpDuration = 1000 * this.getRampUpAsInt();
        long iterationDuration = (long)inUserPeriod + rampUpDuration;
        int iterationCountTotal = (int)Math.ceil((double)this.getNumThreads() / (double)inUserCount) - 1;
        int iterationCountBeforeMe = (int)Math.floor((double)thread.getThreadNum() / (double)inUserCount);
        int lastIterationUserCount = this.getNumThreads() % inUserCount;
        if (lastIterationUserCount == 0) {
            lastIterationUserCount = inUserCount;
        }
        long descentPoint = ascentPoint + (long)iterationCountTotal * iterationDuration + (long)(additionalRampUp * lastIterationUserCount) + (long)flightTime;
        long startTime = ascentPoint + (long)iterationCountBeforeMe * iterationDuration + (long)(thread.getThreadNum() % inUserCount * additionalRampUp);
        long endTime = descentPoint + (long)(outUserPeriod * (int)Math.floor((double)thread.getThreadNum() / (double)outUserCount));
        log.debug(String.format("threadNum=%d, rampUpDuration=%d, iterationDuration=%d, iterationCountTotal=%d, iterationCountBeforeMe=%d, ascentPoint=%d, descentPoint=%d, startTime=%d, endTime=%d", thread.getThreadNum(), rampUpDuration, iterationDuration, iterationCountTotal, iterationCountBeforeMe, ascentPoint, descentPoint, startTime, endTime));
        thread.setStartTime(startTime);
        thread.setEndTime(endTime);
        thread.setScheduled(true);
    }

    public String getThreadGroupDelay() {
        return this.getPropertyAsString(THREAD_GROUP_DELAY);
    }

    public void setThreadGroupDelay(String delay) {
        this.setProperty(THREAD_GROUP_DELAY, delay);
    }

    public String getInUserPeriod() {
        return this.getPropertyAsString(INC_USER_PERIOD);
    }

    public void setInUserPeriod(String value) {
        this.setProperty(INC_USER_PERIOD, value);
    }

    public String getInUserCount() {
        return this.getPropertyAsString(INC_USER_COUNT);
    }

    public void setInUserCount(String delay) {
        this.setProperty(INC_USER_COUNT, delay);
    }

    public String getFlightTime() {
        return this.getPropertyAsString(FLIGHT_TIME);
    }

    public void setFlightTime(String delay) {
        this.setProperty(FLIGHT_TIME, delay);
    }

    public String getOutUserPeriod() {
        return this.getPropertyAsString(DEC_USER_PERIOD);
    }

    public void setOutUserPeriod(String delay) {
        this.setProperty(DEC_USER_PERIOD, delay);
    }

    public String getOutUserCount() {
        return this.getPropertyAsString(DEC_USER_COUNT);
    }

    public void setOutUserCount(String delay) {
        this.setProperty(DEC_USER_COUNT, delay);
    }

    public String getRampUp() {
        return this.getPropertyAsString(RAMPUP);
    }

    public void setRampUp(String delay) {
        this.setProperty(RAMPUP, delay);
    }

    public int getThreadGroupDelayAsInt() {
        return this.getPropertyAsInt(THREAD_GROUP_DELAY);
    }

    public int getInUserPeriodAsInt() {
        return this.getPropertyAsInt(INC_USER_PERIOD);
    }

    public int getInUserCountAsInt() {
        return this.getPropertyAsInt(INC_USER_COUNT);
    }

    public int getRampUpAsInt() {
        return this.getPropertyAsInt(RAMPUP);
    }

    public int getFlightTimeAsInt() {
        return this.getPropertyAsInt(FLIGHT_TIME);
    }

    public int getOutUserPeriodAsInt() {
        return this.getPropertyAsInt(DEC_USER_PERIOD);
    }

    public int getOutUserCountAsInt() {
        return this.getPropertyAsInt(DEC_USER_COUNT);
    }

    public void setNumThreads(String execute) {
        this.setProperty("ThreadGroup.num_threads", execute);
    }

    public String getNumThreadsAsString() {
        return this.getPropertyAsString("ThreadGroup.num_threads");
    }
}

