/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.BinaryRule;
import edu.berkeley.nlp.PCFGLA.Grammar;
import edu.berkeley.nlp.PCFGLA.Lexicon;
import edu.berkeley.nlp.PCFGLA.Parser;
import edu.berkeley.nlp.PCFGLA.UnaryRule;
import edu.berkeley.nlp.discPCFG.Linearizer;
import edu.berkeley.nlp.math.DoubleArrays;
import edu.berkeley.nlp.syntax.StateSet;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.util.ArrayUtil;
import edu.berkeley.nlp.util.Numberer;
import edu.berkeley.nlp.util.ScalingTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayParser
implements Parser {
    short zero = 0;
    short one = 1;
    protected Numberer tagNumberer = Numberer.getGlobalNumberer("tags");
    protected double[][][] iScore;
    protected double[][][] oScore;
    protected int[][] narrowLExtent = null;
    protected int[][] wideLExtent = null;
    protected int[][] narrowRExtent = null;
    protected int[][] wideRExtent = null;
    protected short length;
    protected int arraySize = 0;
    protected int myMaxLength = 200;
    Lexicon lexicon;
    int numStates;
    int maxNSubStates;
    int[] idxC;
    double[] scoresToAdd;
    int touchedRules;
    double[] tmpCountsArray;
    Grammar grammar;
    int[] stateClass;
    private static final double TOL = 1.0E-5;

    public ArrayParser() {
    }

    public ArrayParser(Grammar gr, Lexicon lex) {
        this.touchedRules = 0;
        this.grammar = gr;
        this.lexicon = lex;
        this.tagNumberer = Numberer.getGlobalNumberer("tags");
        this.numStates = gr.numStates;
        this.maxNSubStates = this.maxSubStates(gr);
        this.idxC = new int[this.maxNSubStates];
        this.scoresToAdd = new double[this.maxNSubStates];
        this.tmpCountsArray = new double[this.scoresToAdd.length * this.scoresToAdd.length * this.scoresToAdd.length];
    }

    public List<Integer>[][] getPossibleStates(List<String> sentence, double logThreshold) {
        this.length = (short)sentence.size();
        this.initializeArrays();
        this.initializeChart(sentence, false);
        this.doInsideScores();
        double score = this.iScore[0][this.length][0];
        if (score > Double.NEGATIVE_INFINITY) {
            System.out.println("\nFound a parse for sentence with length " + this.length + ". The LL is " + score + ".");
        } else {
            System.out.println("Did NOT find a parse for sentence with length " + this.length + ".");
        }
        this.oScore[0][this.length][this.tagNumberer.number((Object)"ROOT")] = 0.0;
        this.doOutsideScores();
        ArrayList[][] possibleStates = new ArrayList[this.length + 1][this.length + 1];
        int unprunedStates = 0;
        int prunedStates = 0;
        double sentenceProb = this.iScore[0][this.length][0];
        int diff = 1;
        while (diff <= this.length) {
            int start = 0;
            while (start < this.length - diff + 1) {
                int end = start + diff;
                possibleStates[start][end] = new ArrayList();
                int state = 0;
                while (state < this.numStates) {
                    double viterbiPosterior = this.iScore[start][end][state] + this.oScore[start][end][state] - sentenceProb;
                    if (!Double.isInfinite(viterbiPosterior)) {
                        ++unprunedStates;
                    }
                    if (viterbiPosterior > logThreshold) {
                        possibleStates[start][end].add(new Integer(state));
                        ++prunedStates;
                    }
                    ++state;
                }
                ++start;
            }
            ++diff;
        }
        System.out.print("Down to " + prunedStates + " states from " + unprunedStates + ". ");
        return possibleStates;
    }

    public int maxSubStates(Grammar grammar) {
        short max = 0;
        int i = 0;
        while (i < this.numStates) {
            if (grammar.numSubStates[i] > max) {
                max = grammar.numSubStates[i];
            }
            ++i;
        }
        return max;
    }

    @Override
    public Tree<String> getBestParse(List<String> sentence) {
        System.out.println("This parser assumes an unsplit grammar (= split grammar with 1 substate)");
        this.length = (short)sentence.size();
        this.initializeArrays();
        this.initializeChart(sentence, false);
        this.doInsideScores();
        Tree<String> bestTree = new Tree<String>("ROOT");
        double score = this.iScore[0][this.length][this.tagNumberer.number("ROOT")];
        if (score > Double.NEGATIVE_INFINITY) {
            System.out.println("\nFound a parse for sentence with length " + this.length + ". The LL is " + score + ".");
            bestTree = this.extractBestParse(this.tagNumberer.number("ROOT"), 0, this.length, sentence);
            this.restoreUnaries(bestTree);
        } else {
            System.out.println("Did NOT find a parse for sentence with length " + this.length + ".");
        }
        return bestTree;
    }

    public boolean hasParse() {
        if (this.length > this.arraySize) {
            return false;
        }
        return this.iScore[0][this.length][this.tagNumberer.number("ROOT")] > Double.NEGATIVE_INFINITY;
    }

    void initializeArrays() {
        if (this.length > this.arraySize) {
            if (this.length > this.myMaxLength) {
                throw new OutOfMemoryError("Refusal to create such large arrays.");
            }
            try {
                this.createArrays(this.length + 1);
            }
            catch (OutOfMemoryError e) {
                this.myMaxLength = this.length;
                if (this.arraySize > 0) {
                    try {
                        this.createArrays(this.arraySize);
                    }
                    catch (OutOfMemoryError e2) {
                        throw new RuntimeException("CANNOT EVEN CREATE ARRAYS OF ORIGINAL SIZE!!!");
                    }
                }
                throw e;
            }
            this.arraySize = this.length + 1;
        }
        int start = 0;
        while (start < this.length) {
            int end = start + 1;
            while (end <= this.length) {
                Arrays.fill(this.iScore[start][end], Double.NEGATIVE_INFINITY);
                Arrays.fill(this.oScore[start][end], Double.NEGATIVE_INFINITY);
                ++end;
            }
            ++start;
        }
        int loc = 0;
        while (loc <= this.length) {
            Arrays.fill(this.narrowLExtent[loc], -1);
            Arrays.fill(this.wideLExtent[loc], this.length + 1);
            Arrays.fill(this.narrowRExtent[loc], this.length + 1);
            Arrays.fill(this.wideRExtent[loc], -1);
            ++loc;
        }
    }

    void initializeChart(List<String> sentence, boolean noSmoothing) {
        int start = 0;
        int end = start + 1;
        for (String word : sentence) {
            end = start + 1;
            short tag = 0;
            while (tag < this.numStates) {
                if (!this.grammar.isGrammarTag[tag]) {
                    double prob;
                    this.iScore[start][end][tag] = prob = this.lexicon.score(word, tag, start, noSmoothing, false)[0];
                    this.narrowRExtent[start][tag] = end;
                    this.narrowLExtent[end][tag] = start;
                    this.wideRExtent[start][tag] = end;
                    this.wideLExtent[end][tag] = start;
                }
                tag = (short)(tag + 1);
            }
            ++start;
        }
    }

    void doInsideScores() {
        this.grammar.logarithmMode();
        this.lexicon.logarithmMode();
        int diff = 1;
        while (diff <= this.length) {
            int start = 0;
            while (start < this.length - diff + 1) {
                int end = start + diff;
                int pparentState = 0;
                while (pparentState < this.numStates) {
                    BinaryRule[] parentRules = this.grammar.splitRulesWithP(pparentState);
                    int i = 0;
                    while (i < parentRules.length) {
                        boolean iPossibleL;
                        BinaryRule r = parentRules[i];
                        short leftState = r.leftChildState;
                        short parentState = r.parentState;
                        int narrowR = this.narrowRExtent[start][leftState];
                        boolean bl = iPossibleL = narrowR < end;
                        if (iPossibleL) {
                            boolean iPossibleR;
                            int narrowL = this.narrowLExtent[end][r.rightChildState];
                            boolean bl2 = iPossibleR = narrowL >= narrowR;
                            if (iPossibleR) {
                                int min;
                                int min1 = narrowR;
                                int min2 = this.wideLExtent[end][r.rightChildState];
                                int n = min = min1 > min2 ? min1 : min2;
                                if (min <= narrowL) {
                                    int max;
                                    int max1 = this.wideRExtent[start][leftState];
                                    int max2 = narrowL;
                                    int n2 = max = max1 < max2 ? max1 : max2;
                                    if (min <= max) {
                                        boolean foundBetter;
                                        double oldIScore;
                                        double pS = r.getScore(0, 0, 0);
                                        double bestIScore = oldIScore = this.iScore[start][end][parentState];
                                        int split = min;
                                        while (split <= max) {
                                            double rS;
                                            double lS = this.iScore[start][split][leftState];
                                            if (!Double.isInfinite(lS) && !Double.isInfinite(rS = this.iScore[split][end][r.rightChildState])) {
                                                ++this.touchedRules;
                                                double tot = pS + lS + rS;
                                                if (tot > bestIScore) {
                                                    bestIScore = tot;
                                                }
                                            }
                                            ++split;
                                        }
                                        boolean bl3 = foundBetter = bestIScore > oldIScore;
                                        if (foundBetter) {
                                            this.iScore[start][end][parentState] = bestIScore;
                                            if (Double.isInfinite(oldIScore)) {
                                                if (start > this.narrowLExtent[end][parentState]) {
                                                    this.narrowLExtent[end][parentState] = start;
                                                    this.wideLExtent[end][parentState] = start;
                                                } else if (start < this.wideLExtent[end][parentState]) {
                                                    this.wideLExtent[end][parentState] = start;
                                                }
                                                if (end < this.narrowRExtent[start][parentState]) {
                                                    this.narrowRExtent[start][parentState] = end;
                                                    this.wideRExtent[start][parentState] = end;
                                                } else if (end > this.wideRExtent[start][parentState]) {
                                                    this.wideRExtent[start][parentState] = end;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        ++i;
                    }
                    ++pparentState;
                }
                int pState = 0;
                while (pState < this.numStates) {
                    double cur;
                    UnaryRule[] unaries = this.grammar.getClosedViterbiUnaryRulesByParent(pState);
                    double best = cur = this.iScore[start][end][pState];
                    int r = 0;
                    while (r < unaries.length) {
                        UnaryRule ur = unaries[r];
                        short cState = ur.childState;
                        if (pState != cState) {
                            double pS = ur.getScore(0, 0);
                            double iS = this.iScore[start][end][cState];
                            if (!Double.isInfinite(iS)) {
                                double tot = iS + pS;
                                ++this.touchedRules;
                                if (tot > best) {
                                    best = tot;
                                }
                            }
                        }
                        ++r;
                    }
                    if (best > cur) {
                        this.iScore[start][end][pState] = best;
                        if (cur == Double.NEGATIVE_INFINITY) {
                            if (start > this.narrowLExtent[end][pState]) {
                                this.narrowLExtent[end][pState] = start;
                                this.wideLExtent[end][pState] = start;
                            } else if (start < this.wideLExtent[end][pState]) {
                                this.wideLExtent[end][pState] = start;
                            }
                            if (end < this.narrowRExtent[start][pState]) {
                                this.narrowRExtent[start][pState] = end;
                                this.wideRExtent[start][pState] = end;
                            } else if (end > this.wideRExtent[start][pState]) {
                                this.wideRExtent[start][pState] = end;
                            }
                        }
                    }
                    ++pState;
                }
                ++start;
            }
            ++diff;
        }
    }

    private void doOutsideScores() {
        this.grammar.logarithmMode();
        this.lexicon.logarithmMode();
        int diff = this.length;
        while (diff >= 1) {
            int start = 0;
            while (start + diff <= this.length) {
                int end = start + diff;
                int s = 0;
                while (s < this.numStates) {
                    double oS = this.oScore[start][end][s];
                    if (!Double.isInfinite(oS)) {
                        UnaryRule[] rules = this.grammar.getClosedViterbiUnaryRulesByParent(s);
                        int r = 0;
                        while (r < rules.length) {
                            UnaryRule ur = rules[r];
                            double pS = ur.getScore(0, 0);
                            double tot = oS + pS;
                            ++this.touchedRules;
                            if (tot > this.oScore[start][end][ur.childState] && this.iScore[start][end][ur.childState] > Double.NEGATIVE_INFINITY) {
                                this.oScore[start][end][ur.childState] = tot;
                            }
                            ++r;
                        }
                    }
                    ++s;
                }
                s = 0;
                while (s < this.numStates) {
                    BinaryRule[] rules = this.grammar.splitRulesWithP(s);
                    int r = 0;
                    while (r < rules.length) {
                        block15: {
                            int min;
                            int max;
                            double oS;
                            BinaryRule br;
                            block16: {
                                int max1;
                                int min1;
                                br = rules[r];
                                oS = this.oScore[start][end][br.parentState];
                                if (Double.isInfinite(oS) || end < (min1 = this.narrowRExtent[start][br.leftChildState]) || (max1 = this.narrowLExtent[end][br.rightChildState]) < min1) break block15;
                                max = max1;
                                min = min1;
                                if (max - min <= 2) break block16;
                                int min2 = this.wideLExtent[end][br.rightChildState];
                                int n = min = min1 > min2 ? min1 : min2;
                                if (max1 < min) break block15;
                                int max2 = this.wideRExtent[start][br.leftChildState];
                                int n2 = max = max1 < max2 ? max1 : max2;
                                if (max < min) break block15;
                            }
                            double pS = br.getScore(0, 0, 0);
                            int split = min;
                            while (split <= max) {
                                double rS;
                                double lS = this.iScore[start][split][br.leftChildState];
                                if (!Double.isInfinite(lS) && !Double.isInfinite(rS = this.iScore[split][end][br.rightChildState])) {
                                    double totR;
                                    double totL = pS + rS + oS;
                                    ++this.touchedRules;
                                    if (totL > this.oScore[start][split][br.leftChildState]) {
                                        this.oScore[start][split][br.leftChildState] = totL;
                                    }
                                    if ((totR = pS + lS + oS) > this.oScore[split][end][br.rightChildState]) {
                                        this.oScore[split][end][br.rightChildState] = totR;
                                    }
                                }
                                ++split;
                            }
                        }
                        ++r;
                    }
                    ++s;
                }
                ++start;
            }
            --diff;
        }
    }

    void doInsideScores(Tree<StateSet> tree, boolean noSmoothing, boolean debugOutput, double[][][] spanScores) {
        if (this.grammar.isLogarithmMode() || this.lexicon.isLogarithmMode()) {
            throw new Error("Grammar in logarithm mode!  Cannot do inside scores!");
        }
        if (tree.isLeaf()) {
            return;
        }
        List<Tree<StateSet>> children = tree.getChildren();
        for (Tree<StateSet> child : children) {
            if (child.isLeaf()) continue;
            this.doInsideScores(child, noSmoothing, debugOutput, spanScores);
        }
        StateSet parent = tree.getLabel();
        short pState = parent.getState();
        int nParentStates = parent.numSubStates();
        if (tree.isPreTerminal()) {
            StateSet wordStateSet = tree.getChildren().get(0).getLabel();
            double[] lexiconScores = this.lexicon.score(wordStateSet, pState, noSmoothing, false);
            if (lexiconScores.length != nParentStates) {
                System.out.println("Have more scores than substates!" + lexiconScores.length + " " + nParentStates);
            }
            parent.setIScores(lexiconScores);
            parent.scaleIScores(0);
        } else {
            switch (children.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    StateSet child = children.get(0).getLabel();
                    short cState = child.getState();
                    int nChildStates = child.numSubStates();
                    double[][] uscores = this.grammar.getUnaryScore(pState, cState);
                    double[] iScores = new double[nParentStates];
                    boolean foundOne = false;
                    int j = 0;
                    while (j < nChildStates) {
                        double cS;
                        if (uscores[j] != null && (cS = child.getIScore(j)) != 0.0) {
                            int i = 0;
                            while (i < nParentStates) {
                                double rS = uscores[j][i];
                                if (rS != 0.0) {
                                    double res = rS * cS;
                                    int n = i;
                                    iScores[n] = iScores[n] + res;
                                    foundOne = true;
                                }
                                ++i;
                            }
                        }
                        ++j;
                    }
                    if (debugOutput && !foundOne) {
                        System.out.println("iscore reached zero!");
                        System.out.println(this.grammar.getUnaryRule(pState, cState));
                        System.out.println(Arrays.toString(iScores));
                        System.out.println(ArrayUtil.toString(uscores));
                        System.out.println(Arrays.toString(child.getIScores()));
                    }
                    parent.setIScores(iScores);
                    parent.scaleIScores(child.getIScale());
                    break;
                }
                case 2: {
                    StateSet leftChild = children.get(0).getLabel();
                    StateSet rightChild = children.get(1).getLabel();
                    int nLeftChildStates = leftChild.numSubStates();
                    int nRightChildStates = rightChild.numSubStates();
                    short lState = leftChild.getState();
                    short rState = rightChild.getState();
                    double[][][] bscores = this.grammar.getBinaryScore(pState, lState, rState);
                    double[] iScores2 = new double[nParentStates];
                    boolean foundOne2 = false;
                    int j = 0;
                    while (j < nLeftChildStates) {
                        double lcS = leftChild.getIScore(j);
                        if (lcS != 0.0) {
                            int k = 0;
                            while (k < nRightChildStates) {
                                double rcS = rightChild.getIScore(k);
                                if (rcS != 0.0 && bscores[j][k] != null) {
                                    int i = 0;
                                    while (i < nParentStates) {
                                        double rS = bscores[j][k][i];
                                        if (rS != 0.0) {
                                            double res = rS * lcS * rcS;
                                            int n = i;
                                            iScores2[n] = iScores2[n] + res;
                                            foundOne2 = true;
                                        }
                                        ++i;
                                    }
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                    if (spanScores != null) {
                        int i = 0;
                        while (i < nParentStates) {
                            int n = i++;
                            iScores2[n] = iScores2[n] * spanScores[parent.from][parent.to][this.stateClass[pState]];
                        }
                    }
                    if (debugOutput && !foundOne2) {
                        System.out.println("iscore reached zero!");
                        System.out.println(this.grammar.getBinaryRule(pState, lState, rState));
                        System.out.println(Arrays.toString(iScores2));
                        System.out.println(Arrays.toString((Object[])bscores));
                        System.out.println(Arrays.toString(leftChild.getIScores()));
                        System.out.println(Arrays.toString(rightChild.getIScores()));
                    }
                    parent.setIScores(iScores2);
                    parent.scaleIScores(leftChild.getIScale() + rightChild.getIScale());
                    break;
                }
                default: {
                    throw new Error("Malformed tree: more than two children");
                }
            }
        }
    }

    void setRootOutsideScore(Tree<StateSet> tree) {
        tree.getLabel().setOScore(0, 1.0);
        tree.getLabel().setOScale(0);
    }

    void doOutsideScores(Tree<StateSet> tree, boolean unaryAbove, double[][][] spanScores) {
        if (this.grammar.isLogarithmMode() || this.lexicon.isLogarithmMode()) {
            throw new Error("Grammar in logarithm mode!  Cannot do inside scores!");
        }
        if (tree.isLeaf()) {
            return;
        }
        List<Tree<StateSet>> children = tree.getChildren();
        StateSet parent = tree.getLabel();
        short pState = parent.getState();
        int nParentStates = parent.numSubStates();
        if (!tree.isPreTerminal()) {
            double[] parentScores = parent.getOScores();
            if (spanScores != null && !unaryAbove) {
                int i = 0;
                while (i < nParentStates) {
                    int n = i++;
                    parentScores[n] = parentScores[n] * spanScores[parent.from][parent.to][this.stateClass[pState]];
                }
            }
            switch (children.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    StateSet child = children.get(0).getLabel();
                    short cState = child.getState();
                    int nChildStates = child.numSubStates();
                    double[][] uscores = this.grammar.getUnaryScore(pState, cState);
                    double[] oScores = new double[nChildStates];
                    int j = 0;
                    while (j < nChildStates) {
                        if (uscores[j] != null) {
                            double childScore = 0.0;
                            int i = 0;
                            while (i < nParentStates) {
                                double rS;
                                double pS = parentScores[i];
                                if (pS != 0.0 && (rS = uscores[j][i]) != 0.0) {
                                    childScore += pS * rS;
                                }
                                ++i;
                            }
                            oScores[j] = childScore;
                        }
                        ++j;
                    }
                    child.setOScores(oScores);
                    child.scaleOScores(parent.getOScale());
                    unaryAbove = true;
                    break;
                }
                case 2: {
                    StateSet leftChild = children.get(0).getLabel();
                    StateSet rightChild = children.get(1).getLabel();
                    int nLeftChildStates = leftChild.numSubStates();
                    int nRightChildStates = rightChild.numSubStates();
                    short lState = leftChild.getState();
                    short rState = rightChild.getState();
                    double[][][] bscores = this.grammar.getBinaryScore(pState, lState, rState);
                    double[] lOScores = new double[nLeftChildStates];
                    double[] rOScores = new double[nRightChildStates];
                    int j = 0;
                    while (j < nLeftChildStates) {
                        double lcS = leftChild.getIScore(j);
                        double leftScore = 0.0;
                        int k = 0;
                        while (k < nRightChildStates) {
                            double rcS = rightChild.getIScore(k);
                            if (bscores[j][k] != null) {
                                int i = 0;
                                while (i < nParentStates) {
                                    double rS;
                                    double pS = parentScores[i];
                                    if (pS != 0.0 && (rS = bscores[j][k][i]) != 0.0) {
                                        leftScore += pS * rS * rcS;
                                        int n = k;
                                        rOScores[n] = rOScores[n] + pS * rS * lcS;
                                    }
                                    ++i;
                                }
                            }
                            lOScores[j] = leftScore;
                            ++k;
                        }
                        ++j;
                    }
                    leftChild.setOScores(lOScores);
                    leftChild.scaleOScores(parent.getOScale() + rightChild.getIScale());
                    rightChild.setOScores(rOScores);
                    rightChild.scaleOScores(parent.getOScale() + leftChild.getIScale());
                    unaryAbove = false;
                    break;
                }
                default: {
                    throw new Error("Malformed tree: more than two children");
                }
            }
            for (Tree<StateSet> child : children) {
                this.doOutsideScores(child, unaryAbove, spanScores);
            }
        }
    }

    public double doInsideOutsideScores(Tree<StateSet> tree, boolean noSmoothing, boolean debugOutput, double[][][] spanScores) {
        this.doInsideScores(tree, noSmoothing, debugOutput, spanScores);
        this.setRootOutsideScore(tree);
        this.doOutsideScores(tree, false, spanScores);
        double tree_score = tree.getLabel().getIScore(0);
        int tree_scale = tree.getLabel().getIScale();
        return Math.log(tree_score) + (double)(100 * tree_scale);
    }

    public void doInsideOutsideScores(Tree<StateSet> tree, boolean noSmoothing, boolean debugOutput) {
        this.doInsideScores(tree, noSmoothing, debugOutput, null);
        this.setRootOutsideScore(tree);
        this.doOutsideScores(tree, false, null);
    }

    private void createArrays(int length) {
        int end;
        this.clearArrays();
        this.iScore = new double[length][length + 1][];
        int start = 0;
        while (start < length) {
            end = start + 1;
            while (end <= length) {
                this.iScore[start][end] = new double[this.numStates];
                ++end;
            }
            ++start;
        }
        this.oScore = new double[length][length + 1][];
        start = 0;
        while (start < length) {
            end = start + 1;
            while (end <= length) {
                this.oScore[start][end] = new double[this.numStates];
                ++end;
            }
            ++start;
        }
        this.narrowRExtent = new int[length + 1][this.numStates];
        this.wideRExtent = new int[length + 1][this.numStates];
        this.narrowLExtent = new int[length + 1][this.numStates];
        this.wideLExtent = new int[length + 1][this.numStates];
    }

    protected void clearArrays() {
        this.oScore = null;
        this.iScore = null;
        this.wideLExtent = null;
        this.narrowLExtent = null;
        this.wideRExtent = null;
        this.narrowRExtent = null;
    }

    public Tree<String> extractBestParse(int goal, int start, int end, List<String> sentence) {
        this.grammar.logarithmMode();
        this.lexicon.logarithmMode();
        double bestScore = this.iScore[start][end][goal];
        String goalStr = (String)this.tagNumberer.object(goal);
        if (end - start == 1) {
            if (!this.grammar.isGrammarTag[goal]) {
                ArrayList child = new ArrayList();
                child.add(new Tree<String>(sentence.get(start)));
                return new Tree<String>(goalStr, child);
            }
            double veryBestScore = Double.NEGATIVE_INFINITY;
            int newIndex = -1;
            UnaryRule[] unaries = this.grammar.getClosedViterbiUnaryRulesByParent(goal);
            int r = 0;
            while (r < unaries.length) {
                UnaryRule ur = unaries[r];
                double ruleScore = this.iScore[start][end][ur.childState] + this.grammar.getUnaryScore(ur)[0][0];
                if (ruleScore > veryBestScore && goal != ur.childState && !this.grammar.isGrammarTag[ur.getChildState()]) {
                    veryBestScore = ruleScore;
                    newIndex = ur.childState;
                }
                ++r;
            }
            ArrayList child1 = new ArrayList();
            child1.add(new Tree<String>(sentence.get(start)));
            String goalStr1 = (String)this.tagNumberer.object(newIndex);
            ArrayList child = new ArrayList();
            child.add(new Tree<String>(goalStr1, child1));
            return new Tree<String>(goalStr, child);
        }
        int split = start + 1;
        while (split < end) {
            BinaryRule[] parentRules = this.grammar.splitRulesWithP(goal);
            int i = 0;
            while (i < parentRules.length) {
                BinaryRule br = parentRules[i];
                double score = br.getScore(0, 0, 0) + this.iScore[start][split][br.leftChildState] + this.iScore[split][end][br.rightChildState];
                if (this.matches(score, bestScore)) {
                    Tree<String> leftChildTree = this.extractBestParse(br.leftChildState, start, split, sentence);
                    Tree<String> rightChildTree = this.extractBestParse(br.rightChildState, split, end, sentence);
                    ArrayList children = new ArrayList();
                    children.add(leftChildTree);
                    children.add(rightChildTree);
                    Tree<String> result = new Tree<String>(goalStr, children);
                    return result;
                }
                ++i;
            }
            ++split;
        }
        UnaryRule[] unaries = this.grammar.getClosedViterbiUnaryRulesByParent(goal);
        int r = 0;
        while (r < unaries.length) {
            UnaryRule ur = unaries[r];
            double score = ur.getScore(0, 0) + this.iScore[start][end][ur.childState];
            if (ur.childState != ur.parentState && this.matches(score, bestScore)) {
                Tree<String> childTree = this.extractBestParse(ur.childState, start, end, sentence);
                ArrayList children = new ArrayList();
                children.add(childTree);
                Tree<String> result = new Tree<String>(goalStr, children);
                return result;
            }
            ++r;
        }
        System.err.println("Warning: no parse found");
        return null;
    }

    protected void restoreUnaries(Tree<String> t) {
        for (Tree<String> node : t.subTreeList()) {
            if (node.isLeaf() || node.isPreTerminal() || node.getChildren().size() != 1) continue;
            Tree<String> parent = node;
            short pLabel = (short)this.tagNumberer.number(parent.getLabel());
            short cLabel = (short)this.tagNumberer.number(node.getChildren().get(0).getLabel());
            List<short[]> path = this.grammar.getBestViterbiPath(pLabel, (short)0, cLabel, (short)0);
            int pos = 1;
            while (pos < path.size() - 1) {
                short tmp;
                short interState = tmp = path.get(pos)[0];
                Tree<String> intermediate = new Tree<String>((String)this.tagNumberer.object(interState), parent.getChildren());
                ArrayList children = new ArrayList();
                children.add(intermediate);
                parent.setChildren(children);
                parent = intermediate;
                ++pos;
            }
        }
    }

    protected boolean matches(double x, double y) {
        return Math.abs(x - y) / (Math.abs(x) + Math.abs(y) + 1.0E-10) < 1.0E-5;
    }

    public void doViterbiInsideScores(Tree<StateSet> tree) {
        if (tree.isLeaf()) {
            return;
        }
        List<Tree<StateSet>> children = tree.getChildren();
        for (Tree<StateSet> child : children) {
            if (tree.isLeaf()) continue;
            this.doViterbiInsideScores(child);
        }
        StateSet parent = tree.getLabel();
        short pState = parent.getState();
        int nParentStates = this.grammar.numSubStates[pState];
        double[] iScores = new double[nParentStates];
        if (tree.isPreTerminal()) {
            String word = tree.getChildren().get(0).getLabel().getWord();
            short pos = tree.getChildren().get((int)0).getLabel().from;
            iScores = this.lexicon.score(word, pState, pos, false, false);
        } else {
            Arrays.fill(iScores, Double.NEGATIVE_INFINITY);
            switch (children.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    StateSet child = children.get(0).getLabel();
                    short cState = child.getState();
                    int nChildStates = child.numSubStates();
                    double[][] uscores = this.grammar.getUnaryScore(pState, cState);
                    int j = 0;
                    while (j < nChildStates) {
                        double cS;
                        if (uscores[j] != null && (cS = child.getIScore(j)) != Double.NEGATIVE_INFINITY) {
                            int i = 0;
                            while (i < nParentStates) {
                                double rS = uscores[j][i];
                                if (rS != Double.NEGATIVE_INFINITY) {
                                    double res = rS + cS;
                                    iScores[i] = Math.max(iScores[i], res);
                                }
                                ++i;
                            }
                        }
                        ++j;
                    }
                    break;
                }
                case 2: {
                    StateSet leftChild = children.get(0).getLabel();
                    StateSet rightChild = children.get(1).getLabel();
                    int nLeftChildStates = this.grammar.numSubStates[leftChild.getState()];
                    int nRightChildStates = this.grammar.numSubStates[rightChild.getState()];
                    short lState = leftChild.getState();
                    short rState = rightChild.getState();
                    double[][][] bscores = this.grammar.getBinaryScore(pState, lState, rState);
                    BinaryRule[] binaryRuleArray = this.grammar.splitRulesWithP(pState);
                    int n = binaryRuleArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        BinaryRule br = binaryRuleArray[n2];
                        if (br.leftChildState == lState && br.rightChildState == rState) {
                            bscores = br.getScores2();
                        }
                        ++n2;
                    }
                    int j = 0;
                    while (j < nLeftChildStates) {
                        double lcS = leftChild.getIScore(j);
                        if (lcS != Double.NEGATIVE_INFINITY) {
                            int k = 0;
                            while (k < nRightChildStates) {
                                double rcS = rightChild.getIScore(k);
                                if (rcS != Double.NEGATIVE_INFINITY && bscores[j][k] != null) {
                                    int i = 0;
                                    while (i < nParentStates) {
                                        double rS = bscores[j][k][i];
                                        if (rS != Double.NEGATIVE_INFINITY) {
                                            double res = rS + lcS + rcS;
                                            iScores[i] = Math.max(iScores[i], res);
                                        }
                                        ++i;
                                    }
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                    break;
                }
                default: {
                    throw new Error("Malformed tree: more than two children");
                }
            }
        }
        parent.setIScores(iScores);
    }

    Tree<String> extractBestViterbiDerivation(Tree<StateSet> tree, int substate, boolean outputScore, boolean labelOnlyPOS) {
        if (tree.isLeaf()) {
            return new Tree<String>(tree.getLabel().getWord());
        }
        if (substate == -1) {
            substate = 0;
        }
        if (tree.isPreTerminal()) {
            ArrayList child = new ArrayList();
            child.add(this.extractBestViterbiDerivation(tree.getChildren().get(0), -1, outputScore, labelOnlyPOS));
            String goalStr = this.tagNumberer.object(tree.getLabel().getState()) + "-" + substate;
            if (outputScore) {
                goalStr = String.valueOf(goalStr) + " " + tree.getLabel().getIScore(substate);
            }
            return new Tree<String>(goalStr, child);
        }
        StateSet node = tree.getLabel();
        short pState = node.getState();
        ArrayList newChildren = new ArrayList();
        List<Tree<StateSet>> children = tree.getChildren();
        double myScore = node.getIScore(substate);
        if (myScore == Double.NEGATIVE_INFINITY) {
            myScore = DoubleArrays.max(node.getIScores());
            substate = DoubleArrays.argMax(node.getIScores());
        }
        switch (children.size()) {
            case 1: {
                StateSet child = children.get(0).getLabel();
                short cState = child.getState();
                int nChildStates = child.numSubStates();
                double[][] uscores = this.grammar.getUnaryScore(pState, cState);
                int childIndex = -1;
                int j = 0;
                while (j < nChildStates) {
                    double res;
                    double rS;
                    double cS;
                    if (childIndex != -1) break;
                    if (uscores[j] != null && (cS = child.getIScore(j)) != Double.NEGATIVE_INFINITY && (rS = uscores[j][substate]) != Double.NEGATIVE_INFINITY && this.matches(res = rS + cS, myScore)) {
                        childIndex = j;
                    }
                    ++j;
                }
                newChildren.add(this.extractBestViterbiDerivation(children.get(0), childIndex, outputScore, labelOnlyPOS));
                break;
            }
            case 2: {
                StateSet leftChild = children.get(0).getLabel();
                StateSet rightChild = children.get(1).getLabel();
                int nLeftChildStates = leftChild.numSubStates();
                int nRightChildStates = rightChild.numSubStates();
                short lState = leftChild.getState();
                short rState = rightChild.getState();
                double[][][] bscores = this.grammar.getBinaryScore(pState, lState, rState);
                int lChildIndex = -1;
                int rChildIndex = -1;
                int j = 0;
                while (j < nLeftChildStates) {
                    if (lChildIndex != -1 && rChildIndex != -1) break;
                    double lcS = leftChild.getIScore(j);
                    if (lcS != Double.NEGATIVE_INFINITY) {
                        int k = 0;
                        while (k < nRightChildStates) {
                            double res;
                            double rS;
                            if (lChildIndex != -1 && rChildIndex != -1) break;
                            double rcS = rightChild.getIScore(k);
                            if (rcS != Double.NEGATIVE_INFINITY && bscores[j][k] != null && (rS = bscores[j][k][substate]) != Double.NEGATIVE_INFINITY && this.matches(myScore, res = rS + lcS + rcS)) {
                                lChildIndex = j;
                                rChildIndex = k;
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                newChildren.add(this.extractBestViterbiDerivation(children.get(0), lChildIndex, outputScore, labelOnlyPOS));
                newChildren.add(this.extractBestViterbiDerivation(children.get(1), rChildIndex, outputScore, labelOnlyPOS));
                break;
            }
            default: {
                throw new Error("Malformed tree: more than two children");
            }
        }
        String parentString = (String)this.tagNumberer.object(node.getState());
        if (parentString.endsWith("^g")) {
            parentString = parentString.substring(0, parentString.length() - 2);
        }
        if (!labelOnlyPOS) {
            parentString = String.valueOf(parentString) + "-" + substate;
        }
        if (outputScore) {
            parentString = String.valueOf(parentString) + " " + myScore;
        }
        return new Tree<String>(parentString, newChildren);
    }

    public Tree<String> getBestViterbiDerivation(Tree<StateSet> tree, boolean outputScore, boolean labelOnlyPOS) {
        this.doViterbiInsideScores(tree);
        if (tree.getLabel().getIScore(0) == Double.NEGATIVE_INFINITY) {
            return null;
        }
        return this.extractBestViterbiDerivation(tree, 0, outputScore, labelOnlyPOS);
    }

    public void incrementExpectedGoldCounts(Linearizer linearizer, double[] probs, Tree<StateSet> tree) {
        double tree_score = tree.getLabel().getIScore(0);
        int tree_scale = tree.getLabel().getIScale();
        this.incrementExpectedGoldCounts(linearizer, probs, tree, tree_score, tree_scale);
    }

    public void incrementExpectedGoldCounts(Linearizer linearizer, double[] probs, Tree<StateSet> tree, double tree_score, int tree_scale) {
        if (tree.isLeaf()) {
            return;
        }
        if (tree.isPreTerminal()) {
            StateSet parent = tree.getLabel();
            StateSet child = tree.getChildren().get(0).getLabel();
            short tag = tree.getLabel().getState();
            short nSubStates = this.grammar.numSubStates[tag];
            double d = ScalingTools.calcScaleFactor(parent.getOScale() + parent.getIScale() - tree_scale);
            short substate = 0;
            while (substate < nSubStates) {
                double pOS;
                double pIS = parent.getIScore(substate);
                if (pIS != 0.0 && (pOS = parent.getOScore(substate)) != 0.0) {
                    double weight = 1.0;
                    weight = pIS / tree_score * d * pOS;
                    if (weight > 1.01) {
                        System.out.println("Overflow when counting tags? " + weight);
                        weight = 0.0;
                    }
                    this.tmpCountsArray[substate] = weight;
                }
                substate = (short)(substate + 1);
            }
            linearizer.increment(probs, child, tag, this.tmpCountsArray, true);
            return;
        }
        List<Tree<StateSet>> children = tree.getChildren();
        StateSet parent = tree.getLabel();
        short parentState = parent.getState();
        short nParentSubStates = this.grammar.numSubStates[parentState];
        switch (children.size()) {
            case 0: {
                break;
            }
            case 1: {
                StateSet stateSet = children.get(0).getLabel();
                short childState = stateSet.getState();
                int curInd = 0;
                short nChildSubStates = this.grammar.numSubStates[childState];
                UnaryRule urule = this.grammar.getUnaryRule(parentState, childState);
                double[][] oldUScores = urule.getScores2();
                double scalingFactor = ScalingTools.calcScaleFactor(parent.getOScale() + stateSet.getIScale() - tree_scale);
                short i = 0;
                while (i < nChildSubStates) {
                    if (oldUScores[i] != null) {
                        double cIS = stateSet.getIScore(i);
                        short j = 0;
                        while (j < nParentSubStates) {
                            double rS;
                            double pOS;
                            ++curInd;
                            if (cIS != 0.0 && (pOS = parent.getOScore(j)) != 0.0 && (rS = oldUScores[i][j]) != 0.0) {
                                double ruleCount;
                                if (tree_score == 0.0) {
                                    tree_score = 1.0;
                                }
                                if ((ruleCount = rS * cIS / tree_score * scalingFactor * pOS) > 1.01) {
                                    System.out.println("Overflow when counting binaries? " + ruleCount);
                                    ruleCount = 0.0;
                                }
                                if (ruleCount != 0.0) {
                                    this.tmpCountsArray[curInd - 1] = ruleCount;
                                }
                            }
                            j = (short)(j + 1);
                        }
                        if (parentState == 0) {
                            curInd += nChildSubStates - 1;
                        }
                    }
                    i = (short)(i + 1);
                }
                linearizer.increment(probs, urule, this.tmpCountsArray, true);
                break;
            }
            case 2: {
                StateSet leftChild = children.get(0).getLabel();
                short lChildState = leftChild.getState();
                StateSet rightChild = children.get(1).getLabel();
                short rChildState = rightChild.getState();
                short nLeftChildSubStates = this.grammar.numSubStates[lChildState];
                short nRightChildSubStates = this.grammar.numSubStates[rChildState];
                int curInd = 0;
                BinaryRule brule = this.grammar.getBinaryRule(parentState, lChildState, rChildState);
                double[][][] oldBScores = brule.getScores2();
                double scalingFactor = ScalingTools.calcScaleFactor(parent.getOScale() + leftChild.getIScale() + rightChild.getIScale() - tree_scale);
                int nRuleStates = oldBScores[0][0].length;
                int divisor = nParentSubStates / nRuleStates;
                if (divisor == 0) {
                    System.out.println("not possible");
                }
                short i = 0;
                while (i < nLeftChildSubStates) {
                    double lcIS = leftChild.getIScore(i);
                    short j = 0;
                    while (j < nRightChildSubStates) {
                        double ruleCount;
                        double rS;
                        double pOS;
                        double rcIS;
                        short k;
                        if (nRuleStates == nParentSubStates) {
                            k = 0;
                            while (k < nParentSubStates) {
                                ++curInd;
                                if (lcIS != 0.0 && (rcIS = rightChild.getIScore(j)) != 0.0 && (pOS = parent.getOScore(k)) != 0.0 && (rS = oldBScores[i][j][k]) != 0.0) {
                                    if (tree_score == 0.0) {
                                        tree_score = 1.0;
                                    }
                                    if ((ruleCount = rS * lcIS / tree_score * rcIS * scalingFactor * pOS) > 1.01) {
                                        System.out.println("Overflow when counting unaries? " + ruleCount);
                                        ruleCount = 0.0;
                                    }
                                    if (ruleCount > 0.0) {
                                        this.tmpCountsArray[curInd - 1] = ruleCount;
                                    }
                                }
                                k = (short)(k + 1);
                            }
                        } else {
                            k = 0;
                            while (k < nParentSubStates) {
                                ++curInd;
                                if (lcIS != 0.0 && (rcIS = rightChild.getIScore(j)) != 0.0 && (pOS = parent.getOScore(k)) != 0.0 && (rS = oldBScores[i / divisor][j / divisor][k / divisor]) != 0.0) {
                                    if (tree_score == 0.0) {
                                        tree_score = 1.0;
                                    }
                                    if ((ruleCount = rS * lcIS / tree_score * rcIS * scalingFactor * pOS) > 1.01) {
                                        System.out.println("Overflow when counting unaries? " + ruleCount);
                                        ruleCount = 0.0;
                                    }
                                    if (ruleCount > 0.0) {
                                        this.tmpCountsArray[curInd - 1] = ruleCount;
                                    }
                                }
                                k = (short)(k + 1);
                            }
                        }
                        j = (short)(j + 1);
                    }
                    i = (short)(i + 1);
                }
                linearizer.increment(probs, brule, this.tmpCountsArray, true);
                break;
            }
            default: {
                throw new Error("Malformed tree: more than two children");
            }
        }
        for (Tree<StateSet> tree2 : children) {
            this.incrementExpectedGoldCounts(linearizer, probs, tree2, tree_score, tree_scale);
        }
    }

    public void countPosteriors(double[][] cumulativePosteriors, Tree<StateSet> tree, double tree_score, int tree_scale) {
        if (tree.isLeaf()) {
            return;
        }
        StateSet node = tree.getLabel();
        short state = node.getState();
        short nSubStates = this.grammar.numSubStates[state];
        double scalingFactor = ScalingTools.calcScaleFactor(node.getOScale() + node.getIScale() - tree_scale);
        short substate = 0;
        while (substate < nSubStates) {
            double pOS;
            double pIS = node.getIScore(substate);
            if (pIS != 0.0 && (pOS = node.getOScore(substate)) != 0.0) {
                double weight = 1.0;
                weight = pIS / tree_score * scalingFactor * pOS;
                if (weight > 1.01) {
                    System.out.println("Overflow when counting tags? " + weight);
                    weight = 0.0;
                }
                double[] dArray = cumulativePosteriors[state];
                short s = substate;
                dArray[s] = dArray[s] + weight;
            }
            substate = (short)(substate + 1);
        }
        for (Tree<StateSet> child : tree.getChildren()) {
            this.countPosteriors(cumulativePosteriors, child, tree_score, tree_scale);
        }
    }
}

