/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.Rule;
import edu.berkeley.nlp.util.ArrayUtil;
import edu.berkeley.nlp.util.Numberer;
import edu.berkeley.nlp.util.StringUtils;
import java.io.Serializable;
import java.util.Random;

public class BinaryRule
extends Rule
implements Serializable,
Comparable {
    public short leftChildState = (short)-1;
    public short rightChildState = (short)-1;
    public double[][][] scores;
    private static final char[] charsToEscape = new char[]{'\"'};
    private static final long serialVersionUID = 2L;

    public BinaryRule(short pState, short lState, short rState, double[][][] scores) {
        this.parentState = pState;
        this.leftChildState = lState;
        this.rightChildState = rState;
        this.scores = scores;
    }

    public BinaryRule(short pState, short lState, short rState) {
        this.parentState = pState;
        this.leftChildState = lState;
        this.rightChildState = rState;
    }

    public BinaryRule(BinaryRule b) {
        this(b.parentState, b.leftChildState, b.rightChildState, ArrayUtil.copy(b.scores));
    }

    public BinaryRule(BinaryRule b, double[][][] newScores) {
        this(b.parentState, b.leftChildState, b.rightChildState, newScores);
    }

    public int hashCode() {
        return this.parentState << 16 ^ this.leftChildState << 8 ^ this.rightChildState;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BinaryRule) {
            BinaryRule br = (BinaryRule)o;
            if (this.parentState == br.parentState && this.leftChildState == br.leftChildState && this.rightChildState == br.rightChildState) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        String pState;
        String rState;
        Numberer n = Numberer.getGlobalNumberer("tags");
        String lState = (String)n.object(this.leftChildState);
        if (lState.endsWith("^g")) {
            lState = lState.substring(0, lState.length() - 2);
        }
        if ((rState = (String)n.object(this.rightChildState)).endsWith("^g")) {
            rState = rState.substring(0, rState.length() - 2);
        }
        if ((pState = (String)n.object(this.parentState)).endsWith("^g")) {
            pState = pState.substring(0, pState.length() - 2);
        }
        StringBuilder sb = new StringBuilder();
        if (this.scores == null) {
            return String.valueOf(pState) + " -> " + lState + " " + rState + "\n";
        }
        int lS = 0;
        while (lS < this.scores.length) {
            int rS = 0;
            while (rS < this.scores[lS].length) {
                if (this.scores[lS][rS] != null) {
                    int pS = 0;
                    while (pS < this.scores[lS][rS].length) {
                        double p = this.scores[lS][rS][pS];
                        if (p > 0.0) {
                            sb.append(String.valueOf(pState) + "_" + pS + " -> " + lState + "_" + lS + " " + rState + "_" + rS + " " + p + "\n");
                        }
                        ++pS;
                    }
                }
                ++rS;
            }
            ++lS;
        }
        return sb.toString();
    }

    public String toString_old() {
        Numberer n = Numberer.getGlobalNumberer("tags");
        return "\"" + StringUtils.escapeString(n.object(this.parentState).toString(), charsToEscape, '\\') + "\" -> \"" + StringUtils.escapeString(n.object(this.leftChildState).toString(), charsToEscape, '\\') + "\" \"" + StringUtils.escapeString(n.object(this.rightChildState).toString(), charsToEscape, '\\') + "\" " + ArrayUtil.toString(this.scores);
    }

    public int compareTo(Object o) {
        BinaryRule ur = (BinaryRule)o;
        if (this.parentState < ur.parentState) {
            return -1;
        }
        if (this.parentState > ur.parentState) {
            return 1;
        }
        if (this.leftChildState < ur.leftChildState) {
            return -1;
        }
        if (this.leftChildState > ur.leftChildState) {
            return 1;
        }
        if (this.rightChildState < ur.rightChildState) {
            return -1;
        }
        if (this.rightChildState > ur.rightChildState) {
            return 1;
        }
        return 0;
    }

    public short getLeftChildState() {
        return this.leftChildState;
    }

    public short getRightChildState() {
        return this.rightChildState;
    }

    public double getScore(int pS, int lS, int rS) {
        if (this.scores[lS][rS] == null) {
            if (this.logarithmMode) {
                return Double.NEGATIVE_INFINITY;
            }
            return 0.0;
        }
        return this.scores[lS][rS][pS];
    }

    public void setScores2(double[][][] scores) {
        this.scores = scores;
    }

    public double[][][] getScores2() {
        return this.scores;
    }

    public void setNodes(short pState, short lState, short rState) {
        this.parentState = pState;
        this.leftChildState = lState;
        this.rightChildState = rState;
    }

    public BinaryRule splitRule(short[] numSubStates, short[] newNumSubStates, Random random, double randomness, boolean doNotNormalize, int mode) {
        int parentSplitFactor;
        int n = parentSplitFactor = this.getParentState() == 0 ? 1 : 2;
        if (newNumSubStates[this.parentState] == numSubStates[this.parentState]) {
            parentSplitFactor = 1;
        }
        int lChildSplitFactor = 2;
        if (newNumSubStates[this.leftChildState] == numSubStates[this.leftChildState]) {
            lChildSplitFactor = 1;
        }
        int rChildSplitFactor = 2;
        if (newNumSubStates[this.rightChildState] == numSubStates[this.rightChildState]) {
            rChildSplitFactor = 1;
        }
        double[][][] oldScores = this.getScores2();
        double[][][] newScores = new double[oldScores.length * lChildSplitFactor][oldScores[0].length * rChildSplitFactor][];
        int lcS = 0;
        while (lcS < oldScores.length) {
            int rcS = 0;
            while (rcS < oldScores[0].length) {
                if (oldScores[lcS][rcS] != null) {
                    int lc = 0;
                    while (lc < lChildSplitFactor) {
                        int rc = 0;
                        while (rc < rChildSplitFactor) {
                            short newLCS = (short)(lChildSplitFactor * lcS + lc);
                            short newRCS = (short)(rChildSplitFactor * rcS + rc);
                            newScores[newLCS][newRCS] = new double[newNumSubStates[this.parentState]];
                            rc = (short)(rc + 1);
                        }
                        lc = (short)(lc + 1);
                    }
                    int pS = 0;
                    while (pS < oldScores[lcS][rcS].length) {
                        double score = oldScores[lcS][rcS][pS];
                        int p = 0;
                        while (p < parentSplitFactor) {
                            double divFactor = doNotNormalize ? 1.0 : (double)(lChildSplitFactor * rChildSplitFactor);
                            double randomComponentLC = score / divFactor * randomness / 100.0 * (random.nextDouble() - 0.5);
                            int lc2 = 0;
                            while (lc2 < lChildSplitFactor) {
                                if (lc2 == 1) {
                                    randomComponentLC *= -1.0;
                                }
                                if (lChildSplitFactor == 1) {
                                    randomComponentLC = 0.0;
                                }
                                double randomComponentRC = score / divFactor * randomness / 100.0 * (random.nextDouble() - 0.5);
                                int rc = 0;
                                while (rc < rChildSplitFactor) {
                                    if (rc == 1) {
                                        randomComponentRC *= -1.0;
                                    }
                                    if (rChildSplitFactor == 1) {
                                        randomComponentRC = 0.0;
                                    }
                                    short newPS = (short)(parentSplitFactor * pS + p);
                                    short newLCS = (short)(lChildSplitFactor * lcS + lc2);
                                    short newRCS = (short)(rChildSplitFactor * rcS + rc);
                                    double splitFactor = doNotNormalize ? 1.0 : (double)(lChildSplitFactor * rChildSplitFactor);
                                    newScores[newLCS][newRCS][newPS] = score / splitFactor + randomComponentLC + randomComponentRC;
                                    if (mode == 2) {
                                        newScores[newLCS][newRCS][newPS] = 1.0 + random.nextDouble() / 100.0;
                                    }
                                    rc = (short)(rc + 1);
                                }
                                lc2 = (short)(lc2 + 1);
                            }
                            p = (short)(p + 1);
                        }
                        pS = (short)(pS + 1);
                    }
                }
                rcS = (short)(rcS + 1);
            }
            lcS = (short)(lcS + 1);
        }
        BinaryRule newRule = new BinaryRule(this, newScores);
        return newRule;
    }
}

