/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.ConditionalTrainer;
import edu.berkeley.nlp.PCFGLA.GrammarTester;
import edu.berkeley.nlp.PCFGLA.OptionParser;
import edu.berkeley.nlp.PCFGLA.ParserConstrainer;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;

public class ConditionalPipeline {
    public static boolean initializeWithZero = true;

    public static void main(String[] args) {
        OptionParser optParser = new OptionParser(ConditionalTrainer.Options.class);
        ConditionalTrainer.Options opts = (ConditionalTrainer.Options)optParser.parse(args, true);
        String dirName = opts.outDir;
        String baseName = "split_";
        File directory = new File(dirName);
        if (!directory.mkdir()) {
            System.out.println("Failed to make directory.");
        }
        File nextFile = null;
        ArrayList<String> baselineArgsList = new ArrayList<String>(Arrays.asList("-path", opts.path, "-trfr", "" + opts.trainingFractionToKeep, "-treebank", "" + (Object)((Object)opts.treebank), "-out", String.valueOf(dirName) + "/" + "base_gen.gr", "-baseline", "-maxL", String.valueOf(opts.maxL), "-b", "" + (Object)((Object)opts.binarization)));
        if (opts.markUnaryParents) {
            baselineArgsList.add("-markUnaryParents");
        }
        if (opts.markUnaryParents) {
            baselineArgsList.add("-filterStupidFrickinWHNP");
        }
        if (opts.collapseUnaries) {
            baselineArgsList.add("-collapseUnaries");
        }
        String[] baselineArgs = baselineArgsList.toArray(new String[0]);
        nextFile = new File(String.valueOf(dirName) + "/" + "base_gen.gr");
        if (opts.initializeDir == null) {
            if (!nextFile.exists() || opts.dontLoad) {
                ConditionalTrainer.main(baselineArgs);
            } else {
                System.out.println("Skipping this step since " + nextFile.toString() + " already exists.");
            }
            String[] consArgsTrain = ConditionalPipeline.addOptions(args, new String[]{"-out", String.valueOf(dirName) + "/" + baseName + "0", "-in", String.valueOf(dirName) + "/" + "base_gen.gr", "-outputLog", String.valueOf(dirName) + "/" + baseName + "0.cons.log"});
            nextFile = new File(String.valueOf(dirName) + "/" + baseName + "0-0.data");
            if (nextFile.exists() && !opts.dontLoad) {
                System.out.println("Skipping this step since " + nextFile.toString() + " already exists.");
            } else {
                ParserConstrainer.main(consArgsTrain);
                consArgsTrain = ConditionalPipeline.addOptions(args, new String[]{"-out", String.valueOf(dirName) + "/" + baseName + "0_dev", "-in", String.valueOf(dirName) + "/" + "base_gen.gr", "-section", "dev", "-nChunks", "1", "-outputLog", String.valueOf(dirName) + "/" + baseName + "0_dev.cons.log"});
                ParserConstrainer.main(consArgsTrain);
                consArgsTrain = ConditionalPipeline.addOptions(args, new String[]{"-out", String.valueOf(dirName) + "/" + baseName + "0_test", "-in", String.valueOf(dirName) + "/" + "base_gen.gr", "-section", "final", "-nChunks", "1", "-outputLog", String.valueOf(dirName) + "/" + baseName + "0_test.cons.log"});
                ParserConstrainer.main(consArgsTrain);
            }
        }
        nextFile = new File(String.valueOf(dirName) + "/" + baseName + "0.gr");
        String[] baselineCondArgs = null;
        baselineCondArgs = opts.initializeDir != null ? ConditionalPipeline.addOptions(args, new String[]{"-out", nextFile.toString(), "-cons", String.valueOf(opts.initializeDir) + "/" + baseName + "0", "-in", String.valueOf(opts.initializeDir) + "/" + baseName + "0.gr", "-doNOTprojectConstraints", "-noSplit", "-doConditional"}) : ConditionalPipeline.addOptions(args, new String[]{"-out", nextFile.toString(), "-cons", String.valueOf(dirName) + "/" + baseName + "0", initializeWithZero ? "-initializeZero" : "", "-doNOTprojectConstraints", "-noSplit", "-doConditional"});
        if (!nextFile.exists() || opts.dontLoad) {
            ConditionalTrainer.main(baselineCondArgs);
            if (opts.testAll) {
                System.out.println("Testing all grammars to determine which one was the best and should be split next");
                String[] testArgs = new String[]{"-doNOTprojectConstraints", "-cons", String.valueOf(dirName) + "/" + baseName + "0_dev-0.data", "-testAll", "-path", opts.path, "-in", String.valueOf(baseName) + "0.gr", "-filePath", opts.outDir, "-treebank", "" + (Object)((Object)opts.treebank), "-maxL", String.valueOf(opts.maxL), "-parser", "plain", "-nProcess", String.valueOf(opts.nProcess)};
                GrammarTester.main(testArgs);
            }
        } else {
            System.out.println("Skipping this step since " + nextFile.toString() + " already exists.");
        }
        int split = 1;
        while (split <= 6) {
            System.out.println("\n\nIn " + split + ". Split-Iteration.");
            String previousGrammar = String.valueOf(dirName) + "/" + baseName + (split - 1);
            String currentGrammar = String.valueOf(dirName) + "/" + baseName + split;
            String[] trainArgs = null;
            if (opts.initializeDir == null) {
                nextFile = new File(String.valueOf(currentGrammar) + ".gr");
                trainArgs = ConditionalPipeline.addOptions(args, new String[]{"-in", String.valueOf(previousGrammar) + ".gr", "-doConditional", "-cons", previousGrammar, "-out", nextFile.toString()});
            } else {
                nextFile = new File(String.valueOf(currentGrammar) + ".gr");
                trainArgs = ConditionalPipeline.addOptions(args, new String[]{"-in", String.valueOf(opts.initializeDir) + "/" + baseName + split + ".gr", "-doConditional", "-noSplit", "-cons", String.valueOf(opts.initializeDir) + "/" + baseName + (split - 1), "-out", nextFile.toString()});
            }
            if (!nextFile.exists() || opts.dontLoad) {
                ConditionalTrainer.main(trainArgs);
                if (opts.testAll) {
                    System.out.println("Testing all grammars to determine which one was the best and should be split next");
                    String[] testArgs = new String[]{"-cons", String.valueOf(dirName) + "/" + baseName + (split - 1) + "_dev-0.data", "-testAll", "-path", opts.path, "-in", String.valueOf(baseName) + split + ".gr", "-filePath", opts.outDir, "-treebank", "" + (Object)((Object)opts.treebank), "-maxL", String.valueOf(opts.maxL), "-parser", "plain", "-nProcess", String.valueOf(opts.nProcess)};
                    GrammarTester.main(testArgs);
                }
            } else {
                System.out.println("Skipping this step since " + nextFile.toString() + " already exists.");
            }
            if (opts.initializeDir == null) {
                nextFile = new File(String.valueOf(currentGrammar) + "-0.data");
                if (nextFile.exists() && !opts.dontLoad) {
                    System.out.println("Skipping this step since " + nextFile.toString() + " already exists.");
                } else {
                    String[] consArgs = ConditionalPipeline.addOptions(args, new String[]{"-cons", previousGrammar, "-out", currentGrammar, "-in", String.valueOf(currentGrammar) + ".gr", "-outputLog", String.valueOf(currentGrammar) + ".cons.log"});
                    ParserConstrainer.main(consArgs);
                    consArgs = ConditionalPipeline.addOptions(args, new String[]{"-cons", String.valueOf(previousGrammar) + "_dev", "-out", String.valueOf(currentGrammar) + "_dev", "-in", String.valueOf(currentGrammar) + ".gr", "-section", "dev", "-nChunks", "1", "-outputLog", String.valueOf(currentGrammar) + "_dev.cons.log"});
                    ParserConstrainer.main(consArgs);
                    consArgs = ConditionalPipeline.addOptions(args, new String[]{"-cons", String.valueOf(previousGrammar) + "_test", "-out", String.valueOf(currentGrammar) + "_test", "-in", String.valueOf(currentGrammar) + ".gr", "-section", "final", "-nChunks", "1", "-outputLog", String.valueOf(currentGrammar) + "_test.cons.log"});
                }
            }
            ++split;
        }
        System.exit(0);
    }

    private static String[] addOptions(String[] a, String[] b) {
        String[] res = new String[a.length + b.length];
        int i = 0;
        while (i < a.length) {
            res[i] = a[i];
            ++i;
        }
        i = 0;
        while (i < b.length) {
            res[i + a.length] = b[i];
            ++i;
        }
        return res;
    }
}

