/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.Grammar;
import edu.berkeley.nlp.PCFGLA.Lexicon;
import edu.berkeley.nlp.PCFGLA.ParserData;
import edu.berkeley.nlp.PCFGLA.smoothing.SmoothAcrossParentBits;
import edu.berkeley.nlp.util.CommandLineUtils;
import java.util.Map;

public class GrammarSmoother {
    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("usage: java GrammarSmoother \n\t\t  -i       Input File for Grammar (Required)\n\t\t  -o       Output File for Smoothed Grammar (Required)\n\t\t  -smooth  Type of grammar smoothing used.  This takes the maximum likelihood rule\n               probabilities and smooths them with each other.  Current options are\n               'NoSmoothing', 'SmoothAcrossParentSubstate', and 'SmoothAcrossParentBits'.\n\t\t  -grsm    Grammar smoothing parameter, in range [0,1].  (Default: 0.1)\n");
            System.exit(2);
        }
        System.out.print("Running with arguments:  ");
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            System.out.print(" '" + arg + "'");
            ++n2;
        }
        System.out.println("");
        Map<String, String> input = CommandLineUtils.simpleCommandLineParser(args);
        String outFileName = CommandLineUtils.getValueOrUseDefault(input, "-o", null);
        String inFileName = CommandLineUtils.getValueOrUseDefault(input, "-i", null);
        System.out.println("Loading grammar from " + inFileName + ".");
        ParserData pData2 = ParserData.Load(inFileName);
        if (pData2 == null) {
            System.out.println("Failed to load grammar from file" + inFileName + ".");
            System.exit(1);
        }
        Grammar gr = pData2.getGrammar();
        SmoothAcrossParentBits grSmoother = new SmoothAcrossParentBits(0.01, gr.splitTrees);
        SmoothAcrossParentBits lexSmoother = new SmoothAcrossParentBits(0.1, gr.splitTrees);
        gr.setSmoother(grSmoother);
        pData2.gr = gr;
        Lexicon lex = pData2.getLexicon();
        lex.setSmoother(lexSmoother);
        pData2.lex = lex;
        if (pData2.Save(outFileName)) {
            System.out.println("Saving successful.");
        } else {
            System.out.println("Saving failed!");
        }
        System.exit(0);
    }
}

