/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.CoarseToFineMaxRuleDerivationParser;
import edu.berkeley.nlp.PCFGLA.CoarseToFineMaxRuleParser;
import edu.berkeley.nlp.PCFGLA.CoarseToFineMaxRuleProductParser;
import edu.berkeley.nlp.PCFGLA.CoarseToFineNBestParser;
import edu.berkeley.nlp.PCFGLA.ConstrainedArrayParser;
import edu.berkeley.nlp.PCFGLA.ConstrainedHierarchicalTwoChartParser;
import edu.berkeley.nlp.PCFGLA.ConstrainedTwoChartsParser;
import edu.berkeley.nlp.PCFGLA.Corpus;
import edu.berkeley.nlp.PCFGLA.Grammar;
import edu.berkeley.nlp.PCFGLA.HierarchicalAdaptiveGrammar;
import edu.berkeley.nlp.PCFGLA.Lexicon;
import edu.berkeley.nlp.PCFGLA.MultiThreadedParserWrapper;
import edu.berkeley.nlp.PCFGLA.Option;
import edu.berkeley.nlp.PCFGLA.OptionParser;
import edu.berkeley.nlp.PCFGLA.ParserConstrainer;
import edu.berkeley.nlp.PCFGLA.ParserData;
import edu.berkeley.nlp.PCFGLA.SpanPredictor;
import edu.berkeley.nlp.PCFGLA.TreeAnnotations;
import edu.berkeley.nlp.PCFGLA.smoothing.SmoothAcrossParentSubstate;
import edu.berkeley.nlp.parser.EnglishPennTreebankParseEvaluator;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.syntax.Trees;
import edu.berkeley.nlp.util.Numberer;
import edu.berkeley.nlp.util.Pair;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrammarTester
implements Callable {
    public static ParserFactory externalParserFactory = null;
    List<Tree<String>> testTrees;
    boolean[][][][][] cons;
    String fileName;
    int maxSentenceLength;

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        block84: {
            block85: {
                optParser = new OptionParser(Options.class);
                opts = (Options)optParser.parse(args, true);
                System.out.println("Calling with " + optParser.getPassedInOptions());
                path = opts.path;
                System.out.println("Loading trees from " + path + " and using treebank type " + (Object)opts.treebank);
                maxSentenceLength = opts.maxSentenceLength;
                System.out.println("Will remove sentences with more than " + maxSentenceLength + " words.");
                testSetString = opts.section;
                devTestSet = testSetString.equals("dev");
                finalTestSet = testSetString.equals("final");
                trainTestSet = testSetString.equals("train");
                if (!(devTestSet || finalTestSet || trainTestSet)) {
                    System.out.println("I didn't understand dev/final test set argument " + testSetString);
                    System.exit(1);
                }
                System.out.println(" using " + testSetString + " test set");
                cons = null;
                if (opts.computeConstraints) {
                    args1 = new String[]{};
                    dirName = ".";
                    baseName = "tmp";
                    consArgsTrain = GrammarTester.addOptions(args1, new String[]{"-logT", "" + opts.logT, "-maxL", "" + opts.maxSentenceLength, "-path", opts.path, "-filterStupidFrickinWHNP", opts.filterStupidFrickinWHNP != false ? "true" : "false", "-markUnaryParents", "true", "-out", String.valueOf(dirName) + "/" + baseName + "0_" + opts.section, "-in", opts.inFileName, "-section", opts.section, "-nChunks", "1", "-outputLog", String.valueOf(dirName) + "/" + baseName + ".cons.log"});
                    ParserConstrainer.main(consArgsTrain);
                    opts.cons = String.valueOf(dirName) + "/" + baseName + "0_" + opts.section + "-0.data";
                }
                if (opts.cons != null) {
                    cons = ParserConstrainer.loadData(opts.cons);
                }
                corpus = new Corpus(path, opts.treebank, 1.0, trainTestSet == false);
                testTrees = null;
                if (devTestSet) {
                    testTrees = corpus.getDevTestingTrees();
                }
                if (finalTestSet) {
                    testTrees = corpus.getFinalTestingTrees();
                }
                if (trainTestSet) {
                    testTrees = corpus.getTrainTrees();
                }
                if (opts.lowercase) {
                    System.out.println("Lowercasing the treebank.");
                    Corpus.lowercaseWords(testTrees);
                }
                v0 = inFileName = opts.testAll != false ? String.valueOf(opts.filePath) + "/" + opts.inFileName : opts.inFileName;
                if (inFileName == null) {
                    throw new Error("Did not provide a grammar.");
                }
                System.out.println("Loading grammar from " + inFileName + ".");
                finalLevel = opts.finalLevel;
                if (finalLevel != -1) {
                    System.out.println("Parsing with projected grammar from level " + finalLevel + ".");
                }
                if (viterbiParse = opts.viterbi) {
                    System.out.println("Computing viterbi derivation instead of max-rule parse.");
                }
                doVariational = false;
                useGoldPOS = opts.useGoldPOS;
                parser = null;
                eval = new EnglishPennTreebankParseEvaluator.LabeledConstituentEval<String>(new HashSet<String>(Arrays.asList(new String[]{"ROOT", "PSEUDO"})), new HashSet<String>(Arrays.asList(new String[]{"''", "``", ".", ":", ","})));
                tmpEval = null;
                System.out.println("The computed F1,LP,LR scores are just a rough guide. They are typically 0.1-0.2 lower than the official EVALB scores.");
                if (GrammarTester.externalParserFactory == null) {
                    if (opts.nGrammars != 1) {
                        grammars = new Grammar[opts.nGrammars];
                        lexicons = new Lexicon[opts.nGrammars];
                        bin = null;
                        nGr = 0;
                        while (nGr < opts.nGrammars) {
                            inFileName = String.valueOf(opts.inFileName) + "." + nGr;
                            pData = ParserData.Load(inFileName);
                            Numberer.setNumberers(pData.getNumbs());
                            if (pData == null) {
                                System.out.println("Failed to load grammar from file" + inFileName + ".");
                                System.exit(1);
                            }
                            grammars[nGr] = pData.getGrammar();
                            lexicons[nGr] = pData.getLexicon();
                            Numberer.setNumberers(pData.getNumbs());
                            bin = pData.getBinarization();
                            ++nGr;
                        }
                        parser = new CoarseToFineMaxRuleProductParser(grammars, lexicons, opts.unaryPenalty, -1, opts.viterbi, false, false, opts.accurate, false, true, true);
                        parser.binarization = bin;
                    } else {
                        pData = ParserData.Load(inFileName);
                        if (pData == null) {
                            System.out.println("Failed to load grammar from file" + inFileName + ".");
                            System.exit(1);
                        }
                        grammar = pData.getGrammar();
                        grammar.splitRules();
                        lexicon = pData.getLexicon();
                        spanPredictor = pData.getSpanPredictor();
                        if (Options.smooth) {
                            System.out.println("Smoothing only lexicon.");
                            lexSmoother = new SmoothAcrossParentSubstate(0.01);
                            lexicon.setSmoother(lexSmoother);
                        }
                        Numberer.setNumberers(pData.getNumbs());
                        if ("plain".equals(opts.parser)) {
                            testTrees = Corpus.filterTreesForConditional(testTrees, opts.filterAllUnaries, opts.filterStupidFrickinWHNP, false);
                            grammar.clearUnaryIntermediates();
                            if (grammar instanceof HierarchicalAdaptiveGrammar) {
                                lexicon.explicitlyComputeScores(grammar.finalLevel);
                                parser = new ConstrainedHierarchicalTwoChartParser(grammar, lexicon, spanPredictor, grammar.finalLevel);
                            } else {
                                parser = new ConstrainedTwoChartsParser(grammar, lexicon, spanPredictor);
                            }
                            if (opts.viterbi) {
                                parser.viterbi = true;
                            }
                        } else if ("basic".equals(opts.parser)) {
                            parser = new ConstrainedArrayParser(grammar, lexicon, grammar.numSubStates);
                        } else if ("kbest".equals(opts.parser)) {
                            parser = new CoarseToFineNBestParser(grammar, lexicon, opts.k, opts.unaryPenalty, finalLevel, viterbiParse, false, false, opts.accurate, doVariational, useGoldPOS, true);
                            tmpEval = new EnglishPennTreebankParseEvaluator.LabeledConstituentEval<String>(Collections.singleton("ROOT"), new HashSet<String>(Arrays.asList(new String[]{"''", "``", ".", ":", ","})));
                        } else {
                            parser = "maxderivation".equals(opts.parser) != false ? new CoarseToFineMaxRuleDerivationParser(grammar, lexicon, opts.unaryPenalty, finalLevel, viterbiParse, false, false, opts.accurate, doVariational, useGoldPOS, true) : new CoarseToFineMaxRuleParser(grammar, lexicon, opts.unaryPenalty, finalLevel, viterbiParse, false, false, opts.accurate, doVariational, useGoldPOS, true);
                        }
                        parser.binarization = pData.getBinarization();
                    }
                }
                kBestParsing = "kbest".equals(opts.parser);
                if (opts.allSubstatesAllowed) {
                    System.out.println("All substates are allowed.");
                }
                if (opts.filterTrees) {
                    testTrees = Corpus.filterTreesForConditional(testTrees, opts.filterAllUnaries, opts.filterStupidFrickinWHNP, false);
                }
                if (opts.nThreads <= 1) break block84;
                System.out.println("Parsing with " + opts.nThreads + " threads in parallel.");
                m_parser = new MultiThreadedParserWrapper(parser, opts.nThreads);
                treeNumber = 0;
                newList = new ArrayList<Tree<String>>();
                for (Tree<String> testTree : testTrees) {
                    testSentence = testTree.getYield();
                    sentenceLength = testSentence.size();
                    if (sentenceLength > maxSentenceLength) continue;
                    newList.add(testTree);
                }
                testTrees = newList;
                for (Tree<String> testTree : testTrees) {
                    testSentence = testTree.getYield();
                    sentenceLength = testSentence.size();
                    if (sentenceLength > maxSentenceLength) {
                        System.out.println("()\n");
                        continue;
                    }
                    m_parser.parseThisSentence(testSentence);
                    while (m_parser.hasNext()) {
                        parsedTrees = m_parser.getNext();
                        tTree = testTrees.get(treeNumber++);
                        bestTree = null;
                        if (kBestParsing) {
                            bestFscore = -1.0;
                            for (Tree<String> pTree : parsedTrees) {
                                f1 = tmpEval.evaluate(pTree = TreeAnnotations.unAnnotateTree(pTree, false), tTree, false);
                                if (!(f1 > bestFscore)) continue;
                                bestTree = pTree;
                                bestFscore = f1;
                            }
                        } else {
                            bestTree = parsedTrees.get(0);
                            bestTree = TreeAnnotations.unAnnotateTree(bestTree, false);
                        }
                        if (!bestTree.getChildren().isEmpty()) {
                            System.out.println(bestTree.getChildren().get(0));
                        } else {
                            System.out.println("()\n");
                        }
                        eval.evaluate(bestTree, tTree);
                    }
                }
                break block85;
                {
                    parsedTrees = m_parser.getNext();
                    tTree = testTrees.get(treeNumber++);
                    bestTree = null;
                    if (kBestParsing) {
                        bestFscore = -1.0;
                        for (Tree<String> pTree : parsedTrees) {
                            pTree = TreeAnnotations.unAnnotateTree(pTree, false);
                            if (opts.printAllKBest) {
                                System.out.println("\t" + pTree);
                            }
                            if (!((f1 = tmpEval.evaluate(pTree, tTree, false)) > bestFscore)) continue;
                            bestTree = pTree;
                            bestFscore = f1;
                        }
                    } else {
                        bestTree = parsedTrees.get(0);
                        bestTree = TreeAnnotations.unAnnotateTree(bestTree, false);
                    }
                    if (!bestTree.getChildren().isEmpty()) {
                        System.out.println(bestTree.getChildren().get(0));
                    } else {
                        System.out.println("()\n");
                    }
                    if (opts.printGoldTree) {
                        System.out.println(tTree.getChildren().get(0));
                    }
                    eval.evaluate(bestTree, tTree);
lbl180:
                    // 2 sources

                    while (true) {
                        if (m_parser.hasNext()) continue block8;
                        break;
                    }
                }
            }
            ** while (!m_parser.isDone())
lbl184:
            // 1 sources

            System.out.println("Parsed " + treeNumber + " sentences.");
            eval.display(true);
            System.out.println("The computed F1,LP,LR scores are just a rough guide. They are typically 0.1-0.2 lower than the official EVALB scores.");
            System.exit(0);
        }
        if (!opts.testAll) {
            i = 0;
            totalGoldPruned = 0;
            totalPruned = 0;
            for (Tree<String> testTree : testTrees) {
                testSentence = testTree.getYield();
                sentenceLength = testSentence.size();
                if (sentenceLength > maxSentenceLength) {
                    System.out.println("()\n");
                    continue;
                }
                posTags = null;
                if (useGoldPOS) {
                    posTags = testTree.getPreTerminalYield();
                }
                allowedStates = null;
                if (cons != null) {
                    if (cons[i] == null) {
                        ++i;
                        continue;
                    }
                    if (!opts.doNOTprojectConstraints) {
                        parser.projectConstraints(cons[i], opts.allSubstatesAllowed);
                    }
                    allowedStates = cons[i];
                }
                parsedTree = null;
                if (kBestParsing) {
                    list = parser.getKBestConstrainedParses(testSentence, posTags, opts.k);
                    bestFscore = 0.0;
                    for (Tree<String> tree : list) {
                        tmp = TreeAnnotations.unAnnotateTree(tree, false);
                        if (opts.printAllKBest) {
                            System.out.println("\t" + tmp);
                        }
                        if (!((f1 = tmpEval.evaluate(tmp, testTree, false)) > bestFscore)) continue;
                        parsedTree = tmp;
                        bestFscore = f1;
                    }
                    if (parsedTree == null) {
                        parsedTree = new Tree<String>("ROOT");
                    }
                } else {
                    parsedTree = parser.getBestConstrainedParse(testSentence, posTags, allowedStates);
                    if (opts.verbose) {
                        System.out.println("Annotated result:\n" + Trees.PennTreeRenderer.render(parsedTree));
                    }
                    parsedTree = TreeAnnotations.unAnnotateTree(parsedTree, false);
                    if (useGoldPOS && parsedTree.getChildren().isEmpty()) {
                        parsedTree = parser.getBestConstrainedParse(testSentence, null, allowedStates);
                        parsedTree = TreeAnnotations.unAnnotateTree(parsedTree, false);
                    }
                }
                if (!parsedTree.getChildren().isEmpty()) {
                    System.out.println(parsedTree.getChildren().get(0));
                } else {
                    System.out.println("()\nLength: " + sentenceLength);
                }
                numGoldPruned = 0;
                numPruned = 0;
                if (opts.evaluateConstraints && cons != null) {
                    numGoldPruned = GrammarTester.countPrunedNodes(testTree, allowedStates, Numberer.getGlobalNumberer("tags"), false, 0, testTree.getYield().size());
                    numPruned = GrammarTester.countPrunedNodes(allowedStates, Numberer.getGlobalNumberer("tags"), false, 0, testTree.getYield().size());
                    System.out.println("Pruned " + numGoldPruned + " constituents.");
                    totalGoldPruned += numGoldPruned;
                    totalPruned += numPruned;
                }
                if (opts.printGoldTree) {
                    System.out.println("Gold: " + testTree.getChildren().get(0));
                }
                eval.evaluate(parsedTree, testTree);
                if (++i > opts.maxSentences) break;
            }
            if (opts.evaluateConstraints) {
                System.out.println("Pruned total of " + totalGoldPruned + " gold constituents out of a total of " + totalPruned + " constituents pruned.");
            }
            eval.display(true);
            System.out.println("The computed F1,LP,LR scores are just a rough guide. They are typically 0.1-0.2 lower than the official EVALB scores.");
        } else {
            k = 0;
            for (Tree<String> testTree : testTrees) {
                testSentence = testTree.getYield();
                sentenceLength = testSentence.size();
                if (sentenceLength > maxSentenceLength) {
                    System.out.println("()\n");
                    continue;
                }
                allowedStates = null;
                if (cons != null) {
                    if (cons[k] == null) {
                        ++k;
                        continue;
                    }
                    if (!opts.doNOTprojectConstraints) {
                        parser.projectConstraints(cons[k], opts.allSubstatesAllowed);
                    }
                }
                ++k;
            }
            fileList = null;
            fileName = opts.inFileName;
            if (opts.testAll) {
                filter = new FilenameFilter(){

                    public boolean accept(File arg0, String arg1) {
                        return arg1.startsWith(fileName);
                    }
                };
                fileList = new File(opts.filePath).listFiles(filter);
                DATE_COMPARE = new Comparator(){
                    private Date d1 = new Date();
                    private Date d2 = new Date();

                    public int compare(Object file1, Object file2) {
                        this.d1.setTime(((File)file1).lastModified());
                        this.d2.setTime(((File)file2).lastModified());
                        return this.d1.compareTo(this.d2);
                    }
                };
                Arrays.sort(fileList, DATE_COMPARE);
            } else {
                fileList = new File[1];
            }
            nProcess = opts.nProcess;
            bestF1 = -1.0;
            bestGrammar = null;
            pool = Executors.newFixedThreadPool(nProcess);
            submits = new Future[nProcess];
            f = 0;
            while (f < fileList.length) {
                thisThreadConstrainer = null;
                i = 0;
                while (i < nProcess) {
                    fName = f + i < fileList.length ? fileList[f + i].getName() : fileList[f].getName();
                    thisGrammar = String.valueOf(opts.filePath) + "/" + fName;
                    tester = new GrammarTester(thisGrammar, testTrees, maxSentenceLength, cons);
                    submits[i] = pool.submit(tester);
                    ++i;
                }
                do {
                    done = true;
                    var36_71 = submits;
                    var35_64 = submits.length;
                    thisGrammar = 0;
                    while (thisGrammar < var35_64) {
                        task = var36_71[thisGrammar];
                        done &= task.isDone();
                        ++thisGrammar;
                    }
                } while (!done);
                try {
                    i = 0;
                    while (i < nProcess) {
                        res = (Pair)submits[i].get();
                        System.out.print(String.valueOf((String)res.getSecond()) + "\t");
                        thisF1 = ((EnglishPennTreebankParseEvaluator.LabeledConstituentEval)res.getFirst()).display(true);
                        if (opts.printAllF1) {
                            System.out.println(String.valueOf((String)res.getSecond()) + " had F1 " + thisF1);
                        }
                        if (thisF1 > bestF1) {
                            bestF1 = thisF1;
                            bestGrammar = (String)res.getSecond();
                        }
                        ++i;
                    }
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                f += nProcess;
            }
            System.out.println("The best F1 was: " + bestF1);
            System.out.println("The best grammar was: " + bestGrammar);
            finalGrammar = new File(bestGrammar);
            finalGrammar.renameTo(new File(String.valueOf(opts.filePath) + "/" + opts.inFileName));
            pool.shutdown();
        }
        if (!opts.testAll) {
            System.exit(0);
        }
    }

    public GrammarTester(String fName, List<Tree<String>> tT, int maxL, boolean[][][][][] c) {
        this.testTrees = tT;
        this.cons = c;
        this.fileName = fName;
        this.maxSentenceLength = maxL;
    }

    public static int countPrunedNodes(boolean[][][][] allowedStates, Numberer globalNumberer, boolean b, int start, int end) {
        int total = 0;
        int i = start;
        while (i < end) {
            int j = i + 1;
            while (j <= end) {
                int state = 0;
                while (state < allowedStates[i][j].length) {
                    if (!GrammarTester.hasTrue(allowedStates[i][j][state])) {
                        ++total;
                    }
                    ++state;
                }
                ++j;
            }
            ++i;
        }
        return total;
    }

    public static List<Integer>[][][] loadData(String fileName) {
        List[][][] data = null;
        try {
            FileInputStream fis = new FileInputStream(fileName);
            GZIPInputStream gzis = new GZIPInputStream(fis);
            ObjectInputStream in = new ObjectInputStream(gzis);
            data = (List[][][])in.readObject();
            in.close();
        }
        catch (IOException e) {
            System.out.println("IOException\n" + e);
            return null;
        }
        catch (ClassNotFoundException e) {
            System.out.println("Class not found!");
            return null;
        }
        return data;
    }

    private static String[] addOptions(String[] a, String[] b) {
        String[] res = new String[a.length + b.length];
        int i = 0;
        while (i < a.length) {
            res[i] = a[i];
            ++i;
        }
        i = 0;
        while (i < b.length) {
            res[i + a.length] = b[i];
            ++i;
        }
        return res;
    }

    private static boolean isAllowed(String label, Numberer tagNumberer, boolean[][] cons, boolean isPreTerminal) {
        int state = 0;
        while (state < cons.length) {
            String asString;
            boolean[] allowed = cons[state];
            assert (tagNumberer.total() > state);
            String unannotatedLabel = asString = (String)tagNumberer.object(state);
            if (!isPreTerminal) {
                unannotatedLabel = TreeAnnotations.unAnnotateTree(new Tree<String>(asString, Collections.singletonList(new Tree<String>("FakeLabel"))), false).getLabel();
            }
            if (unannotatedLabel.equals(label) && GrammarTester.hasTrue(allowed)) {
                return true;
            }
            ++state;
        }
        return false;
    }

    public static int countPrunedNodes(Tree<String> tree, boolean[][][][] cons, Numberer tagNumberer, boolean splitRoot, int from, int to) {
        int total = 0;
        if (!GrammarTester.isAllowed(tree.getLabel(), tagNumberer, cons[from][to], tree.isPreTerminal())) {
            ++total;
        }
        if (tree.isPreTerminal()) {
            return total;
        }
        for (Tree<String> child : tree.getChildren()) {
            short length = (short)child.getYield().size();
            total += GrammarTester.countPrunedNodes(child, cons, tagNumberer, true, from, from + length);
            from += length;
        }
        return total;
    }

    public static boolean hasTrue(boolean[] a) {
        boolean hasTrue = false;
        if (a == null) {
            return hasTrue;
        }
        boolean[] blArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            boolean b = blArray[n2];
            hasTrue |= b;
            ++n2;
        }
        return hasTrue;
    }

    public Pair<EnglishPennTreebankParseEvaluator.LabeledConstituentEval<String>, String> call() throws Exception {
        EnglishPennTreebankParseEvaluator.LabeledConstituentEval<String> eval = new EnglishPennTreebankParseEvaluator.LabeledConstituentEval<String>(Collections.singleton("ROOT"), new HashSet<String>(Arrays.asList("''", "``", ".", ":", ",")));
        ParserData pData2 = ParserData.Load(this.fileName);
        if (pData2 == null) {
            System.out.println("Failed to load grammar from file" + this.fileName + ".");
            System.exit(1);
        }
        Grammar grammar = pData2.getGrammar();
        grammar.splitRules();
        Lexicon lexicon = pData2.getLexicon();
        grammar.clearUnaryIntermediates();
        lexicon.explicitlyComputeScores(grammar.finalLevel);
        if (Options.smooth) {
            System.out.println("Smoothing only the lexicon.");
            SmoothAcrossParentSubstate lexSmoother = new SmoothAcrossParentSubstate(0.01);
            lexicon.setSmoother(lexSmoother);
        }
        SpanPredictor spanPredictor = pData2.getSpanPredictor();
        ConstrainedTwoChartsParser parser = null;
        if (grammar instanceof HierarchicalAdaptiveGrammar) {
            lexicon.explicitlyComputeScores(grammar.finalLevel);
            parser = new ConstrainedHierarchicalTwoChartParser(grammar, lexicon, spanPredictor, grammar.finalLevel);
        } else {
            parser = new ConstrainedTwoChartsParser(grammar, lexicon, spanPredictor);
        }
        int i = 0;
        for (Tree<String> testTree : this.testTrees) {
            List<String> testSentence = testTree.getYield();
            int sentenceLength = testSentence.size();
            if (sentenceLength > this.maxSentenceLength) continue;
            Tree<String> parsedTree = null;
            boolean[][][][] con = this.cons == null ? null : this.cons[i];
            parsedTree = ((ConstrainedArrayParser)parser).getBestConstrainedParse(testSentence, null, con);
            parsedTree = TreeAnnotations.unAnnotateTree(parsedTree, false);
            eval.evaluate(parsedTree, testTree, false);
            ++i;
        }
        return new Pair<EnglishPennTreebankParseEvaluator.LabeledConstituentEval<String>, String>(eval, this.fileName);
    }

    public static class Options {
        @Option(name="-in", required=true, usage="Input File for Grammar (Required)\n")
        public String inFileName;
        @Option(name="-path", usage="Path to Corpus (Default: null)\n")
        public String path = null;
        @Option(name="-treebank", usage="Language:  WSJ, CHNINESE, GERMAN, CONLL, SINGLEFILE (Default: ENGLISH)")
        public Corpus.TreeBankType treebank = Corpus.TreeBankType.WSJ;
        @Option(name="-maxL", usage="Maximum sentence length (Default <=40)")
        public int maxSentenceLength = 160;
        @Option(name="-section", usage="On which part of the WSJ to test: train/dev/test (Default: dev)")
        public String section = "dev";
        @Option(name="-maxS", usage="Maximum number of sentences (Default all)")
        public int maxSentences = 1000000;
        @Option(name="-parser", usage="Parser type: c-to-f, plain, kbest, basic, maxderivation")
        public String parser = "c-to-f";
        @Option(name="-k", usage="k for k-best parsing")
        public int k = 1;
        @Option(name="-cons", usage="Constraints for plain parser")
        public String cons = null;
        @Option(name="-viterbi", usage="Compute viterbi derivation instead of max-rule parse (Default: max-rule)")
        public boolean viterbi = false;
        @Option(name="-allowAllSubstates", usage="Don't prune at the substate level")
        public boolean allowAllSubstates = false;
        @Option(name="-unaryPenalty", usage="Unary penalty (Default: 1.0)")
        public double unaryPenalty = 1.0;
        @Option(name="-finalLevel", usage="Parse with projected grammar from this level (Default: -1 = input grammar)")
        public int finalLevel = -1;
        @Option(name="-verbose", usage="Verbose/Quiet (Default: Quiet)\n")
        public boolean verbose = false;
        @Option(name="-accurate", usage="Set thresholds for accuracy. (Default: set thresholds for efficiency)")
        public boolean accurate = false;
        @Option(name="-useGoldPOS", usage="Use gold part of speech tags (Default: false)")
        public boolean useGoldPOS = false;
        @Option(name="-smooth", usage="Smooth the parameters before parsing")
        public static boolean smooth = false;
        @Option(name="-doNOTprojectConstraints", usage="Do NOT project constraints")
        public boolean doNOTprojectConstraints = false;
        @Option(name="-nThreads", usage="Parse in parallel using this many threads (Default: 1).")
        public int nThreads = 1;
        @Option(name="-filterTrees", usage="Parse in parallel using this many threads (Default: 1).")
        public boolean filterTrees = false;
        @Option(name="-filterAllUnaries", usage="Mark any unary parent with a ^u")
        public boolean filterAllUnaries = false;
        @Option(name="-filterStupidFrickinWHNP", usage="Temp hack!")
        public boolean filterStupidFrickinWHNP = false;
        @Option(name="-printGoldTree", usage="Print (flat) gold tree")
        public boolean printGoldTree = false;
        @Option(name="-computeConstraints", usage="Compute constraints from the given grammar (rather than loading with -cons)")
        public boolean computeConstraints = false;
        @Option(name="-evaluateConstraints", usage="Evaluate search errors from constraints")
        public boolean evaluateConstraints = false;
        @Option(name="-logT", usage="Threshold for constraints")
        public double logT = -10.0;
        @Option(name="-printAllKBest", usage="Print every kBest parse")
        public boolean printAllKBest = false;
        @Option(name="-testAll", usage="Test all grammar files starting with this name")
        public boolean testAll = false;
        @Option(name="-filePath", usage="Path for grammars to be tested")
        public String filePath = null;
        @Option(name="-nProcess", usage="Parse in parallel using this many threads (Default: 1).")
        public int nProcess = 1;
        @Option(name="-lowercase", usage="Lowercase all words in the treebank")
        public boolean lowercase = false;
        @Option(name="-allSubstatesAllowed", usage="When using constraints whether to prune on the substate level")
        public boolean allSubstatesAllowed = false;
        @Option(name="-printAllF1", usage="Print all F1 scores (when using testAll)")
        public boolean printAllF1 = false;
        @Option(name="-nGrammars", usage="Use a product model based on that many grammars")
        public int nGrammars = 1;
    }

    public static interface ParserFactory {
        public ConstrainedArrayParser newParser(Grammar var1, Lexicon var2, SpanPredictor var3);
    }
}

