/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.HierarchicalAdaptiveLexicalRule;
import edu.berkeley.nlp.PCFGLA.HierarchicalFullyConnectedAdaptiveLexicon;
import edu.berkeley.nlp.PCFGLA.SimpleLexicon;
import edu.berkeley.nlp.PCFGLA.StateSetTreeList;
import edu.berkeley.nlp.PCFGLA.smoothing.Smoother;
import edu.berkeley.nlp.syntax.StateSet;
import edu.berkeley.nlp.syntax.StateSetWithFeatures;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.util.Counter;
import edu.berkeley.nlp.util.Indexer;
import edu.berkeley.nlp.util.Numberer;
import edu.berkeley.nlp.util.Pair;
import edu.berkeley.nlp.util.PriorityQueue;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchicalFullyConnectedAdaptiveLexiconWithFeatures
extends HierarchicalFullyConnectedAdaptiveLexicon {
    private static final long serialVersionUID = 1L;
    Indexer<String> featureIndexer;
    SimpleLexicon simpleLex;
    private final int minFeatureCount = 50;

    public HierarchicalFullyConnectedAdaptiveLexiconWithFeatures(short[] numSubStates, int smoothingCutoff, double[] smoothParam, Smoother smoother, StateSetTreeList trainTrees, int knownWordCount) {
        super(numSubStates, knownWordCount);
        this.simpleLex = new SimpleLexicon(numSubStates, -1.0);
        this.init(trainTrees);
    }

    @Override
    public void init(StateSetTreeList trainTrees) {
        for (Tree<StateSet> tree : trainTrees) {
            Iterator words = tree.getYield();
            Iterator<StateSet> iterator = words.iterator();
            while (iterator.hasNext()) {
                StateSet word = iterator.next();
                String sig = word.getWord();
                this.wordIndexer.add(sig);
            }
        }
        this.wordCounter = new int[this.wordIndexer.size()];
        Counter<String> ixCounter = new Counter<String>();
        this.featureIndexer = new Indexer();
        for (Tree tree : trainTrees) {
            List words = tree.getYield();
            int ind = 0;
            Iterator iterator = words.iterator();
            while (iterator.hasNext()) {
                StateSet word = (StateSet)iterator.next();
                String wordString = word.getWord();
                int n = this.wordIndexer.indexOf(wordString);
                this.wordCounter[n] = this.wordCounter[n] + 1;
                String sig = this.getSignature(word.getWord(), ind++);
                this.wordIndexer.add(sig);
                this.tallyWordFeatures(word.getWord(), ixCounter);
            }
        }
        this.featureIndexer = new Indexer();
        for (String word : ixCounter.keySet()) {
            if (ixCounter.getCount(word) >= 50.0) {
                System.out.println("keeping: \t" + word);
                this.featureIndexer.add(word);
                continue;
            }
            System.out.println("too rare:\t" + word);
        }
        this.simpleLex.wordCounter = this.wordCounter;
        this.labelTrees(trainTrees);
        this.tagWordIndexer = new SimpleLexicon.IntegerIndexer[this.numStates];
        int tag = 0;
        while (tag < this.numStates) {
            this.tagWordIndexer[tag] = new SimpleLexicon.IntegerIndexer(this.featureIndexer.size());
            ++tag;
        }
        boolean[] lexTag = new boolean[this.numStates];
        for (Tree tree : trainTrees) {
            List words = tree.getYield();
            List tags = tree.getPreTerminalYield();
            int ind = 0;
            for (StateSet word : words) {
                short tag2 = ((StateSet)tags.get(ind)).getState();
                StateSetWithFeatures wordF = (StateSetWithFeatures)word;
                for (Integer f : wordF.features) {
                    this.tagWordIndexer[tag2].add(f);
                }
                lexTag[tag2] = true;
                ++ind;
            }
        }
        this.expectedCounts = new double[this.numStates][][];
        this.scores = new double[this.numStates][][];
        int tag3 = 0;
        while (tag3 < this.numStates) {
            if (!lexTag[tag3]) {
                this.tagWordIndexer[tag3] = null;
            } else {
                this.scores[tag3] = new double[this.numSubStates[tag3]][this.tagWordIndexer[tag3].size()];
            }
            ++tag3;
        }
        this.nWords = this.wordIndexer.size();
        this.scores = null;
        this.hierarchicalScores = null;
        this.finalLevels = null;
        this.rules = new HierarchicalAdaptiveLexicalRule[this.numStates][];
        tag3 = 0;
        while (tag3 < this.numStates) {
            if (this.tagWordIndexer[tag3] == null) {
                this.rules[tag3] = new HierarchicalAdaptiveLexicalRule[0];
            } else {
                this.rules[tag3] = new HierarchicalAdaptiveLexicalRule[this.tagWordIndexer[tag3].size()];
                int word = 0;
                while (word < this.rules[tag3].length) {
                    this.rules[tag3][word] = new HierarchicalAdaptiveLexicalRule();
                    ++word;
                }
            }
            ++tag3;
        }
    }

    private void tallyWordFeatures(String word, Counter<String> ixCounter) {
        int length = word.length();
        if (length > 4) {
            int i = 1;
            while (i < 4) {
                String suffix = "SUFF-" + word.substring(length - i);
                this.featureIndexer.add(suffix);
                ixCounter.incrementCount(suffix, 1.0);
                ++i;
            }
        }
    }

    public StateSet tallyFeatures(StateSet stateSet, boolean update) {
        String word = stateSet.getWord();
        String lowered = word.toLowerCase();
        short loc = stateSet.from;
        String sig = this.simpleLex.getNewSignature(word, loc);
        StateSetWithFeatures newStateSet = new StateSetWithFeatures(stateSet);
        if (update) {
            this.featureIndexer.add(sig);
        }
        newStateSet.features.add(this.featureIndexer.indexOf(sig));
        if (update) {
            this.featureIndexer.add("UNK");
        }
        newStateSet.features.add(this.featureIndexer.indexOf("UNK"));
        int length = word.length();
        if (length > 4) {
            int i = 1;
            while (i < 4) {
                String suffix = "SUFF-" + lowered.substring(length - i);
                int suffInd = this.featureIndexer.indexOf(suffix);
                if (suffInd >= 0) {
                    newStateSet.features.add(suffInd);
                }
                ++i;
            }
        }
        int wlen = word.length();
        int numCaps = 0;
        boolean hasDigit = false;
        boolean hasDash = false;
        boolean hasLower = false;
        int i = 0;
        while (i < wlen) {
            char ch = word.charAt(i);
            if (Character.isDigit(ch)) {
                hasDigit = true;
            } else if (ch == '-') {
                hasDash = true;
            } else if (Character.isLetter(ch)) {
                if (Character.isLowerCase(ch)) {
                    hasLower = true;
                } else if (Character.isTitleCase(ch)) {
                    hasLower = true;
                    ++numCaps;
                } else {
                    ++numCaps;
                }
            }
            ++i;
        }
        char ch0 = word.charAt(0);
        if (Character.isUpperCase(ch0) || Character.isTitleCase(ch0)) {
            if (loc == 0 && numCaps == 1) {
                if (update) {
                    this.featureIndexer.add("INITC");
                }
                newStateSet.features.add(this.featureIndexer.indexOf("INITC"));
            } else {
                if (update) {
                    this.featureIndexer.add("CAPS");
                }
                newStateSet.features.add(this.featureIndexer.indexOf("CAPS"));
            }
        } else if (!Character.isLetter(ch0) && numCaps > 0) {
            if (update) {
                this.featureIndexer.add("CAPS");
            }
            newStateSet.features.add(this.featureIndexer.indexOf("CAPS"));
        } else if (hasLower) {
            if (update) {
                this.featureIndexer.add("LC");
            }
            newStateSet.features.add(this.featureIndexer.indexOf("LC"));
        }
        if (hasDigit) {
            if (update) {
                this.featureIndexer.add("NUM");
            }
            newStateSet.features.add(this.featureIndexer.indexOf("NUM"));
        }
        if (hasDash) {
            if (update) {
                this.featureIndexer.add("DASH");
            }
            newStateSet.features.add(this.featureIndexer.indexOf("DASH"));
        }
        if (lowered.endsWith("s") && wlen >= 3) {
            char ch2 = lowered.charAt(wlen - 2);
            if (ch2 != 's' && ch2 != 'i' && ch2 != 'u') {
                if (update) {
                    this.featureIndexer.add("s");
                }
                newStateSet.features.add(this.featureIndexer.indexOf("s"));
            }
        } else if (word.length() < 5 || hasDash || hasDigit) {
            // empty if block
        }
        return newStateSet;
    }

    @Override
    public void labelTrees(StateSetTreeList trainTrees) {
        for (Tree<StateSet> tree : trainTrees) {
            int ind = 0;
            for (Tree<StateSet> word : tree.getTerminals()) {
                StateSetWithFeatures wordF = new StateSetWithFeatures(word.getLabel());
                if (wordF.wordIndex < 0 || wordF.wordIndex >= this.wordCounter.length) {
                    System.out.println("Have never seen this word before: " + wordF.getWord() + " " + wordF.wordIndex);
                    System.out.println(tree);
                } else if (this.wordCounter[wordF.wordIndex] <= this.knownWordCount) {
                    wordF = (StateSetWithFeatures)this.tallyFeatures(wordF, false);
                } else {
                    wordF.sigIndex = -1;
                }
                this.featureIndexer.add(wordF.getWord());
                wordF.features.add(this.featureIndexer.indexOf(wordF.getWord()));
                word.setLabel(wordF);
                ++ind;
            }
        }
    }

    @Override
    public double[] score(StateSet stateSet, short tag, boolean noSmoothing, boolean isSignature) {
        double[] res = new double[this.numSubStates[tag]];
        Arrays.fill(res, 1.0);
        StateSetWithFeatures stateSetF = null;
        if (stateSet.wordIndex == -2) {
            int f;
            stateSetF = new StateSetWithFeatures(stateSet);
            int wordIndex = this.wordIndexer.indexOf(stateSet.getWord());
            if (wordIndex < 0 || wordIndex >= 0 && this.wordCounter[wordIndex] <= this.knownWordCount) {
                stateSetF = (StateSetWithFeatures)this.tallyFeatures(stateSet, false);
            }
            if ((f = this.featureIndexer.indexOf(stateSet.getWord())) >= 0) {
                stateSetF.features.add(f);
            }
        } else {
            stateSetF = (StateSetWithFeatures)stateSet;
        }
        boolean noFeat = true;
        for (int f : stateSetF.features) {
            int tagF;
            if (f < 0 || (tagF = this.tagWordIndexer[tag].indexOf(f)) < 0) continue;
            noFeat = false;
            double[] resF = this.rules[tag][tagF].scores;
            int i = 0;
            while (i < res.length) {
                int n = i;
                res[n] = res[n] * resF[i];
                ++i;
            }
        }
        return res;
    }

    @Override
    public String toString() {
        int wordT;
        String tagS;
        int[] counts;
        StringBuffer sb = new StringBuffer();
        Numberer tagNumberer = Numberer.getGlobalNumberer("tags");
        PriorityQueue<Pair<Integer, Integer>> pQ = new PriorityQueue<Pair<Integer, Integer>>();
        int tag = 0;
        while (tag < this.rules.length) {
            counts = new int[6];
            tagS = (String)tagNumberer.object(tag);
            if (this.rules[tag].length != 0) {
                int word = 0;
                while (word < this.featureIndexer.size()) {
                    String w;
                    wordT = this.tagWordIndexer[tag].indexOf(word);
                    if (wordT >= 0 && (w = this.featureIndexer.get(word)).length() > 4 && w.substring(0, 4).equals("SUFF")) {
                        pQ.add(new Pair<Integer, Integer>(tag, word), this.rules[tag][wordT].scores[0]);
                    }
                    ++word;
                }
            }
            ++tag;
        }
        while (pQ.hasNext()) {
            Pair p = (Pair)pQ.next();
            int word = (Integer)p.getSecond();
            int tag2 = (Integer)p.getFirst();
            String tagS2 = (String)tagNumberer.object(tag2);
            wordT = this.tagWordIndexer[tag2].indexOf(word);
            sb.append(String.valueOf(tagS2) + " " + this.featureIndexer.get(word) + "\n");
            sb.append(this.rules[tag2][wordT].toString());
            sb.append("\n\n");
        }
        sb.append("-----------Start unsorted----------\n");
        tag = 0;
        while (tag < this.rules.length) {
            counts = new int[6];
            tagS = (String)tagNumberer.object(tag);
            if (this.rules[tag].length != 0) {
                int word = 0;
                while (word < this.featureIndexer.size()) {
                    wordT = this.tagWordIndexer[tag].indexOf(word);
                    if (wordT >= 0) {
                        sb.append(String.valueOf(tagS) + " " + this.featureIndexer.get(word) + "\n");
                        sb.append(this.rules[tag][wordT].toString());
                        sb.append("\n\n");
                        int n = this.rules[tag][wordT].hierarchy.getDepth();
                        counts[n] = counts[n] + 1;
                    }
                    ++word;
                }
                System.out.print(tagNumberer.object(tag) + ", lexical rules per level: ");
                int i = 1;
                while (i < 6) {
                    System.out.print(String.valueOf(counts[i]) + " ");
                    ++i;
                }
                System.out.print("\n");
            }
            ++tag;
        }
        return sb.toString();
    }
}

