/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.BinaryRule;
import edu.berkeley.nlp.PCFGLA.Grammar;
import edu.berkeley.nlp.PCFGLA.GrammarTrainer;
import edu.berkeley.nlp.PCFGLA.HierarchicalBinaryRule;
import edu.berkeley.nlp.PCFGLA.HierarchicalUnaryRule;
import edu.berkeley.nlp.PCFGLA.Rule;
import edu.berkeley.nlp.PCFGLA.UnaryRule;
import edu.berkeley.nlp.PCFGLA.smoothing.Smoother;
import java.io.IOException;
import java.io.Writer;

public class HierarchicalGrammar
extends Grammar {
    private static final long serialVersionUID = 1L;

    public HierarchicalGrammar(short[] nSubStates, boolean findClosedPaths, Smoother smoother, Grammar oldGrammar, double thresh) {
        super(nSubStates, findClosedPaths, smoother, oldGrammar, thresh);
    }

    public HierarchicalGrammar(Grammar gr) {
        super(gr.numSubStates, gr.findClosedPaths, gr.smoother, gr, gr.threshold);
        Rule newRule;
        for (BinaryRule binaryRule : gr.binaryRuleMap.keySet()) {
            newRule = new HierarchicalBinaryRule(binaryRule);
            this.addBinary((BinaryRule)newRule);
        }
        for (UnaryRule unaryRule : gr.unaryRuleMap.keySet()) {
            newRule = new HierarchicalUnaryRule(unaryRule);
            this.addUnary((UnaryRule)newRule);
        }
        this.closedViterbiRulesWithParent = this.unaryRulesWithParent;
        this.closedSumRulesWithParent = this.unaryRulesWithParent;
        this.closedViterbiRulesWithChild = this.unaryRulesWithC;
        this.closedSumRulesWithChild = this.unaryRulesWithC;
        this.makeCRArrays();
        this.isGrammarTag = gr.isGrammarTag;
    }

    public void splitRules() {
        this.explicitlyComputeScores(this.finalLevel);
        super.splitRules();
    }

    public void explicitlyComputeScores(int finalLevel) {
        Rule newRule;
        for (Rule oldRule : this.binaryRuleMap.keySet()) {
            newRule = (HierarchicalBinaryRule)oldRule;
            ((HierarchicalBinaryRule)newRule).explicitlyComputeScores(finalLevel, this.numSubStates);
        }
        for (Rule oldRule : this.unaryRuleMap.keySet()) {
            newRule = (HierarchicalUnaryRule)oldRule;
            ((HierarchicalUnaryRule)newRule).explicitlyComputeScores(finalLevel, this.numSubStates);
        }
    }

    public HierarchicalGrammar splitAllStates(double randomness, int[] counts, boolean moreSubstatesThanCounts, int mode) {
        Rule newRule;
        short[] newNumSubStates = new short[this.numSubStates.length];
        newNumSubStates[0] = 1;
        int i = 1;
        while (i < this.numSubStates.length) {
            newNumSubStates[i] = !moreSubstatesThanCounts && this.numSubStates[i] >= counts[i] ? this.numSubStates[i] : (short)(this.numSubStates[i] * 2);
            i = (short)(i + 1);
        }
        HierarchicalGrammar newGrammar = this.newInstance(newNumSubStates);
        for (Rule oldRule : this.binaryRuleMap.keySet()) {
            newRule = (HierarchicalBinaryRule)oldRule;
            newGrammar.addBinary(((HierarchicalBinaryRule)newRule).splitRule(this.numSubStates, newGrammar.numSubStates, GrammarTrainer.RANDOM, randomness, true, mode));
        }
        for (Rule oldRule : this.unaryRuleMap.keySet()) {
            newRule = (HierarchicalUnaryRule)oldRule;
            newGrammar.addUnary(((HierarchicalUnaryRule)newRule).splitRule(this.numSubStates, newGrammar.numSubStates, GrammarTrainer.RANDOM, randomness, true, mode));
        }
        newGrammar.closedViterbiRulesWithParent = newGrammar.unaryRulesWithParent;
        newGrammar.closedSumRulesWithParent = newGrammar.unaryRulesWithParent;
        newGrammar.closedViterbiRulesWithChild = newGrammar.unaryRulesWithC;
        newGrammar.closedSumRulesWithChild = newGrammar.unaryRulesWithC;
        newGrammar.makeCRArrays();
        newGrammar.isGrammarTag = this.isGrammarTag;
        return newGrammar;
    }

    public HierarchicalGrammar newInstance(short[] newNumSubStates) {
        return new HierarchicalGrammar(newNumSubStates, this.findClosedPaths, this.smoother, this, this.threshold);
    }

    public void mergeGrammar() {
        Rule newRule;
        int nBinaryMerged = 0;
        int nUnaryMerged = 0;
        for (Rule oldRule : this.binaryRuleMap.keySet()) {
            newRule = (HierarchicalBinaryRule)oldRule;
            nBinaryMerged += ((HierarchicalBinaryRule)newRule).mergeRule();
        }
        for (Rule oldRule : this.unaryRuleMap.keySet()) {
            newRule = (HierarchicalUnaryRule)oldRule;
            nUnaryMerged += ((HierarchicalUnaryRule)newRule).mergeRule();
        }
        System.out.println("Removed " + nBinaryMerged + " binary and " + nUnaryMerged + " unary parameters.");
    }

    public HierarchicalGrammar copyGrammar(boolean noUnaryChains) {
        short[] newNumSubStates = (short[])this.numSubStates.clone();
        HierarchicalGrammar grammar = this.newInstance(newNumSubStates);
        for (Rule oldRule : this.binaryRuleMap.keySet()) {
            grammar.addBinary((BinaryRule)oldRule);
        }
        for (Rule oldRule : this.unaryRuleMap.keySet()) {
            grammar.addUnary((UnaryRule)oldRule);
        }
        if (noUnaryChains) {
            this.closedViterbiRulesWithParent = this.unaryRulesWithParent;
            this.closedSumRulesWithParent = this.unaryRulesWithParent;
            this.closedViterbiRulesWithChild = this.unaryRulesWithC;
            this.closedSumRulesWithChild = this.unaryRulesWithC;
        } else {
            grammar.computePairsOfUnaries();
        }
        grammar.makeCRArrays();
        grammar.isGrammarTag = this.isGrammarTag;
        return grammar;
    }

    public String toString() {
        this.printLevelCounts();
        return super.toString();
    }

    void printLevelCounts() {
        int i;
        int[] counts;
        int nBinaryParams = 0;
        int nUnaryParams = 0;
        boolean nBinaryFringeParams = false;
        boolean nUnaryFringeParams = false;
        int state = 0;
        while (state < this.numStates) {
            counts = new int[6];
            BinaryRule[] parentRules = this.splitRulesWithP(state);
            if (parentRules.length != 0) {
                i = 0;
                while (i < parentRules.length) {
                    HierarchicalBinaryRule r = (HierarchicalBinaryRule)parentRules[i];
                    int n = r.lastLevel;
                    counts[n] = counts[n] + 1;
                    nBinaryParams += r.countNonZeroFeatures();
                    ++i;
                }
                System.out.print(this.tagNumberer.object(state) + ", binary rules per level: ");
                i = 1;
                while (i < 6) {
                    System.out.print(String.valueOf(counts[i]) + " ");
                    ++i;
                }
                System.out.print("\n");
            }
            ++state;
        }
        state = 0;
        while (state < this.numStates) {
            counts = new int[6];
            UnaryRule[] unaries = this.getClosedSumUnaryRulesByParent(state);
            if (unaries.length != 0) {
                int r = 0;
                while (r < unaries.length) {
                    HierarchicalUnaryRule ur = (HierarchicalUnaryRule)unaries[r];
                    int n = ur.lastLevel;
                    counts[n] = counts[n] + 1;
                    nUnaryParams += ur.countNonZeroFeatures();
                    ++r;
                }
                System.out.print(this.tagNumberer.object(state) + ", unary rules per level: ");
                i = 1;
                while (i < 6) {
                    System.out.print(String.valueOf(counts[i]) + " ");
                    ++i;
                }
                System.out.print("\n");
            }
            ++state;
        }
        System.out.println("There are " + nBinaryParams + " binary features");
        System.out.println("There are " + nUnaryParams + " unary features");
    }

    public void writeData(Writer w) throws IOException {
        this.printLevelCounts();
        super.writeData(w);
    }
}

