/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.GrammarTrainer;
import edu.berkeley.nlp.PCFGLA.SimpleLexicon;
import edu.berkeley.nlp.util.ArrayUtil;
import edu.berkeley.nlp.util.Numberer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class HierarchicalLexicon
extends SimpleLexicon {
    private static final long serialVersionUID = 1L;
    public List<double[]>[][] hierarchicalScores;
    public int[][] finalLevels;

    public HierarchicalLexicon(short[] numSubStates, double threshold) {
        super(numSubStates, threshold);
        this.hierarchicalScores = new List[this.numStates][];
    }

    public HierarchicalLexicon(SimpleLexicon lex) {
        super(lex.numSubStates, lex.threshold);
        this.expectedCounts = new double[this.numStates][][];
        this.tagWordIndexer = new SimpleLexicon.IntegerIndexer[this.numStates];
        this.wordIndexer = lex.wordIndexer;
        this.wordCounter = lex.wordCounter;
        int tag = 0;
        while (tag < this.numStates) {
            this.tagWordIndexer[tag] = lex.tagWordIndexer[tag].copy();
            ++tag;
        }
        this.nWords = lex.nWords;
        this.smoother = lex.smoother;
        this.makeHiearchicalScores(lex.scores);
        this.scores = null;
    }

    private void makeHiearchicalScores(double[][][] scores) {
        this.hierarchicalScores = new List[this.numStates][];
        this.finalLevels = new int[this.numStates][];
        int tag = 0;
        while (tag < this.numStates) {
            int words = this.tagWordIndexer[tag].size();
            this.hierarchicalScores[tag] = new List[words];
            this.finalLevels[tag] = new int[words];
            int word = 0;
            while (word < words) {
                this.hierarchicalScores[tag][word] = new ArrayList<double[]>();
                double[] score = new double[]{Math.log(scores[tag][0][word])};
                this.hierarchicalScores[tag][word].add(score);
                ++word;
            }
            ++tag;
        }
    }

    public void explicitlyComputeScores(int finalLevel) {
        this.scores = new double[this.numStates][][];
        int nSubstates = (int)Math.pow(2.0, finalLevel);
        int tag = 0;
        while (tag < this.numStates) {
            int words = this.hierarchicalScores[tag].length;
            this.scores[tag] = new double[nSubstates][words];
            int word = 0;
            while (word < words) {
                List<double[]> scoreHierarchy = this.hierarchicalScores[tag][word];
                int level = 0;
                while (level <= finalLevel) {
                    if (level <= this.finalLevels[tag][word]) {
                        double[] scoresThisLevel = scoreHierarchy.get(level);
                        int divisor = nSubstates / scoresThisLevel.length;
                        int substate = 0;
                        while (substate < nSubstates) {
                            double[] dArray = this.scores[tag][substate];
                            int n = word;
                            dArray[n] = dArray[n] + scoresThisLevel[substate / divisor];
                            ++substate;
                        }
                    }
                    ++level;
                }
                int substate = 0;
                while (substate < nSubstates) {
                    this.scores[tag][substate][word] = Math.exp(this.scores[tag][substate][word]);
                    ++substate;
                }
                ++word;
            }
            ++tag;
        }
    }

    public HierarchicalLexicon splitAllStates(int[] counts, boolean moreSubstatesThanCounts, int mode) {
        short[] newNumSubStates = new short[this.numSubStates.length];
        newNumSubStates[0] = 1;
        int i = 1;
        while (i < this.numSubStates.length) {
            newNumSubStates[i] = !moreSubstatesThanCounts && this.numSubStates[i] >= counts[i] ? this.numSubStates[i] : (short)(this.numSubStates[i] * 2);
            i = (short)(i + 1);
        }
        HierarchicalLexicon newLex = this.newInstance();
        newLex.numSubStates = newNumSubStates;
        Random random = GrammarTrainer.RANDOM;
        newLex.expectedCounts = new double[this.numStates][][];
        newLex.tagWordIndexer = new SimpleLexicon.IntegerIndexer[this.numStates];
        newLex.wordIndexer = this.wordIndexer;
        int tag = 0;
        while (tag < this.numStates) {
            newLex.tagWordIndexer[tag] = this.tagWordIndexer[tag].copy();
            ++tag;
        }
        newLex.nWords = this.nWords;
        newLex.smoother = this.smoother;
        List[][] hS = new List[this.numStates][];
        newLex.finalLevels = new int[this.numStates][];
        int tag2 = 0;
        while (tag2 < this.numStates) {
            int words = this.tagWordIndexer[tag2].size();
            hS[tag2] = new List[words];
            newLex.finalLevels[tag2] = new int[words];
            int word = 0;
            while (word < words) {
                hS[tag2][word] = new ArrayList();
                for (double[] scores : this.hierarchicalScores[tag2][word]) {
                    hS[tag2][word].add((double[])scores.clone());
                }
                int fLevel = this.finalLevels[tag2][word] + 1;
                int nSub = (int)Math.pow(2.0, fLevel);
                if (nSub <= newNumSubStates[tag2]) {
                    double[] newScores = new double[nSub];
                    int i2 = 0;
                    while (i2 < newScores.length) {
                        newScores[i2] = random.nextDouble() / 100.0;
                        ++i2;
                    }
                    hS[tag2][word].add(newScores);
                    newLex.finalLevels[tag2][word] = fLevel;
                }
                ++word;
            }
            ++tag2;
        }
        newLex.scores = null;
        newLex.hierarchicalScores = hS;
        newLex.wordCounter = this.wordCounter;
        return newLex;
    }

    public HierarchicalLexicon newInstance() {
        return new HierarchicalLexicon(this.numSubStates, this.threshold);
    }

    public int getFinalLevel(int globalWordIndex, int tag) {
        int tagSpecificWordIndex = this.tagWordIndexer[tag].indexOf(globalWordIndex);
        return this.finalLevels[tag][tagSpecificWordIndex];
    }

    public void mergeLexicon() {
        int nRemovedParam = 0;
        int nRemovedArrays = 0;
        int tag = 0;
        while (tag < this.numStates) {
            int words = this.hierarchicalScores[tag].length;
            int word = 0;
            while (word < words) {
                List<double[]> scoreHierarchy = this.hierarchicalScores[tag][word];
                int level = this.finalLevels[tag][word];
                double[] scoresThisLevel = scoreHierarchy.get(level);
                if (scoresThisLevel != null) {
                    boolean allZero = true;
                    int substate = 0;
                    while (substate < scoresThisLevel.length) {
                        allZero = allZero && scoresThisLevel[substate] == 0.0;
                        ++substate;
                    }
                    if (allZero) {
                        scoreHierarchy.remove(level);
                        int[] nArray = this.finalLevels[tag];
                        int n = word;
                        nArray[n] = nArray[n] - 1;
                        nRemovedParam += scoresThisLevel.length;
                        ++nRemovedArrays;
                    }
                }
                ++word;
            }
            ++tag;
        }
        System.out.println("Removed " + nRemovedParam + " parameters in the lexicon by setting " + nRemovedArrays + " arrays to null.");
    }

    public double[] getLastLevel(int tag, int word) {
        return this.hierarchicalScores[tag][word].get(this.finalLevels[tag][word]);
    }

    public HierarchicalLexicon copyLexicon() {
        HierarchicalLexicon copy = this.newInstance();
        copy.expectedCounts = new double[this.numStates][][];
        copy.scores = ArrayUtil.clone(this.scores);
        copy.hierarchicalScores = this.hierarchicalScores;
        copy.tagWordIndexer = new SimpleLexicon.IntegerIndexer[this.numStates];
        copy.wordIndexer = this.wordIndexer;
        int tag = 0;
        while (tag < this.numStates) {
            copy.tagWordIndexer[tag] = this.tagWordIndexer[tag].copy();
            copy.expectedCounts[tag] = new double[this.numSubStates[tag]][this.tagWordIndexer[tag].size()];
            ++tag;
        }
        if (this.wordCounter != null) {
            copy.wordCounter = (int[])this.wordCounter.clone();
        }
        copy.nWords = this.nWords;
        copy.smoother = this.smoother;
        if (this.finalLevels != null) {
            copy.finalLevels = ArrayUtil.clone(this.finalLevels);
        }
        return copy;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Numberer tagNumberer = Numberer.getGlobalNumberer("tags");
        int tag = 0;
        while (tag < this.scores.length) {
            int[] counts = new int[6];
            String tagS = (String)tagNumberer.object(tag);
            if (this.tagWordIndexer[tag].size() != 0) {
                int word = 0;
                while (word < this.scores[tag][0].length) {
                    sb.append(String.valueOf(tagS) + " " + (String)this.wordIndexer.get(this.tagWordIndexer[tag].get(word)) + " ");
                    int sub = 0;
                    while (sub < this.numSubStates[tag]) {
                        sb.append(" " + this.scores[tag][sub][word]);
                        ++sub;
                    }
                    for (double[] d : this.hierarchicalScores[tag][word]) {
                        sb.append("\n" + Arrays.toString(d));
                    }
                    int n = this.finalLevels[tag][word];
                    counts[n] = counts[n] + 1;
                    sb.append("\n\n");
                    ++word;
                }
                System.out.print(tagNumberer.object(tag) + ", word,tag pairs per level: ");
                int i = 1;
                while (i < 6) {
                    System.out.print(String.valueOf(counts[i]) + " ");
                    ++i;
                }
                System.out.print("\n");
            }
            ++tag;
        }
        return sb.toString();
    }
}

