/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA.smoothing;

import edu.berkeley.nlp.PCFGLA.BinaryCounterTable;
import edu.berkeley.nlp.PCFGLA.BinaryRule;
import edu.berkeley.nlp.PCFGLA.UnaryCounterTable;
import edu.berkeley.nlp.PCFGLA.UnaryRule;
import edu.berkeley.nlp.PCFGLA.smoothing.Smoother;
import edu.berkeley.nlp.util.Numberer;
import java.io.Serializable;

public class SmoothAcrossParentSubstate
implements Smoother,
Serializable {
    private static final long serialVersionUID = 1L;
    double same;
    double different;

    public SmoothAcrossParentSubstate(double smooth) {
        this.different = smooth;
        this.same = 1.0 - this.different;
    }

    public void smooth(UnaryCounterTable unaryCounter, BinaryCounterTable binaryCounter) {
        int j;
        Object scopy;
        Object scores;
        for (UnaryRule unaryRule : unaryCounter.keySet()) {
            scores = unaryCounter.getCount(unaryRule);
            scopy = new double[((double[][])scores).length][];
            j = 0;
            while (j < ((double[][])scores).length) {
                if (scores[j] != null) {
                    scopy[j] = new double[scores[j].length];
                    double diff = this.different / (double)(scores[j].length - 1);
                    int i = 0;
                    while (i < scores[j].length) {
                        int k = 0;
                        while (k < scores[j].length) {
                            double[] dArray = scopy[j];
                            int n = i;
                            dArray[n] = dArray[n] + (i == k ? this.same : diff) * scores[j][k];
                            ++k;
                        }
                        ++i;
                    }
                }
                ++j;
            }
            unaryCounter.setCount(unaryRule, (double[][])scopy);
        }
        for (BinaryRule binaryRule : binaryCounter.keySet()) {
            scores = binaryCounter.getCount(binaryRule);
            scopy = new double[((double[][])scores).length][scores[0].length][];
            j = 0;
            while (j < ((double[][])scores).length) {
                int l = 0;
                while (l < scores[0].length) {
                    if (scores[j][l] != null) {
                        scopy[j][l] = (double)new double[((double)scores[j][l]).length];
                        double diff = this.different / (double)(((double)scores[j][l]).length - 1);
                        int i = 0;
                        while (i < ((double)scores[j][l]).length) {
                            int k = 0;
                            while (k < ((double)scores[j][l]).length) {
                                double d = scopy[j][l];
                                int n = i;
                                d[n] = d[n] + (i == k ? this.same : diff) * scores[j][l][k];
                                ++k;
                            }
                            ++i;
                        }
                    }
                    ++l;
                }
                ++j;
            }
            binaryCounter.setCount(binaryRule, (double[][][])scopy);
        }
    }

    public void smooth(short tag, double[] scores) {
        double[] scopy = new double[scores.length];
        int i = 0;
        while (i < scores.length) {
            double diff = this.different / (double)(scores.length - 1);
            int k = 0;
            while (k < scores.length) {
                int n = i;
                scopy[n] = scopy[n] + (i == k ? this.same : diff) * scores[k];
                ++k;
            }
            ++i;
        }
        i = 0;
        while (i < scores.length) {
            scores[i] = scopy[i];
            ++i;
        }
    }

    public void updateWeights(int[][] toSubstateMapping) {
    }

    public Smoother copy() {
        return new SmoothAcrossParentSubstate(this.different);
    }

    public Smoother remapStates(Numberer thisNumberer, Numberer newNumberer) {
        return this.copy();
    }
}

