/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.discPCFG;

import edu.berkeley.nlp.PCFGLA.BinaryRule;
import edu.berkeley.nlp.PCFGLA.ConditionalTrainer;
import edu.berkeley.nlp.PCFGLA.Grammar;
import edu.berkeley.nlp.PCFGLA.SimpleLexicon;
import edu.berkeley.nlp.PCFGLA.SpanPredictor;
import edu.berkeley.nlp.PCFGLA.UnaryRule;
import edu.berkeley.nlp.discPCFG.Linearizer;
import edu.berkeley.nlp.math.SloppyMath;
import edu.berkeley.nlp.syntax.StateSet;
import edu.berkeley.nlp.util.ArrayUtil;
import java.io.Serializable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLinearizer
implements Linearizer,
Serializable {
    Grammar grammar;
    SimpleLexicon lexicon;
    SpanPredictor spanPredictor;
    int[][] linearIndex;
    int nGrammarWeights;
    int nLexiconWeights;
    int nSpanWeights;
    int nWords;
    int startSpanWeights;
    int nSubstates;
    int nClasses;
    int startIndexPrevious;
    int startIndexNext;
    int startIndexFirst;
    int startIndexLast;
    int startIndexBeginPair;
    int startIndexEndPair;
    int startIndexPunctuation;
    double[] lastProbs;
    private static final long serialVersionUID = 2L;

    public DefaultLinearizer() {
    }

    public DefaultLinearizer(Grammar grammar, SimpleLexicon lexicon, SpanPredictor sp) {
        this.grammar = grammar;
        this.lexicon = lexicon;
        this.spanPredictor = sp;
        this.nSubstates = (int)ArrayUtil.max(grammar.numSubStates);
        this.init();
    }

    protected void init() {
        double[] tmp = null;
        if (!ConditionalTrainer.Options.lockGrammar) {
            tmp = this.getLinearizedGrammar(true);
            tmp = this.getLinearizedLexicon(true);
        }
        tmp = this.getLinearizedSpanPredictor(true);
    }

    public void delinearizeSpanPredictor(double[] probs) {
        double val;
        int c;
        int i;
        double[][] tmp;
        if (this.spanPredictor == null) {
            return;
        }
        int ind = this.startSpanWeights;
        int nDangerous = 0;
        if (this.spanPredictor.useFirstAndLast) {
            tmp = this.spanPredictor.firstWordScore;
            i = 0;
            while (i < tmp.length) {
                c = 0;
                while (c < tmp[0].length) {
                    int n = ind++;
                    val = probs[n];
                    if (Math.abs(val) > 300.0) {
                        ++nDangerous;
                    } else {
                        tmp[i][c] = val = Math.exp(val);
                    }
                    ++c;
                }
                ++i;
            }
            tmp = this.spanPredictor.lastWordScore;
            i = 0;
            while (i < tmp.length) {
                c = 0;
                while (c < tmp[0].length) {
                    int n = ind++;
                    val = probs[n];
                    if (Math.abs(val) > 300.0) {
                        ++nDangerous;
                    } else {
                        tmp[i][c] = val = Math.exp(val);
                    }
                    ++c;
                }
                ++i;
            }
        }
        if (this.spanPredictor.usePreviousAndNext) {
            tmp = this.spanPredictor.previousWordScore;
            i = 0;
            while (i < tmp.length) {
                c = 0;
                while (c < tmp[0].length) {
                    int n = ind++;
                    val = probs[n];
                    if (Math.abs(val) > 300.0) {
                        ++nDangerous;
                    } else {
                        tmp[i][c] = val = Math.exp(val);
                    }
                    ++c;
                }
                ++i;
            }
            tmp = this.spanPredictor.nextWordScore;
            i = 0;
            while (i < tmp.length) {
                c = 0;
                while (c < tmp[0].length) {
                    int n = ind++;
                    val = probs[n];
                    if (Math.abs(val) > 300.0) {
                        ++nDangerous;
                    } else {
                        tmp[i][c] = val = Math.exp(val);
                    }
                    ++c;
                }
                ++i;
            }
        }
        if (this.spanPredictor.useBeginAndEndPairs) {
            tmp = this.spanPredictor.beginPairScore;
            i = 0;
            while (i < tmp.length) {
                c = 0;
                while (c < tmp[0].length) {
                    int n = ind++;
                    val = probs[n];
                    if (Math.abs(val) > 300.0) {
                        ++nDangerous;
                    } else {
                        tmp[i][c] = val = Math.exp(val);
                    }
                    ++c;
                }
                ++i;
            }
            tmp = this.spanPredictor.endPairScore;
            i = 0;
            while (i < tmp.length) {
                c = 0;
                while (c < tmp[0].length) {
                    int n = ind++;
                    val = probs[n];
                    if (Math.abs(val) > 300.0) {
                        ++nDangerous;
                    } else {
                        tmp[i][c] = val = Math.exp(val);
                    }
                    ++c;
                }
                ++i;
            }
        }
        if (this.spanPredictor.usePunctuation) {
            tmp = this.spanPredictor.punctuationScores;
            i = 0;
            while (i < tmp.length) {
                c = 0;
                while (c < tmp[0].length) {
                    int n = ind++;
                    val = probs[n];
                    if (Math.abs(val) > 300.0) {
                        ++nDangerous;
                    } else {
                        tmp[i][c] = val = Math.exp(val);
                    }
                    ++c;
                }
                ++i;
            }
        }
        if (nDangerous > 0) {
            System.out.println("Ignored " + nDangerous + " proposed span feature weights since they were dangerous.");
        }
    }

    public void delinearizeGrammar(double[] probs) {
        int k;
        int j;
        Object scores;
        int ind;
        int nDangerous = 0;
        for (BinaryRule bRule : this.grammar.binaryRuleMap.keySet()) {
            ind = bRule.identifier;
            scores = bRule.getScores2();
            j = 0;
            while (j < ((double[][][])scores).length) {
                k = 0;
                while (k < scores[j].length) {
                    if (scores[j][k] != null) {
                        int l = 0;
                        while (l < scores[j][k].length) {
                            double val;
                            if (SloppyMath.isVeryDangerous(val = Math.exp(probs[ind++]))) {
                                System.out.println("dangerous value for rule " + bRule + " " + probs[ind - 1]);
                                val = 0.0;
                                ++nDangerous;
                            }
                            scores[j][k][l] = val;
                            ++l;
                        }
                    }
                    ++k;
                }
                ++j;
            }
        }
        if (nDangerous > 0) {
            System.out.println("Left " + nDangerous + " binary rule weights unchanged since the proposed weight was dangerous.");
        }
        nDangerous = 0;
        for (UnaryRule uRule : this.grammar.unaryRuleMap.keySet()) {
            ind = uRule.identifier;
            if (uRule.childState == uRule.parentState) continue;
            scores = uRule.getScores2();
            j = 0;
            while (j < ((double[][][])scores).length) {
                if (scores[j] != null) {
                    k = 0;
                    while (k < scores[j].length) {
                        double val;
                        if (SloppyMath.isVeryDangerous(val = Math.exp(probs[ind++]))) {
                            System.out.println("dangerous value for rule " + uRule + " " + probs[ind - 1]);
                            val = 0.0;
                            ++nDangerous;
                        }
                        scores[j][k] = (double[])val;
                        ++k;
                    }
                }
                ++j;
            }
        }
        if (nDangerous > 0) {
            System.out.println("Left " + nDangerous + " unary rule weights unchanged since the proposed weight was dangerous.");
        }
        this.grammar.closedViterbiRulesWithParent = this.grammar.unaryRulesWithParent;
        this.grammar.closedSumRulesWithParent = this.grammar.unaryRulesWithParent;
        this.grammar.closedViterbiRulesWithChild = this.grammar.unaryRulesWithC;
        this.grammar.closedSumRulesWithChild = this.grammar.unaryRulesWithC;
        this.grammar.clearUnaryIntermediates();
        this.grammar.makeCRArrays();
    }

    public double[] getLinearizedGrammar(boolean update) {
        int k;
        int j;
        int ind;
        if (update) {
            int j2;
            Object scores;
            this.nGrammarWeights = 0;
            for (BinaryRule bRule : this.grammar.binaryRuleMap.keySet()) {
                if (!this.grammar.isGrammarTag[bRule.parentState]) {
                    System.out.println("Incorrect grammar tag");
                }
                bRule.identifier = this.nGrammarWeights;
                scores = bRule.getScores2();
                j2 = 0;
                while (j2 < ((double[][][])scores).length) {
                    int k2 = 0;
                    while (k2 < scores[j2].length) {
                        if (scores[j2][k2] != null) {
                            this.nGrammarWeights += scores[j2][k2].length;
                        }
                        ++k2;
                    }
                    ++j2;
                }
            }
            for (UnaryRule uRule : this.grammar.unaryRuleMap.keySet()) {
                uRule.identifier = this.nGrammarWeights;
                scores = uRule.getScores2();
                j2 = 0;
                while (j2 < ((double[][][])scores).length) {
                    if (scores[j2] != null) {
                        this.nGrammarWeights += scores[j2].length;
                    }
                    ++j2;
                }
            }
        }
        double[] logProbs = new double[this.nGrammarWeights];
        for (BinaryRule bRule : this.grammar.binaryRuleMap.keySet()) {
            ind = bRule.identifier;
            double[][][] scores = bRule.getScores2();
            j = 0;
            while (j < scores.length) {
                k = 0;
                while (k < scores[j].length) {
                    if (scores[j][k] != null) {
                        int l = 0;
                        while (l < scores[j][k].length) {
                            double val = Math.log(scores[j][k][l]);
                            logProbs[ind++] = val;
                            ++l;
                        }
                    }
                    ++k;
                }
                ++j;
            }
        }
        for (UnaryRule uRule : this.grammar.unaryRuleMap.keySet()) {
            ind = uRule.identifier;
            if (uRule.childState == uRule.parentState) continue;
            double[][] scores = uRule.getScores2();
            j = 0;
            while (j < scores.length) {
                if (scores[j] != null) {
                    k = 0;
                    while (k < scores[j].length) {
                        double val = Math.log(scores[j][k]);
                        logProbs[ind++] = val;
                        ++k;
                    }
                }
                ++j;
            }
        }
        return logProbs;
    }

    public void delinearizeLexicon(double[] logProbs) {
        int nDangerous = 0;
        int tag = 0;
        while (tag < this.lexicon.scores.length) {
            int word = 0;
            while (word < this.lexicon.scores[tag][0].length) {
                int index = this.linearIndex[tag][word];
                int substate = 0;
                while (substate < this.lexicon.numSubStates[tag]) {
                    double val;
                    if (SloppyMath.isVeryDangerous(val = Math.exp(logProbs[index++]))) {
                        System.out.println("dangerous value when delinearizng lexicon " + this.lexicon.scores[tag][substate][word]);
                        System.out.println("Word " + this.lexicon.wordIndexer.get(this.lexicon.tagWordIndexer[tag].get(word)) + " tag " + logProbs[index - 1]);
                        val = 0.0;
                        ++nDangerous;
                    }
                    this.lexicon.scores[tag][substate][word] = val;
                    ++substate;
                }
                ++word;
            }
            tag = (short)(tag + 1);
        }
        if (nDangerous > 0) {
            System.out.println("Left " + nDangerous + " lexicon weights unchanged since the proposed weight was dangerous.");
        }
    }

    @Override
    public double[] getLinearizedLexicon() {
        return this.getLinearizedLexicon(false);
    }

    public double[] getLinearizedLexicon(boolean update) {
        if (update) {
            this.nLexiconWeights = 0;
            int tag = 0;
            while (tag < this.lexicon.scores.length) {
                int word = 0;
                while (word < this.lexicon.scores[tag][0].length) {
                    this.nLexiconWeights += this.lexicon.numSubStates[tag];
                    ++word;
                }
                tag = (short)(tag + 1);
            }
        }
        double[] logProbs = new double[this.nLexiconWeights];
        if (update) {
            this.linearIndex = new int[this.lexicon.expectedCounts.length][];
        }
        int index = 0;
        int tag = 0;
        while (tag < this.lexicon.scores.length) {
            if (update) {
                this.linearIndex[tag] = new int[this.lexicon.scores[tag][0].length];
            }
            int word = 0;
            while (word < this.lexicon.scores[tag][0].length) {
                if (update) {
                    this.linearIndex[tag][word] = index + this.nGrammarWeights;
                }
                int substate = 0;
                while (substate < this.lexicon.numSubStates[tag]) {
                    double val = Math.log(this.lexicon.scores[tag][substate][word]);
                    logProbs[index++] = val;
                    ++substate;
                }
                ++word;
            }
            tag = (short)(tag + 1);
        }
        return logProbs;
    }

    public int getLinearIndex(String word, int tag) {
        return this.getLinearIndex(this.lexicon.wordIndexer.indexOf(word), tag);
    }

    public int getLinearIndex(int globalWordIndex, int tag) {
        int tagSpecificWordIndex = this.lexicon.tagWordIndexer[tag].indexOf(globalWordIndex);
        if (tagSpecificWordIndex == -1) {
            return -1;
        }
        return this.linearIndex[tag][tagSpecificWordIndex];
    }

    @Override
    public int dimension() {
        return this.nGrammarWeights + this.nLexiconWeights + this.nSpanWeights;
    }

    @Override
    public void increment(double[] counts, StateSet stateSet, int tag, double[] weights, boolean isGold) {
        int i;
        int startIndexWord;
        int globalSigIndex = stateSet.sigIndex;
        if (globalSigIndex != -1 && (startIndexWord = this.getLinearIndex(globalSigIndex, tag)) >= 0) {
            i = 0;
            while (i < this.nSubstates) {
                if (isGold) {
                    int n = startIndexWord++;
                    counts[n] = counts[n] + weights[i];
                } else {
                    int n = startIndexWord++;
                    counts[n] = counts[n] - weights[i];
                }
                ++i;
            }
        }
        if ((startIndexWord = this.getLinearIndex(stateSet.wordIndex, tag)) >= 0) {
            i = 0;
            while (i < this.nSubstates) {
                if (isGold) {
                    int n = startIndexWord++;
                    counts[n] = counts[n] + weights[i];
                } else {
                    int n = startIndexWord++;
                    counts[n] = counts[n] - weights[i];
                }
                weights[i] = 0.0;
                ++i;
            }
        } else {
            i = 0;
            while (i < this.nSubstates) {
                weights[i] = 0.0;
                ++i;
            }
        }
    }

    @Override
    public void increment(double[] counts, UnaryRule rule, double[] weights, boolean isGold) {
        int thisStartIndex = rule.identifier;
        int curInd = 0;
        int nSubstatesParent = rule.parentState == 0 ? 1 : this.nSubstates;
        int cp = 0;
        while (cp < this.nSubstates) {
            int np = 0;
            while (np < nSubstatesParent) {
                if (isGold) {
                    int n = thisStartIndex++;
                    counts[n] = counts[n] + weights[curInd];
                } else {
                    int n = thisStartIndex++;
                    counts[n] = counts[n] - weights[curInd];
                }
                weights[curInd++] = 0.0;
                ++np;
            }
            ++cp;
        }
    }

    @Override
    public void increment(double[] counts, BinaryRule rule, double[] weights, boolean isGold) {
        int thisStartIndex = rule.identifier;
        int curInd = 0;
        int lp = 0;
        while (lp < this.nSubstates) {
            int rp = 0;
            while (rp < this.nSubstates) {
                int np = 0;
                while (np < this.nSubstates) {
                    if (isGold) {
                        int n = thisStartIndex++;
                        counts[n] = counts[n] + weights[curInd];
                    } else {
                        int n = thisStartIndex++;
                        counts[n] = counts[n] - weights[curInd];
                    }
                    weights[curInd++] = 0.0;
                    ++np;
                }
                ++rp;
            }
            ++lp;
        }
    }

    @Override
    public void delinearizeWeights(double[] logWeights) {
        double val;
        int i;
        int nGrZ = 0;
        int nLexZ = 0;
        int nSpZ = 0;
        int tmpI = 0;
        if (!ConditionalTrainer.Options.lockGrammar) {
            i = 0;
            while (i < this.nGrammarWeights) {
                if ((val = logWeights[tmpI++]) == 0.0) {
                    ++nGrZ;
                }
                ++i;
            }
            this.delinearizeGrammar(logWeights);
            i = 0;
            while (i < this.nLexiconWeights) {
                if ((val = logWeights[tmpI++]) == 0.0) {
                    ++nLexZ;
                }
                ++i;
            }
            this.delinearizeLexicon(logWeights);
        }
        i = 0;
        while (i < this.nSpanWeights) {
            if ((val = logWeights[tmpI++]) == 0.0) {
                ++nSpZ;
            }
            ++i;
        }
        this.delinearizeSpanPredictor(logWeights);
        this.lastProbs = (double[])logWeights.clone();
        System.out.println("Proposed vector has " + (nGrZ + nLexZ + nSpZ) + "/" + (this.nGrammarWeights + this.nLexiconWeights + this.nSpanWeights) + " zeros [grammar: " + nGrZ + "/" + this.nGrammarWeights + ", lexicon: " + nLexZ + "/" + this.nLexiconWeights + ", span: " + nSpZ + "/" + this.nSpanWeights + "].");
    }

    public double[] getLinearizedSpanPredictor(boolean update) {
        int c;
        int i;
        double[][] tmp;
        if (this.spanPredictor == null) {
            this.nSpanWeights = 0;
            return new double[0];
        }
        this.nWords = this.spanPredictor.nWords;
        this.nSpanWeights = this.spanPredictor.nFeatures;
        this.startSpanWeights = this.nGrammarWeights + this.nLexiconWeights;
        this.nClasses = this.spanPredictor.getNClasses();
        double[] logProbs = new double[this.nSpanWeights];
        int ind = 0;
        if (update) {
            this.startIndexFirst = this.startSpanWeights;
            this.startIndexLast = this.startIndexFirst + this.nWords * this.nClasses;
            this.startIndexPrevious = this.spanPredictor.useFirstAndLast ? this.startIndexFirst + 2 * this.nWords * this.nClasses : this.startIndexFirst;
            this.startIndexNext = this.startIndexPrevious + this.nWords * this.nClasses;
            this.startIndexBeginPair = this.spanPredictor.usePreviousAndNext ? this.startIndexPrevious + 2 * this.nWords * this.nClasses : this.startIndexPrevious;
            this.startIndexEndPair = this.spanPredictor.useBeginAndEndPairs ? this.startIndexBeginPair + this.spanPredictor.beginPairScore.length * this.nClasses : this.startIndexBeginPair;
            int n = this.startIndexPunctuation = this.spanPredictor.useBeginAndEndPairs ? this.startIndexBeginPair + (this.spanPredictor.beginPairScore.length + this.spanPredictor.endPairScore.length) * this.nClasses : this.startIndexBeginPair;
        }
        if (this.spanPredictor.useFirstAndLast) {
            tmp = this.spanPredictor.firstWordScore;
            i = 0;
            while (i < tmp.length) {
                c = 0;
                while (c < tmp[0].length) {
                    logProbs[ind++] = Math.log(tmp[i][c]);
                    ++c;
                }
                ++i;
            }
            tmp = this.spanPredictor.lastWordScore;
            i = 0;
            while (i < tmp.length) {
                c = 0;
                while (c < tmp[0].length) {
                    logProbs[ind++] = Math.log(tmp[i][c]);
                    ++c;
                }
                ++i;
            }
        }
        if (this.spanPredictor.usePreviousAndNext) {
            tmp = this.spanPredictor.previousWordScore;
            i = 0;
            while (i < tmp.length) {
                c = 0;
                while (c < tmp[0].length) {
                    logProbs[ind++] = Math.log(tmp[i][c]);
                    ++c;
                }
                ++i;
            }
            tmp = this.spanPredictor.nextWordScore;
            i = 0;
            while (i < tmp.length) {
                c = 0;
                while (c < tmp[0].length) {
                    logProbs[ind++] = Math.log(tmp[i][c]);
                    ++c;
                }
                ++i;
            }
        }
        if (this.spanPredictor.useBeginAndEndPairs) {
            tmp = this.spanPredictor.beginPairScore;
            i = 0;
            while (i < tmp.length) {
                c = 0;
                while (c < tmp[0].length) {
                    logProbs[ind++] = Math.log(tmp[i][c]);
                    ++c;
                }
                ++i;
            }
            tmp = this.spanPredictor.endPairScore;
            i = 0;
            while (i < tmp.length) {
                c = 0;
                while (c < tmp[0].length) {
                    logProbs[ind++] = Math.log(tmp[i][c]);
                    ++c;
                }
                ++i;
            }
        }
        if (this.spanPredictor.usePunctuation) {
            tmp = this.spanPredictor.punctuationScores;
            i = 0;
            while (i < tmp.length) {
                c = 0;
                while (c < tmp[0].length) {
                    logProbs[ind++] = Math.log(tmp[i][c]);
                    ++c;
                }
                ++i;
            }
        }
        return logProbs;
    }

    @Override
    public double[] getLinearizedWeights() {
        double[] initialGrammarWeights = ConditionalTrainer.Options.lockGrammar ? new double[]{} : this.getLinearizedGrammar();
        double[] initialLexiconWeights = ConditionalTrainer.Options.lockGrammar ? new double[]{} : this.getLinearizedLexicon();
        double[] initialSpanWeights = this.getLinearizedSpanPredictor();
        double[] curWeights = new double[this.dimension()];
        int j = 0;
        int i = 0;
        while (i < initialGrammarWeights.length) {
            curWeights[j++] = initialGrammarWeights[i];
            ++i;
        }
        i = 0;
        while (i < initialLexiconWeights.length) {
            curWeights[j++] = initialLexiconWeights[i];
            ++i;
        }
        i = 0;
        while (i < initialSpanWeights.length) {
            curWeights[j++] = initialSpanWeights[i];
            ++i;
        }
        return curWeights;
    }

    @Override
    public Grammar getGrammar() {
        return this.grammar;
    }

    @Override
    public SimpleLexicon getLexicon() {
        return this.lexicon;
    }

    @Override
    public SpanPredictor getSpanPredictor() {
        return this.spanPredictor;
    }

    @Override
    public double[] getLinearizedGrammar() {
        return this.getLinearizedGrammar(false);
    }

    @Override
    public void increment(double[] counts, List<StateSet> sentence, double[][][] weights, boolean isGold) {
        int c;
        int c2;
        int length = sentence.size();
        int previousIndex = -1;
        int nextIndex = -1;
        if (this.spanPredictor.usePunctuation) {
            int[][] punctSignatures = this.spanPredictor.getPunctuationSignatures(sentence);
            int start = 0;
            while (start <= length - this.spanPredictor.minSpanLength) {
                int end = start + this.spanPredictor.minSpanLength;
                while (end <= length) {
                    int sig = punctSignatures[start][end];
                    if (sig != -1) {
                        sig *= this.nClasses;
                        c2 = 0;
                        while (c2 < this.nClasses) {
                            int n = this.startIndexPunctuation + sig + c2;
                            counts[n] = counts[n] - weights[start][end][c2];
                            ++c2;
                        }
                    }
                    ++end;
                }
                ++start;
            }
        }
        int start = 0;
        while (start <= length - this.spanPredictor.minSpanLength) {
            int beginI;
            StateSet stateSet = sentence.get(start);
            int firstIndex = stateSet.sigIndex < 0 ? stateSet.wordIndex : stateSet.sigIndex;
            this.spanPredictor.getClass();
            firstIndex = stateSet.wordIndex;
            double[] total = new double[this.nClasses];
            int end = start + this.spanPredictor.minSpanLength;
            while (end <= length) {
                c2 = 0;
                while (c2 < total.length) {
                    int n = c2;
                    total[n] = total[n] + weights[start][end][c2];
                    ++c2;
                }
                ++end;
            }
            int firstI = this.startSpanWeights + firstIndex * this.nClasses;
            int prevI = this.startIndexPrevious + previousIndex * this.nClasses;
            c = 0;
            while (c < total.length) {
                double t = total[c];
                if (t != 0.0) {
                    if (this.spanPredictor.useFirstAndLast) {
                        int n = firstI + c;
                        counts[n] = counts[n] - t;
                    }
                    if (this.spanPredictor.usePreviousAndNext && previousIndex != -1) {
                        int n = prevI + c;
                        counts[n] = counts[n] - t;
                    }
                }
                ++c;
            }
            if (this.spanPredictor.useBeginAndEndPairs && previousIndex != -1 && (beginI = this.spanPredictor.getBeginIndex(previousIndex, firstIndex) * this.nClasses) >= 0) {
                beginI += this.startIndexBeginPair;
                int c3 = 0;
                while (c3 < total.length) {
                    double t = total[c3];
                    if (t != 0.0) {
                        int n = beginI + c3;
                        counts[n] = counts[n] - t;
                    }
                    ++c3;
                }
            }
            previousIndex = firstIndex;
            ++start;
        }
        int end = length;
        while (end >= this.spanPredictor.minSpanLength) {
            int endI;
            StateSet stateSet = sentence.get(end - 1);
            int lastIndex = stateSet.sigIndex < 0 ? stateSet.wordIndex : stateSet.sigIndex;
            this.spanPredictor.getClass();
            lastIndex = stateSet.wordIndex;
            double[] total = new double[this.spanPredictor.getNClasses()];
            int start2 = 0;
            while (start2 <= end - this.spanPredictor.minSpanLength) {
                c2 = 0;
                while (c2 < total.length) {
                    int n = c2;
                    total[n] = total[n] + weights[start2][end][c2];
                    ++c2;
                }
                ++start2;
            }
            int lastI = this.startIndexLast + lastIndex * this.nClasses;
            int nextI = this.startIndexNext + nextIndex * this.nClasses;
            c = 0;
            while (c < total.length) {
                if (this.spanPredictor.useFirstAndLast) {
                    int n = lastI + c;
                    counts[n] = counts[n] - total[c];
                }
                if (this.spanPredictor.usePreviousAndNext && nextIndex != -1) {
                    int n = nextI + c;
                    counts[n] = counts[n] - total[c];
                }
                ++c;
            }
            if (this.spanPredictor.useBeginAndEndPairs && nextIndex != -1 && (endI = this.spanPredictor.getEndIndex(lastIndex, nextIndex) * this.nClasses) >= 0) {
                endI += this.startIndexEndPair;
                int c4 = 0;
                while (c4 < total.length) {
                    int n = endI + c4;
                    counts[n] = counts[n] - total[c4];
                    ++c4;
                }
            }
            nextIndex = lastIndex;
            --end;
        }
    }

    @Override
    public double[] getLinearizedSpanPredictor() {
        return this.getLinearizedSpanPredictor(false);
    }

    @Override
    public int getNGrammarWeights() {
        return this.nGrammarWeights;
    }

    @Override
    public int getNLexiconWeights() {
        return this.nLexiconWeights;
    }

    @Override
    public int getNSpanWeights() {
        return this.nSpanWeights;
    }
}

