/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.discPCFG;

import edu.berkeley.nlp.PCFGLA.BinaryRule;
import edu.berkeley.nlp.PCFGLA.Grammar;
import edu.berkeley.nlp.PCFGLA.HierarchicalBinaryRule;
import edu.berkeley.nlp.PCFGLA.HierarchicalGrammar;
import edu.berkeley.nlp.PCFGLA.HierarchicalLexicon;
import edu.berkeley.nlp.PCFGLA.HierarchicalUnaryRule;
import edu.berkeley.nlp.PCFGLA.Rule;
import edu.berkeley.nlp.PCFGLA.SimpleLexicon;
import edu.berkeley.nlp.PCFGLA.SpanPredictor;
import edu.berkeley.nlp.PCFGLA.UnaryRule;
import edu.berkeley.nlp.discPCFG.DefaultLinearizer;
import edu.berkeley.nlp.math.SloppyMath;
import edu.berkeley.nlp.syntax.StateSet;
import edu.berkeley.nlp.util.ArrayUtil;

public class HierarchicalLinearizer
extends DefaultLinearizer {
    private static final long serialVersionUID = 1L;
    HierarchicalGrammar grammar;
    HierarchicalLexicon lexicon;
    int finalLevel;
    int[][] lexiconMapping;
    int[][][] unaryMapping;
    int[][][][] binaryMapping;

    public HierarchicalLinearizer() {
    }

    public HierarchicalLinearizer(Grammar grammar, SimpleLexicon lexicon, SpanPredictor sp, int fLevel) {
        this.grammar = (HierarchicalGrammar)grammar;
        this.lexicon = (HierarchicalLexicon)lexicon;
        this.spanPredictor = sp;
        this.finalLevel = fLevel;
        this.nSubstates = (int)ArrayUtil.max(grammar.numSubStates);
        this.init();
        this.computeMappings();
    }

    protected void computeMappings() {
        this.lexiconMapping = new int[this.finalLevel + 1][this.nSubstates];
        this.unaryMapping = new int[this.finalLevel + 1][this.nSubstates][this.nSubstates];
        this.binaryMapping = new int[this.finalLevel + 1][this.nSubstates][this.nSubstates][this.nSubstates];
        int[] divisors = new int[this.finalLevel + 1];
        int i = 0;
        while (i <= this.finalLevel) {
            divisors[i] = (int)Math.pow(2.0, this.finalLevel - i);
            ++i;
        }
        int level = 1;
        while (level <= this.finalLevel) {
            int k;
            int j;
            int div = divisors[level];
            int l = (int)Math.pow(2.0, level);
            int[][] tmpU = new int[l][l];
            int[][][] tmpB = new int[l][l][l];
            int indU = 0;
            int indB = 0;
            int i2 = 0;
            while (i2 < l) {
                j = 0;
                while (j < l) {
                    tmpU[i2][j] = indU++;
                    k = 0;
                    while (k < l) {
                        tmpB[i2][j][k] = indB++;
                        ++k;
                    }
                    ++j;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < this.nSubstates) {
                this.lexiconMapping[level][i2] = i2 / div;
                j = 0;
                while (j < this.nSubstates) {
                    this.unaryMapping[level][i2][j] = tmpU[i2 / div][j / div];
                    k = 0;
                    while (k < this.nSubstates) {
                        this.binaryMapping[level][i2][j][k] = tmpB[i2 / div][j / div][k / div];
                        ++k;
                    }
                    ++j;
                }
                ++i2;
            }
            ++level;
        }
    }

    public void delinearizeGrammar(double[] probs) {
        int k;
        int j;
        Object scores;
        int ind;
        Rule hRule;
        int nDangerous = 0;
        for (BinaryRule bRule : this.grammar.binaryRuleMap.keySet()) {
            hRule = (HierarchicalBinaryRule)bRule;
            ind = ((HierarchicalBinaryRule)hRule).identifier;
            scores = ((HierarchicalBinaryRule)hRule).getLastLevel();
            j = 0;
            while (j < ((double[][][])scores).length) {
                k = 0;
                while (k < scores[j].length) {
                    if (scores[j][k] != null) {
                        int l = 0;
                        while (l < scores[j][k].length) {
                            double val;
                            if (SloppyMath.isVeryDangerous(val = probs[ind++])) {
                                ++nDangerous;
                            } else {
                                scores[j][k][l] = val;
                            }
                            ++l;
                        }
                    }
                    ++k;
                }
                ++j;
            }
        }
        if (nDangerous > 0) {
            System.out.println("Left " + nDangerous + " binary rule weights unchanged since the proposed weight was dangerous.");
        }
        nDangerous = 0;
        for (UnaryRule uRule : this.grammar.unaryRuleMap.keySet()) {
            hRule = (HierarchicalUnaryRule)uRule;
            ind = ((HierarchicalUnaryRule)hRule).identifier;
            if (uRule.childState == uRule.parentState) continue;
            scores = ((HierarchicalUnaryRule)hRule).getLastLevel();
            j = 0;
            while (j < ((double[][][])scores).length) {
                if (scores[j] != null) {
                    k = 0;
                    while (k < scores[j].length) {
                        double val;
                        if (SloppyMath.isVeryDangerous(val = probs[ind++])) {
                            ++nDangerous;
                        } else {
                            scores[j][k] = (double[])val;
                        }
                        ++k;
                    }
                }
                ++j;
            }
        }
        if (nDangerous > 0) {
            System.out.println("Left " + nDangerous + " unary rule weights unchanged since the proposed weight was dangerous.");
        }
        this.grammar.explicitlyComputeScores(this.finalLevel);
        this.grammar.closedViterbiRulesWithParent = this.grammar.unaryRulesWithParent;
        this.grammar.closedSumRulesWithParent = this.grammar.unaryRulesWithParent;
        this.grammar.closedViterbiRulesWithChild = this.grammar.unaryRulesWithC;
        this.grammar.closedSumRulesWithChild = this.grammar.unaryRulesWithC;
        this.grammar.clearUnaryIntermediates();
        this.grammar.makeCRArrays();
    }

    public void delinearizeLexicon(double[] logProbs) {
        int nDangerous = 0;
        int tag = 0;
        while (tag < this.lexicon.hierarchicalScores.length) {
            int word = 0;
            while (word < this.lexicon.hierarchicalScores[tag].length) {
                int index = this.linearIndex[tag][word];
                double[] vals = this.lexicon.getLastLevel(tag, word);
                int substate = 0;
                while (substate < vals.length) {
                    double val;
                    if (SloppyMath.isVeryDangerous(val = logProbs[index++])) {
                        ++nDangerous;
                    } else {
                        vals[substate] = val;
                    }
                    ++substate;
                }
                ++word;
            }
            tag = (short)(tag + 1);
        }
        if (nDangerous > 0) {
            System.out.println("Left " + nDangerous + " lexicon weights unchanged since the proposed weight was dangerous.");
        }
        this.lexicon.explicitlyComputeScores(this.finalLevel);
    }

    public double[] getLinearizedGrammar(boolean update) {
        int k;
        int j;
        int ind;
        Rule hRule;
        if (update) {
            int j2;
            Object scores;
            Rule hRule2;
            this.nGrammarWeights = 0;
            for (BinaryRule bRule : this.grammar.binaryRuleMap.keySet()) {
                hRule2 = (HierarchicalBinaryRule)bRule;
                if (!this.grammar.isGrammarTag[bRule.parentState]) {
                    System.out.println("Incorrect grammar tag");
                }
                bRule.identifier = this.nGrammarWeights;
                scores = ((HierarchicalBinaryRule)hRule2).getLastLevel();
                j2 = 0;
                while (j2 < ((double[][][])scores).length) {
                    int k2 = 0;
                    while (k2 < scores[j2].length) {
                        if (scores[j2][k2] != null) {
                            this.nGrammarWeights += scores[j2][k2].length;
                        }
                        ++k2;
                    }
                    ++j2;
                }
            }
            for (UnaryRule uRule : this.grammar.unaryRuleMap.keySet()) {
                hRule2 = (HierarchicalUnaryRule)uRule;
                uRule.identifier = this.nGrammarWeights;
                scores = ((HierarchicalUnaryRule)hRule2).getLastLevel();
                j2 = 0;
                while (j2 < ((double[][][])scores).length) {
                    if (scores[j2] != null) {
                        this.nGrammarWeights += scores[j2].length;
                    }
                    ++j2;
                }
            }
        }
        double[] logProbs = new double[this.nGrammarWeights];
        for (BinaryRule bRule : this.grammar.binaryRuleMap.keySet()) {
            hRule = (HierarchicalBinaryRule)bRule;
            ind = ((HierarchicalBinaryRule)hRule).identifier;
            double[][][] scores = ((HierarchicalBinaryRule)hRule).getLastLevel();
            j = 0;
            while (j < scores.length) {
                k = 0;
                while (k < scores[j].length) {
                    if (scores[j][k] != null) {
                        int l = 0;
                        while (l < scores[j][k].length) {
                            double val = scores[j][k][l];
                            logProbs[ind++] = val;
                            ++l;
                        }
                    }
                    ++k;
                }
                ++j;
            }
        }
        for (UnaryRule uRule : this.grammar.unaryRuleMap.keySet()) {
            hRule = (HierarchicalUnaryRule)uRule;
            ind = ((HierarchicalUnaryRule)hRule).identifier;
            if (uRule.childState == uRule.parentState) continue;
            double[][] scores = ((HierarchicalUnaryRule)hRule).getLastLevel();
            j = 0;
            while (j < scores.length) {
                if (scores[j] != null) {
                    k = 0;
                    while (k < scores[j].length) {
                        double val = scores[j][k];
                        logProbs[ind++] = val;
                        ++k;
                    }
                }
                ++j;
            }
        }
        return logProbs;
    }

    public double[] getLinearizedLexicon(boolean update) {
        if (update) {
            this.nLexiconWeights = 0;
            int[] substates = new int[this.finalLevel + 1];
            int i = 0;
            while (i <= this.finalLevel) {
                substates[i] = (int)Math.pow(2.0, i);
                ++i;
            }
            int tag = 0;
            while (tag < this.lexicon.hierarchicalScores.length) {
                int word = 0;
                while (word < this.lexicon.hierarchicalScores[tag].length) {
                    this.nLexiconWeights += this.lexicon.getLastLevel(tag, word).length;
                    ++word;
                }
                tag = (short)(tag + 1);
            }
        }
        double[] logProbs = new double[this.nLexiconWeights];
        if (update) {
            this.linearIndex = new int[this.lexicon.hierarchicalScores.length][];
        }
        int index = 0;
        int tag = 0;
        while (tag < this.lexicon.hierarchicalScores.length) {
            if (update) {
                this.linearIndex[tag] = new int[this.lexicon.hierarchicalScores[tag].length];
            }
            int word = 0;
            while (word < this.lexicon.hierarchicalScores[tag].length) {
                if (update) {
                    this.linearIndex[tag][word] = index + this.nGrammarWeights;
                }
                double[] vals = this.lexicon.getLastLevel(tag, word);
                int substate = 0;
                while (substate < vals.length) {
                    double val = vals[substate];
                    logProbs[index++] = val;
                    ++substate;
                }
                ++word;
            }
            tag = (short)(tag + 1);
        }
        if (index != logProbs.length) {
            System.out.println("unequal length in lexicon");
        }
        return logProbs;
    }

    public int getLinearIndex(int globalWordIndex, int tag) {
        int tagSpecificWordIndex = this.lexicon.tagWordIndexer[tag].indexOf(globalWordIndex);
        if (tagSpecificWordIndex == -1) {
            return -1;
        }
        return this.linearIndex[tag][tagSpecificWordIndex];
    }

    public int dimension() {
        return this.nGrammarWeights + this.nLexiconWeights + this.nSpanWeights;
    }

    public void increment(double[] counts, StateSet stateSet, int tag, double[] weights, boolean isGold) {
        int globalWordIndex;
        int startIndexWord;
        int i;
        int startIndexWord2;
        int globalSigIndex = stateSet.sigIndex;
        if (globalSigIndex != -1 && (startIndexWord2 = this.getLinearIndex(globalSigIndex, tag)) >= 0) {
            int finalLevel = this.lexicon.getFinalLevel(globalSigIndex, tag);
            i = 0;
            while (i < this.nSubstates) {
                if (isGold) {
                    int n = startIndexWord2 + this.lexiconMapping[finalLevel][i];
                    counts[n] = counts[n] + weights[i];
                } else {
                    int n = startIndexWord2 + this.lexiconMapping[finalLevel][i];
                    counts[n] = counts[n] - weights[i];
                }
                ++i;
            }
        }
        if ((startIndexWord = this.getLinearIndex(globalWordIndex = stateSet.wordIndex, tag)) >= 0) {
            int finalLevel = this.lexicon.getFinalLevel(globalWordIndex, tag);
            int i2 = 0;
            while (i2 < this.nSubstates) {
                if (isGold) {
                    int n = startIndexWord + this.lexiconMapping[finalLevel][i2];
                    counts[n] = counts[n] + weights[i2];
                } else {
                    int n = startIndexWord + this.lexiconMapping[finalLevel][i2];
                    counts[n] = counts[n] - weights[i2];
                }
                weights[i2] = 0.0;
                ++i2;
            }
        } else {
            i = 0;
            while (i < this.nSubstates) {
                weights[i] = 0.0;
                ++i;
            }
        }
    }

    public void increment(double[] counts, UnaryRule rule, double[] weights, boolean isGold) {
        HierarchicalUnaryRule hr = (HierarchicalUnaryRule)rule;
        int thisStartIndex = hr.identifier;
        int finalLevel = hr.lastLevel;
        int curInd = 0;
        if (rule.parentState == 0) {
            int cp = 0;
            while (cp < this.nSubstates) {
                double val = weights[curInd];
                if (val > 0.0) {
                    if (isGold) {
                        int n = thisStartIndex + this.lexiconMapping[finalLevel][cp];
                        counts[n] = counts[n] + val;
                    } else {
                        int n = thisStartIndex + this.lexiconMapping[finalLevel][cp];
                        counts[n] = counts[n] - val;
                    }
                    weights[curInd] = 0.0;
                }
                ++curInd;
                ++cp;
            }
            return;
        }
        int cp = 0;
        while (cp < this.nSubstates) {
            int np = 0;
            while (np < this.nSubstates) {
                double val = weights[curInd];
                if (val > 0.0) {
                    if (isGold) {
                        int n = thisStartIndex + this.unaryMapping[finalLevel][cp][np];
                        counts[n] = counts[n] + val;
                    } else {
                        int n = thisStartIndex + this.unaryMapping[finalLevel][cp][np];
                        counts[n] = counts[n] - val;
                    }
                    weights[curInd] = 0.0;
                }
                ++curInd;
                ++np;
            }
            ++cp;
        }
    }

    public void increment(double[] counts, BinaryRule rule, double[] weights, boolean isGold) {
        HierarchicalBinaryRule hr = (HierarchicalBinaryRule)rule;
        int thisStartIndex = hr.identifier;
        int finalLevel = hr.lastLevel;
        int curInd = 0;
        int lp = 0;
        while (lp < this.nSubstates) {
            int rp = 0;
            while (rp < this.nSubstates) {
                int np = 0;
                while (np < this.nSubstates) {
                    double val = weights[curInd];
                    if (val > 0.0) {
                        if (isGold) {
                            int n = thisStartIndex + this.binaryMapping[finalLevel][lp][rp][np];
                            counts[n] = counts[n] + val;
                        } else {
                            int n = thisStartIndex + this.binaryMapping[finalLevel][lp][rp][np];
                            counts[n] = counts[n] - val;
                        }
                        weights[curInd] = 0.0;
                    }
                    ++curInd;
                    ++np;
                }
                ++rp;
            }
            ++lp;
        }
    }

    public Grammar getGrammar() {
        return this.grammar;
    }

    public SimpleLexicon getLexicon() {
        return this.lexicon;
    }

    public SpanPredictor getSpanPredictor() {
        return this.spanPredictor;
    }
}

