/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.syntax;

import edu.berkeley.nlp.ling.CollinsHeadFinder;
import edu.berkeley.nlp.ling.HeadFinder;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.syntax.TreePathFinder;
import edu.berkeley.nlp.syntax.Trees;
import edu.berkeley.nlp.util.CollectionUtils;
import edu.berkeley.nlp.util.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrammaticalRelation {
    private static final Set<String> isVerbs = new HashSet<String>(CollectionUtils.makeList("is", "was"));

    public static Pair<Tree<String>, Tree<String>> getSubjectObject(TreePathFinder<String> tpf, Tree<String> vpNode) {
        if (!vpNode.getLabel().startsWith("VP")) {
            throw new IllegalArgumentException(vpNode + " is not a VP");
        }
        List<Tree<String>> childs = vpNode.getChildren();
        Tree<String> subj = null;
        for (Tree<String> node : tpf.getRoot().getPostOrderTraversal()) {
            Tree<String> lcaNode;
            if (!node.getLabel().startsWith("NP") || !(lcaNode = tpf.findLowestCommonAncestor(node, vpNode)).getLabel().startsWith("S") || tpf.findParent(node) != lcaNode) continue;
            subj = node;
            break;
        }
        Tree<String> obj = null;
        int c = 0;
        while (c < childs.size()) {
            Tree<String> child = childs.get(c);
            if (child.isPhrasal() && child.getLabel().startsWith("NP")) {
                obj = child;
                break;
            }
            ++c;
        }
        if (subj == null || obj == null) {
            return null;
        }
        return Pair.newPair(subj, obj);
    }

    public static List<Pair<Tree<String>, Tree<String>>> getPredicateNominativePairs(TreePathFinder<String> tpf, Tree<String> root, HeadFinder hf) {
        ArrayList<Tree<String>> vpNodes = new ArrayList<Tree<String>>();
        for (Tree<String> node : tpf.getRoot().getPostOrderTraversal()) {
            Pair<String, String> p;
            String headWord;
            if (!node.getLabel().startsWith("VP") || !isVerbs.contains((headWord = (p = HeadFinder.Utils.getHeadWordAndPartOfSpeechPair(hf, node)).getFirst()).toLowerCase())) continue;
            vpNodes.add(node);
        }
        ArrayList<Pair<Tree<String>, Tree<String>>> result = new ArrayList<Pair<Tree<String>, Tree<String>>>();
        for (Tree tree : vpNodes) {
            Pair<Tree<String>, Tree<String>> treeTreePair = GrammaticalRelation.getSubjectObject(tpf, tree);
            if (treeTreePair == null) continue;
            result.add(treeTreePair);
        }
        return result;
    }

    public static void main(String[] args) {
        Tree<String> t = Trees.PennTreeReader.parseEasy("(ROOT (S (NP (NNP John)) (VP (VBD was) (NP (DT a) (NN man)))))");
        TreePathFinder<String> tpf = new TreePathFinder<String>(t);
        System.out.println(GrammaticalRelation.getPredicateNominativePairs(tpf, t, new CollinsHeadFinder()));
    }
}

