/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.syntax;

import edu.berkeley.nlp.syntax.Constituent;
import edu.berkeley.nlp.util.CollectionUtils;
import edu.berkeley.nlp.util.MapFactory;
import edu.berkeley.nlp.util.MyMethod;
import edu.berkeley.nlp.util.Pair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tree<L>
implements Serializable,
Comparable<Tree<L>>,
Iterable<Tree<L>> {
    private static final long serialVersionUID = 1L;
    L label;
    List<Tree<L>> children;

    public void setChild(int i, Tree<L> child) {
        this.children.set(i, child);
    }

    public void setChildren(List<Tree<L>> c) {
        this.children = c;
    }

    public List<Tree<L>> getChildren() {
        return this.children;
    }

    public Tree<L> getChild(int i) {
        return this.children.get(i);
    }

    public L getLabel() {
        return this.label;
    }

    public boolean isLeaf() {
        return this.getChildren().isEmpty();
    }

    public boolean isPreTerminal() {
        return this.getChildren().size() == 1 && this.getChildren().get(0).isLeaf();
    }

    public List<L> getYield() {
        ArrayList yield = new ArrayList();
        Tree.appendYield(this, yield);
        return yield;
    }

    public Collection<Constituent<L>> getConstituentCollection() {
        ArrayList<Constituent<L>> constituents = new ArrayList<Constituent<L>>();
        Tree.appendConstituent(this, constituents, 0);
        return constituents;
    }

    public Map<Tree<L>, Constituent<L>> getConstituents() {
        IdentityHashMap<Tree<L>, Constituent<L>> constituents = new IdentityHashMap<Tree<L>, Constituent<L>>();
        Tree.appendConstituent(this, constituents, 0);
        return constituents;
    }

    public Map<Pair<Integer, Integer>, List<Tree<L>>> getSpanMap() {
        Map<Tree<L>, Constituent<L>> cMap = this.getConstituents();
        HashMap<Pair<Integer, Integer>, List<Tree<L>>> spanMap = new HashMap<Pair<Integer, Integer>, List<Tree<L>>>();
        for (Map.Entry<Tree<L>, Constituent<L>> entry : cMap.entrySet()) {
            Tree<L> t = entry.getKey();
            Constituent<L> c = entry.getValue();
            Pair<Integer, Integer> span = Pair.newPair(c.getStart(), c.getEnd() + 1);
            CollectionUtils.addToValueList(spanMap, span, t);
        }
        for (List trees : spanMap.values()) {
            Collections.sort(trees, new Comparator<Tree<L>>(){

                @Override
                public int compare(Tree<L> t1, Tree<L> t2) {
                    return t2.getDepth() - t1.getDepth();
                }
            });
        }
        return spanMap;
    }

    public Map<Tree<L>, Constituent<L>> getConstituents(MapFactory mf) {
        Map<Tree<L>, Constituent<L>> constituents = mf.buildMap();
        Tree.appendConstituent(this, constituents, 0);
        return constituents;
    }

    private static <L> int appendConstituent(Tree<L> tree, Map<Tree<L>, Constituent<L>> constituents, int index) {
        if (tree.isLeaf()) {
            Constituent<L> c = new Constituent<L>(tree.getLabel(), index, index);
            constituents.put(tree, c);
            return 1;
        }
        int nextIndex = index;
        for (Tree<L> kid : tree.getChildren()) {
            nextIndex += Tree.appendConstituent(kid, constituents, nextIndex);
        }
        Constituent<L> c = new Constituent<L>(tree.getLabel(), index, nextIndex - 1);
        constituents.put(tree, c);
        return nextIndex - index;
    }

    private static <L> int appendConstituent(Tree<L> tree, Collection<Constituent<L>> constituents, int index) {
        if (tree.isLeaf() || tree.isPreTerminal()) {
            Constituent<L> c = new Constituent<L>(tree.getLabel(), index, index);
            constituents.add(c);
            return 1;
        }
        int nextIndex = index;
        for (Tree<L> kid : tree.getChildren()) {
            nextIndex += Tree.appendConstituent(kid, constituents, nextIndex);
        }
        Constituent<L> c = new Constituent<L>(tree.getLabel(), index, nextIndex - 1);
        constituents.add(c);
        return nextIndex - index;
    }

    private static <L> void appendNonTerminals(Tree<L> tree, List<Tree<L>> yield) {
        if (tree.isLeaf()) {
            return;
        }
        yield.add(tree);
        for (Tree<L> child : tree.getChildren()) {
            Tree.appendNonTerminals(child, yield);
        }
    }

    public List<Tree<L>> getTerminals() {
        ArrayList<Tree<L>> yield = new ArrayList<Tree<L>>();
        Tree.appendTerminals(this, yield);
        return yield;
    }

    public List<Tree<L>> getNonTerminals() {
        ArrayList<Tree<L>> yield = new ArrayList<Tree<L>>();
        Tree.appendNonTerminals(this, yield);
        return yield;
    }

    private static <L> void appendTerminals(Tree<L> tree, List<Tree<L>> yield) {
        if (tree.isLeaf()) {
            yield.add(tree);
            return;
        }
        for (Tree<L> child : tree.getChildren()) {
            Tree.appendTerminals(child, yield);
        }
    }

    public Tree<L> shallowClone() {
        ArrayList<Tree<L>> newChildren = new ArrayList<Tree<L>>(this.children.size());
        for (Tree<L> child : this.children) {
            newChildren.add(child.shallowClone());
        }
        return new Tree<L>(this.label, newChildren);
    }

    public Tree<L> shallowCloneJustRoot() {
        return new Tree<L>(this.label);
    }

    private static <L> void appendYield(Tree<L> tree, List<L> yield) {
        if (tree.isLeaf()) {
            yield.add(tree.getLabel());
            return;
        }
        for (Tree<L> child : tree.getChildren()) {
            Tree.appendYield(child, yield);
        }
    }

    public List<L> getPreTerminalYield() {
        ArrayList yield = new ArrayList();
        Tree.appendPreTerminalYield(this, yield);
        return yield;
    }

    public List<L> getTerminalYield() {
        List<Tree<L>> terms = this.getTerminals();
        ArrayList<L> yield = new ArrayList<L>();
        for (Tree<L> term : terms) {
            yield.add(term.getLabel());
        }
        return yield;
    }

    public List<Tree<L>> getPreTerminals() {
        ArrayList<Tree<L>> preterms = new ArrayList<Tree<L>>();
        Tree.appendPreTerminals(this, preterms);
        return preterms;
    }

    public List<Tree<L>> getTreesOfDepth(int depth) {
        ArrayList<Tree<L>> trees = new ArrayList<Tree<L>>();
        Tree.appendTreesOfDepth(this, trees, depth);
        return trees;
    }

    private static <L> void appendPreTerminalYield(Tree<L> tree, List<L> yield) {
        if (tree.isPreTerminal()) {
            yield.add(tree.getLabel());
            return;
        }
        for (Tree<L> child : tree.getChildren()) {
            Tree.appendPreTerminalYield(child, yield);
        }
    }

    private static <L> void appendPreTerminals(Tree<L> tree, List<Tree<L>> yield) {
        if (tree.isPreTerminal()) {
            yield.add(tree);
            return;
        }
        for (Tree<L> child : tree.getChildren()) {
            Tree.appendPreTerminals(child, yield);
        }
    }

    private static <L> void appendTreesOfDepth(Tree<L> tree, List<Tree<L>> yield, int depth) {
        if (tree.getDepth() == depth) {
            yield.add(tree);
            return;
        }
        for (Tree<L> child : tree.getChildren()) {
            Tree.appendTreesOfDepth(child, yield, depth);
        }
    }

    public List<Tree<L>> getPreOrderTraversal() {
        ArrayList<Tree<L>> traversal = new ArrayList<Tree<L>>();
        Tree.traversalHelper(this, traversal, true);
        return traversal;
    }

    public List<Tree<L>> getPostOrderTraversal() {
        ArrayList<Tree<L>> traversal = new ArrayList<Tree<L>>();
        Tree.traversalHelper(this, traversal, false);
        return traversal;
    }

    private static <L> void traversalHelper(Tree<L> tree, List<Tree<L>> traversal, boolean preOrder) {
        if (preOrder) {
            traversal.add(tree);
        }
        for (Tree<L> child : tree.getChildren()) {
            Tree.traversalHelper(child, traversal, preOrder);
        }
        if (!preOrder) {
            traversal.add(tree);
        }
    }

    public int getDepth() {
        int maxDepth = 0;
        for (Tree<L> child : this.children) {
            int depth = child.getDepth();
            if (depth <= maxDepth) continue;
            maxDepth = depth;
        }
        return maxDepth + 1;
    }

    public int size() {
        int sum = 0;
        for (Tree<L> child : this.children) {
            sum += child.size();
        }
        return sum + 1;
    }

    public List<Tree<L>> getAtDepth(int depth) {
        ArrayList<Tree<L>> yield = new ArrayList<Tree<L>>();
        Tree.appendAtDepth(depth, this, yield);
        return yield;
    }

    private static <L> void appendAtDepth(int depth, Tree<L> tree, List<Tree<L>> yield) {
        if (depth < 0) {
            return;
        }
        if (depth == 0) {
            yield.add(tree);
            return;
        }
        for (Tree<L> child : tree.getChildren()) {
            Tree.appendAtDepth(depth - 1, child, yield);
        }
    }

    public void setLabel(L label) {
        this.label = label;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toStringBuilder(sb);
        return sb.toString();
    }

    public void toStringBuilder(StringBuilder sb) {
        if (!this.isLeaf()) {
            sb.append('(');
        }
        if (this.getLabel() != null) {
            sb.append(this.getLabel());
        }
        if (!this.isLeaf()) {
            for (Tree<L> child : this.getChildren()) {
                sb.append(' ');
                child.toStringBuilder(sb);
            }
            sb.append(')');
        }
    }

    public String toEscapedString() {
        StringBuilder sb = new StringBuilder();
        this.toStringBuilderEscaped(sb);
        return sb.toString();
    }

    public void toStringBuilderEscaped(StringBuilder sb) {
        if (!this.isLeaf()) {
            sb.append('(');
        }
        if (this.getLabel() != null) {
            if (this.isLeaf()) {
                String escapedLabel = this.getLabel().toString();
                escapedLabel = escapedLabel.replaceAll("\\(", "-LRB-");
                escapedLabel = escapedLabel.replaceAll("\\)", "-RRB-");
                escapedLabel = escapedLabel.replaceAll("\\\\", "-BACKSLASH-");
                sb.append(escapedLabel);
            } else {
                sb.append(this.getLabel());
            }
        }
        if (!this.isLeaf()) {
            for (Tree<L> child : this.getChildren()) {
                sb.append(' ');
                child.toStringBuilderEscaped(sb);
            }
            sb.append(')');
        }
    }

    public Tree(L label, List<Tree<L>> children) {
        this.label = label;
        this.children = children;
    }

    public Tree(L label) {
        this.label = label;
        this.children = Collections.emptyList();
    }

    public Set<Tree<L>> subTrees() {
        return (Set)this.subTrees(new HashSet<Tree<L>>());
    }

    public List<Tree<L>> subTreeList() {
        return (List)this.subTrees(new ArrayList<Tree<L>>());
    }

    public Collection<Tree<L>> subTrees(Collection<Tree<L>> n) {
        n.add(this);
        List<Tree<L>> kids = this.getChildren();
        for (Tree<L> kid : kids) {
            kid.subTrees(n);
        }
        return n;
    }

    @Override
    public Iterator<Tree<L>> iterator() {
        return new TreeIterator();
    }

    public <O> Tree<O> transformNodes(MyMethod<L, O> trans) {
        ArrayList<Tree<L>> newChildren = new ArrayList<Tree<L>>(this.children.size());
        for (Tree<L> child : this.children) {
            newChildren.add(child.transformNodes(trans));
        }
        return new Tree<O>(trans.call(this.label), newChildren);
    }

    public <O> Tree<O> transformNodesUsingNode(MyMethod<Tree<L>, O> trans) {
        ArrayList<Tree<L>> newChildren = new ArrayList<Tree<L>>(this.children.size());
        O newLabel = trans.call(this);
        for (Tree<L> child : this.children) {
            newChildren.add(child.transformNodesUsingNode(trans));
        }
        return new Tree<O>(newLabel, newChildren);
    }

    public <O> Tree<O> transformNodesUsingNodePostOrder(MyMethod<Tree<L>, O> trans) {
        ArrayList<Tree<L>> newChildren = new ArrayList<Tree<L>>(this.children.size());
        for (Tree<L> child : this.children) {
            newChildren.add(child.transformNodesUsingNode(trans));
        }
        O newLabel = trans.call(this);
        return new Tree<O>(newLabel, newChildren);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        for (Tree<L> child : this.children) {
            result = 31 * result + (child == null ? 0 : child.hashCode());
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!(obj instanceof Tree)) {
            return false;
        }
        Tree other = (Tree)obj;
        if (!this.label.equals(other.label)) {
            return false;
        }
        if (this.getChildren().size() != other.getChildren().size()) {
            return false;
        }
        int i = 0;
        while (i < this.getChildren().size()) {
            if (!this.getChildren().get(i).equals(other.getChildren().get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public int compareTo(Tree<L> o) {
        if (!(o.getLabel() instanceof Comparable) || !(this.getLabel() instanceof Comparable)) {
            throw new IllegalArgumentException("Tree labels are not comparable");
        }
        int cmp = ((Comparable)o.getLabel()).compareTo(this.getLabel());
        if (cmp != 0) {
            return cmp;
        }
        int cmp2 = Double.compare(this.getChildren().size(), o.getChildren().size());
        if (cmp2 != 0) {
            return cmp2;
        }
        int i = 0;
        while (i < this.getChildren().size()) {
            int cmp3 = this.getChildren().get(i).compareTo(o.getChildren().get(i));
            if (cmp3 != 0) {
                return cmp3;
            }
            ++i;
        }
        return 0;
    }

    public boolean isPhrasal() {
        return this.getYield().size() > 1;
    }

    public Constituent<L> getLeastCommonAncestorConstituent(int i, int j) {
        List<L> yield = this.getYield();
        Constituent<L> leastCommonAncestorConstituentHelper = Tree.getLeastCommonAncestorConstituentHelper(this, 0, yield.size(), i, j);
        return leastCommonAncestorConstituentHelper;
    }

    public Tree<L> getTopTreeForSpan(int i, int j) {
        List<L> yield = this.getYield();
        return Tree.getTopTreeForSpanHelper(this, 0, yield.size(), i, j);
    }

    private static <L> Tree<L> getTopTreeForSpanHelper(Tree<L> tree, int start, int end, int i, int j) {
        assert (i <= j);
        if (start == i && end == j) {
            assert (tree.getLabel().toString().matches("\\w+"));
            return tree;
        }
        LinkedList<Tree<L>> queue = new LinkedList<Tree<L>>();
        queue.addAll(tree.getChildren());
        int currStart = start;
        while (!queue.isEmpty()) {
            Tree remove = (Tree)queue.remove();
            List<L> currYield = remove.getYield();
            int currEnd = currStart + currYield.size();
            if (currStart <= i && currEnd >= j) {
                return Tree.getTopTreeForSpanHelper(remove, currStart, currEnd, i, j);
            }
            currStart += currYield.size();
        }
        return null;
    }

    private static <L> Constituent<L> getLeastCommonAncestorConstituentHelper(Tree<L> tree, int start, int end, int i, int j) {
        if (start == i && end == j) {
            return new Constituent<L>(tree.getLabel(), start, end);
        }
        LinkedList<Tree<L>> queue = new LinkedList<Tree<L>>();
        queue.addAll(tree.getChildren());
        int currStart = start;
        while (!queue.isEmpty()) {
            Tree remove = (Tree)queue.remove();
            List<L> currYield = remove.getYield();
            int currEnd = currStart + currYield.size();
            if (currStart <= i && currEnd >= j) {
                Constituent<L> leastCommonAncestorConstituentHelper = Tree.getLeastCommonAncestorConstituentHelper(remove, currStart, currEnd, i, j);
                if (leastCommonAncestorConstituentHelper == null) break;
                return leastCommonAncestorConstituentHelper;
            }
            currStart += currYield.size();
        }
        return new Constituent<L>(tree.getLabel(), start, end);
    }

    public boolean hasUnariesOtherThanRoot() {
        assert (this.children.size() == 1);
        return this.hasUnariesHelper(this.children.get(0));
    }

    private boolean hasUnariesHelper(Tree<L> tree) {
        if (tree.isPreTerminal()) {
            return false;
        }
        if (tree.getChildren().size() == 1) {
            return true;
        }
        for (Tree<L> child : tree.getChildren()) {
            if (!this.hasUnariesHelper(child)) continue;
            return true;
        }
        return false;
    }

    public boolean hasUnaryChain() {
        return this.hasUnaryChainHelper(this, false);
    }

    private boolean hasUnaryChainHelper(Tree<L> tree, boolean unaryAbove) {
        boolean result = false;
        if (tree.getChildren().size() == 1) {
            if (unaryAbove) {
                return true;
            }
            if (tree.getChildren().get(0).isPreTerminal()) {
                return false;
            }
            return this.hasUnaryChainHelper(tree.getChildren().get(0), true);
        }
        for (Tree<L> child : tree.getChildren()) {
            if (child.isPreTerminal()) continue;
            boolean bl = result = result || this.hasUnaryChainHelper(child, false);
        }
        return result;
    }

    public void removeUnaryChains() {
        this.removeUnaryChainHelper(this, null);
    }

    private void removeUnaryChainHelper(Tree<L> tree, Tree<L> parent) {
        if (tree.isLeaf()) {
            return;
        }
        if (tree.getChildren().size() == 1 && !tree.isPreTerminal()) {
            if (parent != null) {
                tree = tree.getChildren().get(0);
                parent.getChildren().set(0, tree);
                this.removeUnaryChainHelper(tree, parent);
            } else {
                this.removeUnaryChainHelper(tree.getChildren().get(0), tree);
            }
        } else {
            for (Tree<L> child : tree.getChildren()) {
                if (child.isPreTerminal()) continue;
                this.removeUnaryChainHelper(child, null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TreeIterator
    implements Iterator<Tree<L>> {
        private List<Tree<L>> treeStack = new ArrayList();

        private TreeIterator() {
            this.treeStack.add(Tree.this);
        }

        @Override
        public boolean hasNext() {
            return !this.treeStack.isEmpty();
        }

        @Override
        public Tree<L> next() {
            int lastIndex = this.treeStack.size() - 1;
            Tree tr = this.treeStack.remove(lastIndex);
            List kids = tr.getChildren();
            int i = kids.size() - 1;
            while (i >= 0) {
                this.treeStack.add(kids.get(i));
                --i;
            }
            return tr;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

