/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.tokenizer;

import edu.berkeley.nlp.tokenizer.LineTokenizer;
import edu.berkeley.nlp.tokenizer.PTBLexer;
import edu.berkeley.nlp.tokenizer.PTBTokenizer;
import edu.berkeley.nlp.util.IOUtils;
import edu.berkeley.nlp.util.Iterators;
import edu.berkeley.nlp.util.StringUtils;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PTBLineLexer
extends PTBLexer
implements LineTokenizer {
    public PTBLineLexer() {
        super((Reader)null);
    }

    public List<String> tokenize(String line) {
        PTBTokenizer toker = new PTBTokenizer(new StringReader(line), true);
        List elems = toker.tokenize();
        ArrayList<String> toks = new ArrayList<String>();
        for (Object o : elems) {
            toks.add(o.toString());
        }
        return toks;
    }

    @Override
    public List<String> tokenizeLine(String line) throws IOException {
        LinkedList<String> tokenized = new LinkedList<String>();
        int nEl = line.length();
        char[] array = line.toCharArray();
        this.yy_buffer = line.toCharArray();
        this.yy_startRead = 0;
        this.yy_endRead = this.yy_buffer.length;
        this.yy_atBOL = true;
        this.yy_atEOF = false;
        this.yy_pushbackPos = 0;
        this.yy_markedPos = 0;
        this.yy_currentPos = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.yy_lexical_state = 0;
        while (this.yy_markedPos < this.yy_endRead) {
            tokenized.add(this.next());
        }
        return tokenized;
    }

    private boolean yy_refill() throws IOException {
        return true;
    }

    public static void main(String[] argv) {
        PTBLineLexer tokenizer = new PTBLineLexer();
        try {
            for (String line : Iterators.able(IOUtils.lineIterator(argv[0]))) {
                List<String> tokenizeLine = tokenizer.tokenizeLine(line);
                if (tokenizeLine.get(tokenizeLine.size() - 1) == null) {
                    tokenizeLine.remove(tokenizeLine.size() - 1);
                }
                System.out.println(StringUtils.join(tokenizeLine));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

