/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import edu.berkeley.nlp.util.Factory;
import edu.berkeley.nlp.util.MapFactory;
import edu.berkeley.nlp.util.Pair;
import edu.berkeley.nlp.util.SetFactory;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionUtils {
    public static <E extends Comparable<E>> List<E> sort(Collection<E> c) {
        ArrayList<E> list = new ArrayList<E>(c);
        Collections.sort(list);
        return list;
    }

    public static <E> boolean isSublistOf(List<E> bigger, List<E> smaller) {
        if (smaller.size() > bigger.size()) {
            return false;
        }
        int start = 0;
        while (start + smaller.size() <= bigger.size()) {
            List<E> sublist = bigger.subList(start, start + smaller.size());
            if (sublist.equals(bigger)) {
                return true;
            }
            ++start;
        }
        return false;
    }

    public static <E> List<E> sort(Collection<E> c, Comparator<E> r) {
        ArrayList<E> list = new ArrayList<E>(c);
        Collections.sort(list, r);
        return list;
    }

    public static <K, V> void addToValueSet(Map<K, Set<V>> map, K key, V value) {
        CollectionUtils.addToValueSet(map, key, value, new SetFactory.HashSetFactory());
    }

    public static <K, V extends Comparable<V>> void addToValueSortedSet(Map<K, SortedSet<V>> map, K key, V value) {
        SortedSet<V> values = map.get(key);
        if (values == null) {
            values = new TreeSet<V>();
            map.put(key, values);
        }
        values.add(value);
    }

    public static <K, V> void addToValueSet(Map<K, Set<V>> map, K key, V value, SetFactory<V> mf) {
        Set<V> values = map.get(key);
        if (values == null) {
            values = mf.buildSet();
            map.put(key, values);
        }
        values.add(value);
    }

    public static <K, V, T> Map<V, T> addToValueMap(Map<K, Map<V, T>> map, K key, V value, T value2) {
        return CollectionUtils.addToValueMap(map, key, value, value2, new MapFactory.HashMapFactory());
    }

    public static <K, V, T> Map<V, T> addToValueMap(Map<K, Map<V, T>> map, K key, V value, T value2, MapFactory<V, T> mf) {
        Map<T, T> values = map.get(key);
        if (values == null) {
            values = mf.buildMap();
            map.put(key, values);
        }
        values.put(value, value2);
        return values;
    }

    public static <K, V> void addToValueList(Map<K, List<V>> map, K key, V value) {
        List<V> valueList = map.get(key);
        if (valueList == null) {
            valueList = new ArrayList<V>();
            map.put(key, valueList);
        }
        valueList.add(value);
    }

    public static <K, V> void addToValueCollection(Map<K, Collection<V>> map, K key, V value, CollectionFactory<V> cf) {
        Collection<V> valueList = map.get(key);
        if (valueList == null) {
            valueList = cf.newCollection();
            map.put(key, valueList);
        }
        valueList.add(value);
    }

    public static <K, V, C extends Collection<V>> void addToValueCollection(Map<K, C> map, K key, V value, Factory<C> fact) {
        Collection valueList = (Collection)map.get(key);
        if (valueList == null) {
            valueList = (Collection)fact.newInstance(new Object[0]);
            map.put(key, valueList);
        }
        valueList.add(value);
    }

    public static <K, V> List<V> getValueList(Map<K, List<V>> map, K key) {
        List<V> valueList = map.get(key);
        if (valueList == null) {
            return Collections.emptyList();
        }
        return valueList;
    }

    public static <K, V> Set<V> getValueSet(Map<K, Set<V>> map, K key) {
        Set<V> valueSet = map.get(key);
        if (valueSet == null) {
            return Collections.emptySet();
        }
        return valueSet;
    }

    public static <T> List<T> makeList(T ... args) {
        return new ArrayList<T>(Arrays.asList(args));
    }

    public static <T> Set<T> makeSet(T ... args) {
        return new HashSet<T>(Arrays.asList(args));
    }

    public static <T> void quicksort(T[] array, Comparator<? super T> c) {
        CollectionUtils.quicksort(array, 0, array.length - 1, c);
    }

    public static <T> void quicksort(T[] array, int left0, int right0, Comparator<? super T> c) {
        int left = left0;
        int right = right0 + 1;
        int pivotIndex = (left0 + right0) / 2;
        T pivot = array[pivotIndex];
        T temp = array[left0];
        array[left0] = pivot;
        array[pivotIndex] = temp;
        while (true) {
            if (++left <= right0 && c.compare(array[left], pivot) < 0) {
                continue;
            }
            while (c.compare(array[--right], pivot) > 0) {
            }
            if (left < right) {
                temp = array[left];
                array[left] = array[right];
                array[right] = temp;
            }
            if (left > right) break;
        }
        temp = array[left0];
        array[left0] = array[right];
        array[right] = temp;
        if (left0 < right) {
            CollectionUtils.quicksort(array, left0, right, c);
        }
        if (left < right0) {
            CollectionUtils.quicksort(array, left, right0, c);
        }
    }

    public static <S, T> Iterable<Pair<S, T>> getPairIterable(final Iterable<S> sIterable, final Iterable<T> tIterable) {
        return new Iterable<Pair<S, T>>(){

            @Override
            public Iterator<Pair<S, T>> iterator() {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class PairIterator
                implements Iterator<Pair<S, T>> {
                    private Iterator<S> sIterator;
                    private Iterator<T> tIterator;

                    PairIterator(Iterable iterable, Iterable iterable2) {
                        this.sIterator = iterable.iterator();
                        this.tIterator = iterable2.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.sIterator.hasNext() && this.tIterator.hasNext();
                    }

                    @Override
                    public Pair<S, T> next() {
                        return Pair.newPair(this.sIterator.next(), this.tIterator.next());
                    }

                    @Override
                    public void remove() {
                        this.sIterator.remove();
                        this.tIterator.remove();
                    }
                }
                return new PairIterator(sIterable, tIterable);
            }
        };
    }

    public static <T> List<T> doubletonList(T t1, T t2) {
        return new DoubletonList<T>(t1, t2);
    }

    private static boolean eq(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public static <K, V, V2> Map<V, V2> getOrCreateMap(Map<K, Map<V, V2>> map, K key) {
        Map<V, V2> r = map.get(key);
        if (r == null) {
            r = new HashMap<V, V2>();
            map.put(key, r);
        }
        return r;
    }

    public static Map getMapFromString(String s, Class keyClass, Class valueClass, MapFactory mapFactory) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Constructor keyC = keyClass.getConstructor(Class.forName("java.lang.String"));
        Constructor valueC = valueClass.getConstructor(Class.forName("java.lang.String"));
        if (s.charAt(0) != '{') {
            throw new RuntimeException("");
        }
        s = s.substring(1);
        String[] fields = s.split("\\s+");
        Map m = mapFactory.buildMap();
        int i = 0;
        while (i < fields.length) {
            fields[i] = fields[i].substring(0, fields[i].length() - 1);
            String[] a = fields[i].split("=");
            Object key = keyC.newInstance(a[0]);
            String value = a.length > 1 ? valueC.newInstance(a[1]) : "";
            m.put(key, value);
            ++i;
        }
        return m;
    }

    public static <T> List<T> concatenateLists(List<? extends T> ... lst) {
        ArrayList<? extends T> finalList = new ArrayList<T>();
        List<? extends T>[] listArray = lst;
        int n = lst.length;
        int n2 = 0;
        while (n2 < n) {
            List<? extends T> ts = listArray[n2];
            finalList.addAll(ts);
            ++n2;
        }
        return finalList;
    }

    public static <T> List<T> truncateList(List<T> lst, int maxTrainDocs) {
        if (maxTrainDocs < lst.size()) {
            return lst.subList(0, maxTrainDocs);
        }
        return lst;
    }

    public static <T> List<T> shuffle(Collection<T> items, Random rand) {
        ArrayList<T> shuffled = new ArrayList<T>(items);
        Collections.shuffle(shuffled, rand);
        return shuffled;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface CollectionFactory<V> {
        public Collection<V> newCollection();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DoubletonList<E>
    extends AbstractList<E>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = -8444118491195689776L;
        private final E element1;
        private final E element2;

        DoubletonList(E e1, E e2) {
            this.element1 = e1;
            this.element2 = e2;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public boolean contains(Object obj) {
            return CollectionUtils.eq(obj, this.element1) || CollectionUtils.eq(obj, this.element2);
        }

        @Override
        public E get(int index) {
            if (index == 0) {
                return this.element1;
            }
            if (index == 1) {
                return this.element2;
            }
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: 2");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MutableSingletonSet<E>
    extends AbstractSet<E>
    implements Serializable {
        private static final long serialVersionUID = 3193687207550431679L;
        private E element;
        private final MutableSingletonSetIterator iter;

        public MutableSingletonSet(E o) {
            this.element = o;
            this.iter = new MutableSingletonSetIterator();
        }

        public void set(E o) {
            this.element = o;
        }

        @Override
        public Iterator<E> iterator() {
            this.iter.reset();
            return this.iter;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean contains(Object o) {
            return CollectionUtils.eq(o, this.element);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class MutableSingletonSetIterator
        implements Iterator<E> {
            private boolean hasNext = true;

            private MutableSingletonSetIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public E next() {
                if (this.hasNext) {
                    this.hasNext = false;
                    return MutableSingletonSet.this.element;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void reset() {
                this.hasNext = true;
            }
        }
    }
}

