/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import edu.berkeley.nlp.util.MapFactory;
import edu.berkeley.nlp.util.PriorityQueueInterface;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralPriorityQueue<E>
implements PriorityQueueInterface<E>,
Serializable {
    private List<Entry<E>> indexToEntry = new ArrayList<Entry<E>>();
    private Map<E, Entry<E>> keyToEntry;

    @Override
    public boolean hasNext() {
        return this.size() > 0;
    }

    @Override
    public E next() {
        E removeFirst = this.removeFirst();
        return removeFirst;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public GeneralPriorityQueue<E> deepCopy() {
        GeneralPriorityQueue pq = new GeneralPriorityQueue();
        for (Entry<E> entry : this.indexToEntry) {
            pq.setPriority(entry.key, entry.priority);
        }
        return pq;
    }

    private Entry<E> parent(Entry<E> entry) {
        int index = entry.index;
        return index > 0 ? this.getEntry((index - 1) / 2) : null;
    }

    private Entry<E> leftChild(Entry<E> entry) {
        int leftIndex = entry.index * 2 + 1;
        return leftIndex < this.size() ? this.getEntry(leftIndex) : null;
    }

    private Entry<E> rightChild(Entry<E> entry) {
        int index = entry.index;
        int rightIndex = index * 2 + 2;
        return rightIndex < this.size() ? this.getEntry(rightIndex) : null;
    }

    private int compare(Entry<E> entryA, Entry<E> entryB) {
        return this.compare(entryA.priority, entryB.priority);
    }

    protected int compare(double a, double b) {
        double diff = a - b;
        if (diff > 0.0) {
            return 1;
        }
        if (diff < 0.0) {
            return -1;
        }
        return 0;
    }

    private void swap(Entry<E> entryA, Entry<E> entryB) {
        int indexB;
        int indexA = entryA.index;
        entryA.index = indexB = entryB.index;
        entryB.index = indexA;
        this.indexToEntry.set(indexA, entryB);
        this.indexToEntry.set(indexB, entryA);
    }

    private void removeLastEntry() {
        Entry<E> entry = this.indexToEntry.remove(this.size() - 1);
        this.keyToEntry.remove(entry.key);
    }

    protected Entry<E> getEntry(Object key) {
        Entry<E> entry = this.keyToEntry.get(key);
        return entry;
    }

    private Entry<E> getEntry(int index) {
        Entry<E> entry = this.indexToEntry.get(index);
        return entry;
    }

    protected Entry<E> makeEntry(E key) {
        Entry entry = new Entry();
        entry.index = this.size();
        entry.key = key;
        entry.priority = Double.NEGATIVE_INFINITY;
        this.indexToEntry.add(entry);
        this.keyToEntry.put(key, entry);
        return entry;
    }

    protected void heapifyUp(Entry<E> entry) {
        Entry<E> parentEntry;
        while (entry.index != 0 && this.compare(entry, parentEntry = this.parent(entry)) > 0) {
            this.swap(entry, parentEntry);
        }
    }

    private void heapifyDown(Entry<E> entry) {
        Entry<E> currentEntry = entry;
        Entry<E> bestEntry = null;
        do {
            Entry<E> rightEntry;
            bestEntry = currentEntry;
            Entry<E> leftEntry = this.leftChild(currentEntry);
            if (leftEntry != null && this.compare(bestEntry, leftEntry) < 0) {
                bestEntry = leftEntry;
            }
            if ((rightEntry = this.rightChild(currentEntry)) != null && this.compare(bestEntry, rightEntry) < 0) {
                bestEntry = rightEntry;
            }
            if (bestEntry == currentEntry) continue;
            this.swap(bestEntry, currentEntry);
        } while (bestEntry != currentEntry);
    }

    private void heapify(Entry<E> entry) {
        this.heapifyUp(entry);
        this.heapifyDown(entry);
    }

    public E removeFirst() {
        E first = this.getFirst();
        this.removeKey(first);
        return first;
    }

    public E getFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.getEntry((int)0).key;
    }

    public E getObject(E key) {
        if (!this.containsKey(key)) {
            return null;
        }
        Entry<E> e = this.getEntry(key);
        return e.key;
    }

    public double getPriority(E key) {
        Entry<E> entry = this.getEntry(key);
        if (entry == null) {
            return Double.NEGATIVE_INFINITY;
        }
        return entry.priority;
    }

    public double removeKey(E key) {
        Entry<E> entry = this.getEntry(key);
        if (entry == null) {
            return Double.NEGATIVE_INFINITY;
        }
        this.removeEntry(entry);
        return entry.priority;
    }

    private void removeEntry(Entry<E> entry) {
        Entry<E> lastEntry = this.getLastEntry();
        if (entry != lastEntry) {
            this.swap(entry, lastEntry);
            this.removeLastEntry();
            this.heapify(lastEntry);
        } else {
            this.removeLastEntry();
        }
    }

    private Entry<E> getLastEntry() {
        return this.getEntry(this.size() - 1);
    }

    public boolean relaxPriority(E key, double priority) {
        Entry<E> entry = this.getEntry(key);
        if (entry == null) {
            entry = this.makeEntry(key);
        }
        if (this.compare(priority, entry.priority) <= 0) {
            return false;
        }
        entry.priority = priority;
        this.heapifyUp(entry);
        return true;
    }

    public boolean decreasePriority(E key, double priority) {
        Entry<E> entry = this.getEntry(key);
        if (entry == null) {
            entry = this.makeEntry(key);
        }
        if (this.compare(priority, entry.priority) >= 0) {
            return false;
        }
        entry.priority = priority;
        this.heapifyDown(entry);
        return true;
    }

    public void setPriority(E key, double priority) {
        Entry<E> entry = this.getEntry(key);
        if (entry == null) {
            entry = this.makeEntry(key);
        } else if (entry.key != key) {
            entry.key = key;
            this.keyToEntry.put(key, entry);
        }
        if (this.compare(priority, entry.priority) == 0) {
            return;
        }
        entry.priority = priority;
        this.heapify(entry);
    }

    private boolean isValid(Entry<E> entry) {
        int count = 0;
        int i = 0;
        while (i < this.indexToEntry.size()) {
            if (this.indexToEntry.get((int)i).key == entry.key) {
                ++count;
            }
            ++i;
        }
        assert (count == 1);
        return count == 1;
    }

    @Override
    public boolean isEmpty() {
        return this.indexToEntry.isEmpty();
    }

    @Override
    public int size() {
        return this.indexToEntry.size();
    }

    public List<E> toSortedList() {
        ArrayList<E> sortedList = new ArrayList<E>(this.size());
        GeneralPriorityQueue<E> queue = this.deepCopy();
        while (queue.hasNext()) {
            sortedList.add(queue.next());
        }
        return sortedList;
    }

    public Iterator<E> iterator() {
        return Collections.unmodifiableCollection(this.toSortedList()).iterator();
    }

    public void clear() {
        this.indexToEntry.clear();
        this.keyToEntry.clear();
    }

    public String toString() {
        List<E> sortedKeys = this.toSortedList();
        StringBuffer sb = new StringBuffer("[");
        Iterator<E> keyI = sortedKeys.iterator();
        while (keyI.hasNext()) {
            E key = keyI.next();
            sb.append(key);
            sb.append("=");
            sb.append(this.getPriority(key));
            if (!keyI.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public String toVerticalString() {
        List<E> sortedKeys = this.toSortedList();
        StringBuffer sb = new StringBuffer();
        Iterator<E> keyI = sortedKeys.iterator();
        while (keyI.hasNext()) {
            E key = keyI.next();
            sb.append(key);
            sb.append(" : ");
            sb.append(this.getPriority(key));
            if (!keyI.hasNext()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public double getPriority() {
        return this.getPriority(this.getFirst());
    }

    public boolean containsKey(E e) {
        return this.keyToEntry.containsKey(e);
    }

    public String toString(int maxKeysToPrint) {
        GeneralPriorityQueue<E> pq = this.deepCopy();
        StringBuilder sb = new StringBuilder("[");
        int numKeysPrinted = 0;
        while (numKeysPrinted < maxKeysToPrint && !pq.isEmpty()) {
            double priority = pq.getPriority();
            E element = pq.removeFirst();
            sb.append(element.toString());
            sb.append(" : ");
            sb.append(priority);
            if (numKeysPrinted < this.size() - 1) {
                sb.append(", ");
            }
            ++numKeysPrinted;
        }
        if (numKeysPrinted < this.size()) {
            sb.append("...");
        }
        sb.append("]");
        return sb.toString();
    }

    public GeneralPriorityQueue() {
        this(new MapFactory.HashMapFactory());
    }

    public GeneralPriorityQueue(MapFactory<E, Entry<E>> mapFactory) {
        this.keyToEntry = mapFactory.buildMap();
    }

    public static void main(String[] args) {
        GeneralPriorityQueue<String> queue = new GeneralPriorityQueue<String>();
        queue.setPriority("a", 1.0);
        System.out.println("Added a:1 " + queue);
        queue.setPriority("b", 2.0);
        System.out.println("Added b:2 " + queue);
        queue.setPriority("c", 1.5);
        System.out.println("Added c:1.5 " + queue);
        queue.setPriority("a", 3.0);
        System.out.println("Increased a to 3 " + queue);
        queue.setPriority("b", 0.0);
        System.out.println("Decreased b to 0 " + queue);
        System.out.println("removeFirst()=" + (String)queue.next());
        System.out.println("queue=" + queue);
        System.out.println("removeFirst()=" + (String)queue.next());
        System.out.println("queue=" + queue);
        System.out.println("removeFirst()=" + (String)queue.next());
        System.out.println("queue=" + queue);
    }

    @Override
    public void put(E key, double priority) {
        this.setPriority(key, priority);
    }

    @Override
    public E peek() {
        return this.getFirst();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Entry<E>
    implements Serializable {
        public E key;
        public int index;
        public double priority;

        public String toString() {
            return this.key + " at " + this.index + " (" + this.priority + ")";
        }
    }
}

