/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import edu.berkeley.nlp.util.IOUtils;
import edu.berkeley.nlp.util.Logger;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectWriter<T extends Serializable> {
    private final File folder;
    private final String baseFilename;
    private final int objectsPerFile;
    private final boolean overwrite;
    private int forestsWritten = 0;
    private ObjectOutputStream currentOutputStream = null;

    public ObjectWriter(File folder, String baseFilename, int objectsPerFile, boolean overwrite) {
        this.folder = folder;
        this.baseFilename = baseFilename;
        this.objectsPerFile = objectsPerFile;
        this.overwrite = overwrite;
        if (folder.exists() && !folder.isDirectory()) {
            if (overwrite) {
                if (!folder.delete()) {
                    throw new IllegalArgumentException("Cannot remove file: " + folder);
                }
            } else {
                throw new IllegalArgumentException("File already exists: " + folder);
            }
        }
        if (!folder.exists() && !folder.mkdir()) {
            throw new IllegalArgumentException("Cannot create directory: " + folder);
        }
    }

    public void writeObject(T object) {
        try {
            if (this.currentOutputStream == null) {
                this.openOutputStream();
            }
            this.currentOutputStream.writeBoolean(true);
            this.currentOutputStream.writeObject(object);
            ++this.forestsWritten;
            if (this.forestsWritten % this.objectsPerFile == 0) {
                this.closeOutputStream();
            }
        }
        catch (IOException e) {
            Logger.err("Error writing forest: " + e);
        }
    }

    private void openOutputStream() throws IOException {
        int fileIndex = this.forestsWritten / this.objectsPerFile;
        File outputFile = new File(this.folder, this.baseFilename.replace(".", String.valueOf(this.pad(fileIndex, 4)) + "."));
        if (outputFile.exists()) {
            if (this.overwrite) {
                if (!outputFile.delete()) {
                    throw new IOException("Cannot delete file: " + outputFile);
                }
            } else {
                throw new IOException("File already exists: " + outputFile);
            }
        }
        this.currentOutputStream = IOUtils.openObjOut(outputFile);
    }

    private String pad(int val, int length) {
        String s = new Integer(val).toString();
        int i = s.length();
        while (i < length) {
            s = "0" + s;
            ++i;
        }
        return s;
    }

    public void closeOutputStream() {
        if (this.currentOutputStream == null) {
            return;
        }
        try {
            this.currentOutputStream.writeBoolean(false);
            this.currentOutputStream.close();
            this.currentOutputStream = null;
        }
        catch (IOException e) {
            Logger.err("Error closing output stream: " + e);
        }
    }
}

