/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import java.util.Arrays;

public class Scaler {
    final int MAX_LEN;
    int[] scales;
    double[] unscaled;
    int index;
    final double SCALE;
    double sumUnscaled;
    int sumScale;

    public Scaler(double scale, int maxLen) {
        this.SCALE = scale;
        this.MAX_LEN = maxLen;
        this.scales = new int[this.MAX_LEN];
        this.unscaled = new double[this.MAX_LEN];
        this.clear();
    }

    public Scaler() {
        this(Math.exp(200.0), 400);
        this.clear();
    }

    public void add(double score, int scale) {
        assert (score >= 0.0) : "Invald score: " + score;
        this.unscaled[this.index] = score;
        this.scales[this.index] = scale;
        ++this.index;
    }

    public void clear() {
        this.index = 0;
        Arrays.fill(this.unscaled, 0.0);
        Arrays.fill(this.scales, 0);
    }

    private double getScale(int logScale) {
        if ((double)logScale == 0.0) {
            return 1.0;
        }
        if ((double)logScale == 1.0) {
            return this.SCALE;
        }
        if ((double)logScale == 2.0) {
            return this.SCALE * this.SCALE;
        }
        if ((double)logScale == 3.0) {
            return this.SCALE * this.SCALE * this.SCALE;
        }
        if ((double)logScale == -1.0) {
            return 1.0 / this.SCALE;
        }
        if ((double)logScale == -2.0) {
            return 1.0 / this.SCALE / this.SCALE;
        }
        if ((double)logScale == -3.0) {
            return 1.0 / this.SCALE / this.SCALE / this.SCALE;
        }
        return Math.pow(this.SCALE, logScale);
    }

    public void scale() {
        this.sumScale = Integer.MIN_VALUE;
        int[] nArray = this.scales;
        int n = this.scales.length;
        int n2 = 0;
        while (n2 < n) {
            int scale = nArray[n2];
            this.sumScale = Math.max(this.sumScale, scale);
            ++n2;
        }
        assert (this.sumScale > Integer.MIN_VALUE);
        this.sumUnscaled = 0.0;
        int i = 0;
        while (i < this.index) {
            double scale = this.getScale(this.scales[i] - this.sumScale);
            this.sumUnscaled += scale * this.unscaled[i];
            ++i;
        }
        while (this.sumUnscaled != 0.0) {
            if (this.sumUnscaled > this.SCALE) {
                this.sumUnscaled /= this.SCALE;
                ++this.sumScale;
                continue;
            }
            if (!(this.sumUnscaled < 1.0 / this.SCALE)) break;
            this.sumUnscaled *= this.SCALE;
            --this.sumScale;
        }
    }

    public double getScaleFactor() {
        return this.SCALE;
    }

    public int getLogScale() {
        return (int)Math.log(this.SCALE);
    }

    public double getSumUnscaled() {
        return this.sumUnscaled;
    }

    public int getSumScale() {
        return this.sumScale;
    }

    public double getSumScaled() {
        return this.getScale(this.getSumScale()) * this.getSumUnscaled();
    }

    public double getScaled(double unscaled, int scale) {
        return unscaled * this.getScale(scale);
    }
}

