/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import edu.berkeley.nlp.util.CollectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmartMapUtils {
    public static <K, O> Map<K, List<O>> groupBy(Iterable<O> objs, String field) throws Exception {
        Class<?> c = objs.iterator().next().getClass();
        Method[] methods = c.getDeclaredMethods();
        String trgMethName = "get" + field;
        Method trgMeth = null;
        Field trgField = null;
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().equalsIgnoreCase(trgMethName)) {
                trgMeth = m;
                break;
            }
            ++n2;
        }
        if (trgMeth == null) {
            Field[] fields;
            Field[] fieldArray = fields = c.getDeclaredFields();
            int n3 = fields.length;
            n = 0;
            while (n < n3) {
                Field f = fieldArray[n];
                if (f.getName().equalsIgnoreCase(field)) {
                    trgField = f;
                    break;
                }
                ++n;
            }
        }
        if (trgMeth == null && trgField == null) {
            throw new RuntimeException("Couldn't find field or method to access " + field);
        }
        HashMap map = new HashMap();
        for (O obj : objs) {
            Object key = null;
            try {
                key = trgMeth != null ? trgMeth.invoke(obj, new Object[0]) : trgField.get(obj);
            }
            catch (Exception e) {
                throw new RuntimeException();
            }
            CollectionUtils.addToValueList(map, key, obj);
        }
        return map;
    }

    public static void main(String[] args) throws Exception {
        List<Person> objs = CollectionUtils.makeList(new Person("david"), new Person("davs"), new Person("maria"), new Person("marshia"));
        Map grouped = SmartMapUtils.groupBy(objs, "prefix");
        System.out.printf("groupd: %s", grouped);
    }

    private static class Person {
        public String prefix;
        public String name;

        public Person(String name) {
            this.name = name;
            this.prefix = name.substring(0, 3);
        }

        public String toString() {
            return "Person(" + this.name + ")";
        }
    }
}

