/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import edu.berkeley.nlp.util.Indexer;
import java.io.Serializable;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseDoubleArray
implements Serializable {
    private static final long serialVersionUID = 42L;
    double[] data = new double[0];
    int[] indices = new int[0];
    int length = 0;

    private void grow() {
        int curSize = this.data.length;
        int newSize = curSize + 10;
        double[] newData = new double[newSize];
        System.arraycopy(this.data, 0, newData, 0, curSize);
        this.data = newData;
        int[] newIndices = new int[newSize];
        System.arraycopy(this.indices, 0, newIndices, 0, curSize);
        int i = curSize;
        while (i < newIndices.length) {
            newIndices[i] = Integer.MAX_VALUE;
            newData[i] = Double.POSITIVE_INFINITY;
            ++i;
        }
        this.indices = newIndices;
    }

    public double getCount(int index) {
        int res = Arrays.binarySearch(this.indices, index);
        if (res >= 0 && res < this.length) {
            return this.data[res];
        }
        return 0.0;
    }

    public void incrementCount(int index0, double x0) {
        double curCount = this.getCount(index0);
        this.setCount(index0, curCount + x0);
    }

    public int size() {
        return this.length;
    }

    public void setCount(int index0, double x) {
        int res = Arrays.binarySearch(this.indices, index0);
        if (res >= 0 && res < this.length) {
            this.data[res] = x;
            return;
        }
        if (this.length + 1 >= this.data.length) {
            this.grow();
        }
        int insertionPoint = -(res + 1);
        assert (insertionPoint >= 0 && insertionPoint <= this.length) : String.format("length: %d insertion: %d", this.length, insertionPoint);
        System.arraycopy(this.data, insertionPoint, this.data, insertionPoint + 1, this.length - insertionPoint);
        System.arraycopy(this.indices, insertionPoint, this.indices, insertionPoint + 1, this.length - insertionPoint);
        this.indices[insertionPoint] = index0;
        this.data[insertionPoint] = x;
        ++this.length;
    }

    public int getActiveDimension(int i) {
        assert (i < this.length);
        return this.indices[i];
    }

    public double getActiveCount(int i) {
        assert (i < this.length);
        return this.data[i];
    }

    public double l2Norm() {
        double sum = 0.0;
        int i = 0;
        while (i < this.length) {
            sum += this.data[i] * this.data[i];
            ++i;
        }
        return Math.sqrt(sum);
    }

    public void scale(double c) {
        int i = 0;
        while (i < this.length) {
            int n = i++;
            this.data[n] = this.data[n] * c;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{ ");
        int i = 0;
        while (i < this.length) {
            builder.append(String.format("%d : %.5f", this.indices[i], this.data[i]));
            builder.append(" ");
            ++i;
        }
        builder.append(" }");
        return builder.toString();
    }

    public String toString(Indexer<?> indexer) {
        StringBuilder builder = new StringBuilder();
        builder.append("{ ");
        int i = 0;
        while (i < this.length) {
            builder.append(String.format("%s : %.5f", indexer.getObject(this.indices[i]), this.data[i]));
            builder.append(" ");
            ++i;
        }
        builder.append(" }");
        return builder.toString();
    }

    public double dotProduct(SparseDoubleArray other) {
        double sum = 0.0;
        int i = 0;
        while (i < this.length) {
            int dim = this.indices[i];
            sum += this.data[i] * other.getCount(dim);
            ++i;
        }
        return sum;
    }

    public static void main(String[] args) {
        SparseDoubleArray sv = new SparseDoubleArray();
        sv.setCount(0, 1.0);
        sv.setCount(1, 2.0);
        sv.incrementCount(1, 1.0);
        sv.incrementCount(-1, 10.0);
        System.out.println(sv);
    }
}

