/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrUtils {
    public static String[] split(String s) {
        return StrUtils.split(s, " ");
    }

    public static String[] split(String s, String delim) {
        return StrUtils.isEmpty(s) ? new String[]{} : s.split(delim);
    }

    public static List<String> splitByStr(String s, String delim) {
        if (StrUtils.isEmpty(s)) {
            return Collections.emptyList();
        }
        ArrayList<String> tokens = new ArrayList<String>();
        int i = 0;
        while (i < s.length()) {
            int j = s.indexOf(delim, i);
            if (j == -1) break;
            tokens.add(s.substring(i, j));
            i = j + delim.length();
        }
        tokens.add(s.substring(i));
        return tokens;
    }

    public static int indexOfIgnoreEscaped(String s, char c) {
        return StrUtils.indexOfIgnoreEscaped(s, c, 0);
    }

    public static int indexOfIgnoreEscaped(String s, char c, int i) {
        return StrUtils.indexOfIgnoreEscaped(s, "" + c, i);
    }

    public static int indexOfIgnoreEscaped(String s, String cs, int i) {
        boolean escape = false;
        while (i < s.length()) {
            if (escape) {
                escape = false;
            } else if (s.charAt(i) == '\\') {
                escape = true;
            } else if (cs.indexOf(s.charAt(i)) != -1) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static List<String> splitIgnoreEscaped(String line, String delim) {
        String[] tokens = StrUtils.split(line, delim);
        ArrayList<String> newTokens = new ArrayList<String>();
        int i = 0;
        while (i < tokens.length) {
            if (tokens[i].endsWith("\\") && i + 1 < tokens.length) {
                tokens[i + 1] = String.valueOf(tokens[i].substring(0, tokens[i].length() - 1)) + "\\" + delim + tokens[i + 1];
            } else {
                newTokens.add(tokens[i]);
            }
            ++i;
        }
        return newTokens;
    }

    public static double[] doubleSplit(String s, String delim) {
        String[] tokens = StrUtils.split(s, delim);
        double[] data = new double[tokens.length];
        int i = 0;
        while (i < tokens.length) {
            data[i] = Double.parseDouble(tokens[i]);
            ++i;
        }
        return data;
    }

    public static double[] doubleSplit(String s) {
        return StrUtils.doubleSplit(s, " ");
    }

    public static int[] intSplit(String s, String delim) {
        String[] tokens = StrUtils.split(s, delim);
        int[] data = new int[tokens.length];
        int i = 0;
        while (i < tokens.length) {
            data[i] = Integer.parseInt(tokens[i]);
            ++i;
        }
        return data;
    }

    public static int[] intSplit(String s) {
        return StrUtils.intSplit(s, " ");
    }

    public static short[] shortSplit(String s, String delim) {
        String[] tokens = StrUtils.split(s, delim);
        short[] data = new short[tokens.length];
        int i = 0;
        while (i < tokens.length) {
            data[i] = Short.parseShort(tokens[i]);
            ++i;
        }
        return data;
    }

    public static short[] shortSplit(String s) {
        return StrUtils.shortSplit(s, " ");
    }

    public static List<Integer> intSplitList(String s, String delim) {
        String[] tokens = StrUtils.split(s, delim);
        ArrayList<Integer> data = new ArrayList<Integer>(tokens.length);
        int i = 0;
        while (i < tokens.length) {
            data.add(Integer.parseInt(tokens[i]));
            ++i;
        }
        return data;
    }

    public static List<Integer> intSplitList(String s) {
        return StrUtils.intSplitList(s, " ");
    }

    public static Map<String, String> parseHashMap(String line, String keyValueDelim) {
        return StrUtils.parseHashMap(line, keyValueDelim, " ");
    }

    public static Map<String, String> parseHashMap(String line, String keyValueDelim, String entryDelim) {
        return StrUtils.parseHashMap(Arrays.asList(StrUtils.split(line, entryDelim)), keyValueDelim);
    }

    public static Map<String, String> parseHashMap(List<String> tokens, String keyValueDelim) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String token : tokens) {
            String[] kv = token.split(keyValueDelim);
            if (kv.length != 2) continue;
            map.put(kv[0], kv[1]);
        }
        return map;
    }

    public static <T> String join(double[] list) {
        return StrUtils.join(list, " ");
    }

    public static <T> String join(double[] list, String delim) {
        if (list == null) {
            return "";
        }
        ArrayList<Double> objs = new ArrayList<Double>();
        double[] dArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            double x = dArray[n2];
            objs.add(x);
            ++n2;
        }
        return StrUtils.join(objs, delim);
    }

    public static String join(int[] list) {
        return StrUtils.join(list, " ");
    }

    public static String join(int[] list, String delim) {
        if (list == null) {
            return "";
        }
        ArrayList<Integer> objs = new ArrayList<Integer>();
        int[] nArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            int x = nArray[n2];
            objs.add(x);
            ++n2;
        }
        return StrUtils.join(objs, delim);
    }

    public static String join(boolean[] list) {
        return StrUtils.join(list, " ");
    }

    public static String join(boolean[] list, String delim) {
        if (list == null) {
            return "";
        }
        ArrayList<Boolean> objs = new ArrayList<Boolean>();
        boolean[] blArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            boolean x = blArray[n2];
            objs.add(x);
            ++n2;
        }
        return StrUtils.join(objs, delim);
    }

    public static <T> String join(T[] objs) {
        if (objs == null) {
            return "";
        }
        return StrUtils.join(Arrays.asList(objs), " ");
    }

    public static <T> String join(T[] objs, int start, int end) {
        if (objs == null) {
            return "";
        }
        return StrUtils.join(Arrays.asList(objs), " ", start, end);
    }

    public static <T> String join(List<T> objs) {
        return StrUtils.join(objs, " ");
    }

    public static <T> String join(T[] objs, String delim) {
        if (objs == null) {
            return "";
        }
        return StrUtils.join(Arrays.asList(objs), delim);
    }

    public static <T> String join(List<T> objs, String delim) {
        if (objs == null) {
            return "";
        }
        return StrUtils.join(objs, delim, 0, objs.size());
    }

    public static <T> String join(List<T> objs, String delim, int start, int end) {
        if (objs == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        int i = start;
        while (i < end) {
            if (!first) {
                sb.append(delim);
            }
            sb.append(objs.get(i));
            first = false;
            ++i;
        }
        return sb.toString();
    }

    public static <T> String join(Collection<T> objs, String delim) {
        if (objs == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (T x : objs) {
            if (!first) {
                sb.append(delim);
            }
            sb.append(x);
            first = false;
        }
        return sb.toString();
    }

    public static String join(int[] x, boolean withIndices, int magnitudeThreshold) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < x.length) {
            if (Math.abs(x[i]) >= magnitudeThreshold) {
                if (i > 0) {
                    sb.append(' ');
                }
                if (withIndices) {
                    sb.append(String.valueOf(i) + ":");
                }
                sb.append(x[i]);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String joinWithIndices(int[] x) {
        return StrUtils.join(x, true, 0);
    }

    public static String join(double[] x, boolean withIndices, double magnitudeThreshold) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < x.length) {
            if (!(Math.abs(x[i]) < magnitudeThreshold)) {
                if (i > 0) {
                    sb.append(' ');
                }
                if (withIndices) {
                    sb.append(String.valueOf(i) + ":");
                }
                sb.append(x[i]);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String joinWithIndices(double[] x) {
        return StrUtils.join(x, true, 0.0);
    }

    public static <T> String join(T[][] data, String[] rowNames, String[] colNames) {
        int r;
        int c;
        int r0 = colNames == null ? 0 : 1;
        int c0 = rowNames == null ? 0 : 1;
        int R = data.length;
        int C = data[0].length;
        String[][] mat = new String[R + r0][C + r0];
        int r2 = 0;
        while (r2 < R) {
            c = 0;
            while (c < C) {
                mat[r2 + r0][c + c0] = "" + data[r2][c];
                ++c;
            }
            ++r2;
        }
        if (rowNames != null) {
            r2 = 0;
            while (r2 < R) {
                mat[r2 + r0][0] = rowNames[r2];
                ++r2;
            }
        }
        if (colNames != null) {
            int c2 = 0;
            while (c2 < C) {
                mat[0][c2 + c0] = colNames[c2];
                ++c2;
            }
        }
        int[] widths = new int[C + c0];
        c = 0;
        while (c < C + c0) {
            r = 0;
            while (r < R + r0) {
                if (mat[r][c] == null) {
                    mat[r][c] = "";
                }
                widths[c] = Math.max(widths[c], mat[r][c].length());
                ++r;
            }
            ++c;
        }
        StringBuilder buf = new StringBuilder();
        r = 0;
        while (r < R + r0) {
            int c3 = 0;
            while (c3 < C + c0) {
                String fmt = "%-" + (widths[c3] + 1) + "s";
                buf.append(String.format(fmt, mat[r][c3]));
                ++c3;
            }
            buf.append("\n");
            ++r;
        }
        return buf.toString();
    }

    public static String toString(Object o) {
        return o == null ? null : o.toString();
    }

    public static boolean isEmpty(String s) {
        return s == null || s.equals("");
    }

    public static String repeat(String s, int n) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < n) {
            sb.append(s);
            ++i;
        }
        return sb.toString();
    }

    public static Matcher match(String pattern, String s) {
        return Pattern.compile(pattern).matcher(s);
    }

    public static String[] format(String fmt, Object ... is) {
        int n = Array.getLength(is[0]);
        String[] out = new String[n];
        int i = 0;
        while (i < n) {
            Object[] args = new Object[is.length];
            int j = 0;
            while (j < is.length) {
                args[j] = Array.get(is[j], i);
                ++j;
            }
            out[i] = String.format(fmt, args);
            ++i;
        }
        return out;
    }
}

