/*
 * Decompiled with CFR 0.152.
 */
package kaist.cilab.jhannanum.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONReader {
    private String filePath = null;
    JSONObject json = null;

    public static void main(String[] args) {
        try {
            File dir = new File("conf");
            String[] files = dir.list();
            int i = 0;
            while (i < files.length) {
                JSONReader reader = new JSONReader("conf/" + files[i]);
                System.out.println(reader.getName());
                System.out.println(reader.getVersion());
                System.out.println(reader.getAuthor());
                System.out.println(reader.getDescription());
                System.out.println(reader.getType());
                ++i;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public JSONReader(String filePath) throws JSONException, IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF-8"));
        StringBuffer buf = new StringBuffer();
        char[] cbuf = new char[4096];
        int idx = 0;
        while ((idx = in.read(cbuf)) != -1) {
            buf.append(cbuf, 0, idx);
        }
        this.json = new JSONObject(buf.toString());
        in.close();
    }

    public String getName() throws JSONException {
        return this.json.getString("name");
    }

    public String getVersion() throws JSONException {
        return this.json.getString("version");
    }

    public String getAuthor() throws JSONException {
        String res = "";
        JSONArray array = this.json.getJSONArray("author");
        JSONObject obj = null;
        int i = 0;
        while (i < array.length()) {
            if (i > 0) {
                res = String.valueOf(res) + ", ";
            }
            res = !(obj = array.getJSONObject(i)).getString("email").equals("null") ? String.valueOf(res) + obj.getString("name") + "<" + obj.getString("email") + ">" : String.valueOf(res) + obj.getString("name");
            ++i;
        }
        return res;
    }

    public String getDescription() throws JSONException {
        return this.json.getString("description");
    }

    public String getType() throws JSONException {
        return this.json.getString("type");
    }

    public String getValue(String key) throws JSONException {
        return this.json.getString(key);
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }
}

