/*
 * Decompiled with CFR 0.152.
 */
package kaist.cilab.jhannanum.morphanalyzer.chartmorphanalyzer;

import java.util.ArrayList;
import kaist.cilab.jhannanum.common.Code;
import kaist.cilab.jhannanum.common.Eojeol;
import kaist.cilab.jhannanum.common.communication.SetOfSentences;

public class PostProcessor {
    private String HA = Code.toTripleString("\ud558");
    private String AR = Code.toTripleString("\uc544");
    private String A_ = Code.toTripleString("\uc5b4");
    private String PV = Code.toTripleString("\u314f\u3151\u3157");
    private String XEU = Code.toTripleString("\ub044\ub728\uc4f0\ud06c\ud2b8");
    private String DOB = Code.toTripleString("\ub3d5");
    private String GOB = Code.toTripleString("\uacf1");
    private String EU = Code.toTripleString("\uc73c");
    private String SU = Code.toTripleString("\uc2b5\ub2c8");
    private String NU = Code.toTripleString("\ub294\ub2e4");

    public SetOfSentences doPostProcessing(SetOfSentences sos) {
        ArrayList<Eojeol[]> eojeolSetArray = sos.getEojeolSetArray();
        for (Eojeol[] eojeolSet : eojeolSetArray) {
            String prevMorph = "";
            int i = 0;
            while (i < eojeolSet.length) {
                Eojeol eojeol = eojeolSet[i];
                String[] morphemes = eojeol.getMorphemes();
                String[] tags = eojeol.getTags();
                int j = 0;
                while (j < eojeol.length) {
                    String tri = Code.toTripleString(morphemes[j]);
                    if (tags[j].startsWith("e")) {
                        int prevLen = prevMorph.length();
                        if (tri.startsWith(this.A_)) {
                            if (prevLen >= 4 && prevMorph.charAt(prevLen - 1) == this.EU.charAt(1) && !this.isXEU(prevMorph.charAt(prevLen - 2)) && (Code.isJungseong(prevMorph.charAt(prevLen - 3)) && this.isPV(prevMorph.charAt(prevLen - 3)) || Code.isJongseong(prevMorph.charAt(prevLen - 3)) && this.isPV(prevMorph.charAt(prevLen - 4)))) {
                                morphemes[j] = Code.toString(this.AR.toCharArray());
                            } else if ((prevLen < 3 || prevMorph.charAt(prevLen - 1) != this.DOB.charAt(2) || prevMorph.substring(prevLen - 3).equals(this.DOB) && prevMorph.substring(prevLen - 3).equals(this.GOB)) && (prevLen < 2 || !prevMorph.substring(prevLen - 2).equals(this.HA)) && prevLen >= 2 && (Code.isJungseong(prevMorph.charAt(prevLen - 1)) && this.isPV(prevMorph.charAt(prevLen - 1)) || Code.isJongseong(prevMorph.charAt(prevLen - 1)) && this.isPV(prevMorph.charAt(prevLen - 2)))) {
                                morphemes[j] = Code.toString(this.AR.toCharArray());
                            }
                        } else if ((tri.startsWith(this.EU.substring(0, 2)) || tri.startsWith(this.SU.substring(0, 4)) || tri.startsWith(this.NU.substring(0, 4))) && prevLen >= 2 && (Code.isJungseong(prevMorph.charAt(prevLen - 1)) || prevMorph.charAt(prevLen - 1) == '\u11af')) {
                            morphemes[j] = Code.toString(tri.substring(2).toCharArray());
                        }
                    }
                    prevMorph = Code.toTripleString(morphemes[j]);
                    ++j;
                }
                ++i;
            }
        }
        return sos;
    }

    private boolean isPV(char c) {
        return this.PV.indexOf(c) != -1;
    }

    private boolean isXEU(char c) {
        return this.XEU.indexOf(c) != -1;
    }
}

