/*
 * Decompiled with CFR 0.152.
 */
package kaist.cilab.jhannanum.morphanalyzer.chartmorphanalyzer.datastructure;

import kaist.cilab.jhannanum.common.Code;
import kaist.cilab.jhannanum.morphanalyzer.chartmorphanalyzer.Simti;

public class SegmentPosition {
    public static final int MAX_SEGMENT = 1024;
    public static final int MAX_MORPHEME_COUNT = 512;
    public static final int SP_STATE_N = 0;
    public static final int SP_STATE_D = 1;
    public static final int SP_STATE_R = 2;
    public static final int SP_STATE_M = 3;
    public static final int SP_STATE_F = 4;
    public static final char POSITION_START_KEY = '\u0000';
    private Position[] position = new Position[1024];
    private int positionEnd = 0;

    public SegmentPosition() {
        int i = 0;
        while (i < 1024) {
            this.position[i] = new Position();
            ++i;
        }
    }

    public int addPosition(char key) {
        this.position[this.positionEnd].key = key;
        this.position[this.positionEnd].state = 0;
        this.position[this.positionEnd].morphCount = 0;
        this.position[this.positionEnd].nextPosition = 0;
        this.position[this.positionEnd].sIndex = 0;
        this.position[this.positionEnd].uIndex = 0;
        this.position[this.positionEnd].nIndex = 0;
        return this.positionEnd++;
    }

    public Position getPosition(int index) {
        return this.position[index];
    }

    public void init(String str, Simti simti) {
        int prevIndex = 0;
        int nextIndex = 0;
        this.positionEnd = 0;
        prevIndex = this.addPosition('\u0000');
        this.position[prevIndex].state = 3;
        String rev = "";
        int i = str.length() - 1;
        while (i >= 0) {
            rev = String.valueOf(rev) + str.charAt(i);
            --i;
        }
        i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            nextIndex = this.addPosition(c);
            this.setPositionLink(prevIndex, nextIndex);
            prevIndex = nextIndex;
            simti.insert(rev.substring(0, str.length() - i).toCharArray(), nextIndex);
            ++i;
        }
        this.setPositionLink(prevIndex, 0);
    }

    public int nextPosition(int index) {
        return this.position[index].nextPosition;
    }

    public void printPosition() {
        System.err.println("positionEnd: " + this.positionEnd);
        int i = 0;
        while (i < this.positionEnd) {
            System.err.format("position[%d].key=%c nextPosition=%d\n", i, Character.valueOf(Code.toCompatibilityJamo(this.position[i].key)), this.position[i].nextPosition);
            ++i;
        }
    }

    public int setPositionLink(int prevIndex, int nextIndex) {
        this.position[prevIndex].nextPosition = nextIndex;
        return prevIndex;
    }

    public class Position {
        public char key;
        public int state;
        public int nextPosition;
        public int sIndex;
        public int uIndex;
        public int nIndex;
        public int morphCount;
        public int[] morpheme = new int[512];
    }
}

