/*
 * Decompiled with CFR 0.152.
 */
package kaist.cilab.jhannanum.morphanalyzer.chartmorphanalyzer.datastructure;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.StringTokenizer;
import kaist.cilab.jhannanum.common.Code;
import kaist.cilab.jhannanum.morphanalyzer.chartmorphanalyzer.datastructure.TagSet;

public class Trie {
    private static String encoding = "UTF-8";
    public static final String TRIE_VERSION = "TRIE v0.1 (c) wjlee in KAIST\n";
    public static final int DEFAULT_TRIE_BUF_SIZE_SYS = 1060000;
    public static final int DEFAULT_TRIE_BUF_SIZE_USER = 106000;
    public static final int FREE_NODE = 0;
    public static final int START_NODE = 1;
    public int search_end = 0;
    public int[] search_idx = new int[256];
    public char[] search_key = new char[256];
    public TNODE[] trie_buf = null;
    public FREE free_head = null;
    public TNODE node_head = null;

    public Trie(int buf_size) {
        this.search_idx = new int[256];
        this.search_key = new char[256];
        this.trie_buf = new TNODE[buf_size];
        int i = 0;
        while (i < buf_size) {
            this.trie_buf[i] = new TNODE();
            ++i;
        }
        this.free_head = this.trie_buf[0].free;
        this.node_head = this.trie_buf[0];
        this.node_head.key = '\u0000';
        this.node_head.child_size = 0;
        this.node_head.info_list = new LinkedList();
        this.node_head.child_idx = 0;
        this.free_head.size = 0;
        this.free_head.next_idx = 1;
        this.trie_buf[1].free.size = buf_size - 1;
        this.trie_buf[1].free.next_idx = 0;
    }

    public TNODE fetch(char[] word) {
        int x = this.search(word);
        if (x == 0) {
            return null;
        }
        int idx = this.search_idx[x - 1];
        return this.trie_buf[idx];
    }

    public TNODE get_node(int idx) {
        return this.trie_buf[idx];
    }

    public int node_alloc(int size) {
        if (size <= 0) {
            System.err.println("node alloc: wrong size");
            return 0;
        }
        int pidx = 0;
        int idx = this.free_head.next_idx;
        while (idx != 0) {
            if (this.trie_buf[idx].free.size >= size) break;
            pidx = idx;
            idx = this.trie_buf[idx].free.next_idx;
        }
        if (idx == 0) {
            System.err.println("node alloc: no space");
            return 0;
        }
        if (pidx == 0) {
            if (size == this.trie_buf[idx].free.size) {
                this.free_head.next_idx = this.trie_buf[idx].free.next_idx;
            } else {
                this.trie_buf[idx + size].free.size = this.trie_buf[idx].free.size - size;
                this.trie_buf[idx + size].free.next_idx = this.trie_buf[idx].free.next_idx;
                this.free_head.next_idx = idx + size;
            }
        } else if (size == this.trie_buf[idx].free.size) {
            this.trie_buf[pidx].free.next_idx = this.trie_buf[idx].free.next_idx;
        } else {
            this.trie_buf[idx + size].free.size = this.trie_buf[idx].free.size - size;
            this.trie_buf[idx + size].free.next_idx = this.trie_buf[idx].free.next_idx;
            this.trie_buf[pidx].free.next_idx = idx + size;
        }
        return idx;
    }

    /*
     * Unable to fully structure code
     */
    public void node_free(int fidx, int size) {
        pidx = 0;
        if (size <= 0 || fidx <= 0) {
            System.err.println("node_free: wrong parameter");
            System.exit(0);
        }
        if ((idx = this.free_head.next_idx) == 0) {
            this.free_head.next_idx = fidx;
            this.trie_buf[fidx].free.size = size;
            this.trie_buf[fidx].free.next_idx = 0;
            return;
        }
        if (fidx >= idx) ** GOTO lbl21
        this.free_head.next_idx = fidx;
        if (idx == fidx + size) {
            this.trie_buf[fidx].free.size = size + this.trie_buf[idx].free.size;
            this.trie_buf[fidx].free.next_idx = this.trie_buf[idx].free.next_idx;
        } else {
            this.trie_buf[fidx].free.size = size;
            this.trie_buf[fidx].free.next_idx = idx;
        }
        return;
lbl-1000:
        // 1 sources

        {
            pidx = idx;
            idx = this.trie_buf[idx].free.next_idx;
lbl21:
            // 2 sources

            ** while (idx != 0 && idx < fidx)
        }
lbl22:
        // 1 sources

        start = this.trie_buf[pidx].free;
        if (fidx + size == idx) {
            size += this.trie_buf[idx].free.size;
            start.next_idx = this.trie_buf[idx].free.next_idx;
        }
        if (pidx + start.size == fidx) {
            start.size += size;
        } else {
            this.trie_buf[fidx].free.size = size;
            this.trie_buf[fidx].free.next_idx = start.next_idx;
            start.next_idx = fidx;
        }
    }

    public int node_look(char key, int idx) {
        TNODE parent = idx == 1 ? this.node_head : this.trie_buf[idx];
        int i = parent.child_idx;
        while (i < parent.child_idx + parent.child_size) {
            if (this.trie_buf[i].key == key) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public void print_result(TagSet tagSet2) {
        try {
            PrintWriter pw = new PrintWriter("data/kE/output.txt");
            int k = 0;
            while (k < this.node_head.child_size) {
                this.print_trie(pw, this.node_head.child_idx + k, 0, tagSet2);
                ++k;
            }
            int ii = this.free_head.next_idx;
            while (ii != 0) {
                pw.print("[n:" + ii + " s:" + this.trie_buf[ii].free.size + "] ");
                ii = this.trie_buf[ii].free.next_idx;
            }
            pw.println();
            pw.flush();
            pw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void print_trie(PrintWriter pw, int idx, int depth, TagSet tagSet2) {
        int i = 0;
        while (i < depth) {
            pw.print("\t");
            ++i;
        }
        pw.print(String.valueOf(idx) + ":" + Code.toCompatibilityJamo(this.trie_buf[idx].key) + " ");
        if (this.trie_buf[idx].info_list != null) {
            int k = 0;
            while (k < this.trie_buf[idx].info_list.size()) {
                pw.print("t:" + tagSet2.getTagName(this.trie_buf[idx].info_list.get((int)k).tag) + " ");
                ++k;
            }
        }
        pw.println();
        i = 0;
        while (i < this.trie_buf[idx].child_size) {
            this.print_trie(pw, this.trie_buf[idx].child_idx + i, depth + 1, tagSet2);
            ++i;
        }
    }

    public void read_dic(String dictionaryFileName, TagSet tagSet2) throws IOException {
        String str = "";
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(dictionaryFileName), encoding));
        INFO[] info_list = new INFO[255];
        int i = 0;
        while (i < 255) {
            info_list[i] = new INFO();
            ++i;
        }
        while ((str = in.readLine()) != null) {
            str.trim();
            if (str.equals("")) continue;
            StringTokenizer tok = new StringTokenizer(str, "\t ");
            String word = tok.nextToken();
            int isize = 0;
            while (tok.hasMoreTokens()) {
                String data = tok.nextToken();
                StringTokenizer tok2 = new StringTokenizer(data, ".");
                String curt = tok2.nextToken();
                int x = tagSet2.getTagID(curt);
                if (x == -1) {
                    System.err.println("read_dic:tag error");
                    continue;
                }
                info_list[isize].phoneme = tok2.hasMoreTokens() ? (int)((short)tagSet2.getIrregularID(tok2.nextToken())) : 0;
                info_list[isize].tag = x;
                ++isize;
            }
            info_list[isize].tag = 0;
            info_list[isize].phoneme = 0;
            char[] word3 = Code.toTripleArray(word);
            int i2 = 0;
            while (i2 < isize) {
                this.store(word3, info_list[i2]);
                ++i2;
            }
        }
    }

    public int search(char[] word) {
        int child;
        short cs;
        int widx = 0;
        int nidx = 0;
        int i = 0;
        i = 0;
        while (widx < word.length && i < this.search_end) {
            if (word[i] != this.search_key[i]) break;
            ++widx;
            ++i;
        }
        this.search_end = i;
        if (this.search_end == 0) {
            cs = this.node_head.child_size;
            child = this.node_head.child_idx;
            nidx = 0;
        } else {
            child = this.search_idx[this.search_end - 1];
            cs = this.trie_buf[child].child_size;
            child = this.trie_buf[child].child_idx;
            nidx = this.search_idx[this.search_end - 1];
        }
        while (widx < word.length) {
            if (cs == 0) {
                return 0;
            }
            char key = word[widx];
            TNODE rnode = null;
            nidx = 0;
            int j = child;
            while (j < child + cs) {
                if (key == this.trie_buf[j].key) {
                    rnode = this.trie_buf[j];
                    nidx = j;
                    break;
                }
                ++j;
            }
            if (rnode == null) break;
            this.search_key[this.search_end] = key;
            this.search_idx[this.search_end] = nidx;
            ++this.search_end;
            ++widx;
            child = this.trie_buf[nidx].child_idx;
            cs = this.trie_buf[nidx].child_size;
        }
        if (this.trie_buf[nidx].info_list == null || this.trie_buf[nidx].info_list.size() == 0) {
            return 0;
        }
        return this.search_end;
    }

    public int store(char[] word, INFO inode) {
        if (word.length == 0) {
            return -1;
        }
        this.search(word);
        int widx = this.search_end;
        TNODE parent = this.search_end == 0 ? this.node_head : this.trie_buf[this.search_idx[this.search_end - 1]];
        while (widx < word.length) {
            TNODE tmp;
            int new_index;
            char c = word[widx];
            int cs = parent.child_size;
            if (cs == 0) {
                new_index = this.node_alloc(1);
                this.trie_buf[new_index].key = c;
                this.trie_buf[new_index].child_idx = 0;
                this.trie_buf[new_index].child_size = 0;
                parent.child_size = 1;
                parent.child_idx = new_index;
                this.search_idx[this.search_end] = new_index;
                this.search_key[this.search_end] = c;
                ++this.search_end;
                ++widx;
                parent = this.trie_buf[new_index];
                continue;
            }
            new_index = this.node_alloc(cs + 1);
            int child_index = parent.child_idx;
            int i = 0;
            while (i < cs) {
                if (this.trie_buf[child_index + i].key >= c) break;
                tmp = this.trie_buf[new_index + i];
                this.trie_buf[new_index + i] = this.trie_buf[child_index + i];
                this.trie_buf[child_index + i] = tmp;
                ++i;
            }
            this.trie_buf[new_index + i].key = c;
            this.trie_buf[new_index + i].child_idx = 0;
            this.trie_buf[new_index + i].child_size = 0;
            this.search_idx[this.search_end] = new_index + i;
            this.search_key[this.search_end] = c;
            ++this.search_end;
            ++widx;
            int j = i;
            while (j < cs) {
                tmp = this.trie_buf[new_index + j + 1];
                this.trie_buf[new_index + j + 1] = this.trie_buf[child_index + j];
                this.trie_buf[child_index + j] = tmp;
                ++j;
            }
            parent.child_idx = new_index;
            parent.child_size = (short)(cs + 1);
            this.node_free(child_index, cs);
            parent = this.trie_buf[new_index + i];
        }
        if (parent.info_list == null) {
            parent.info_list = new LinkedList();
        }
        INFO in = new INFO();
        in.phoneme = inode.phoneme;
        in.tag = inode.tag;
        parent.info_list.add(in);
        return 0;
    }

    public class FREE {
        public int size;
        public int next_idx;
    }

    public class INFO {
        public int tag;
        public int phoneme;
    }

    public class TNODE {
        public char key;
        public short child_size;
        public int child_idx;
        public LinkedList<INFO> info_list = null;
        public FREE free;

        public TNODE() {
            this.free = new FREE();
        }
    }
}

