/*
 * Decompiled with CFR 0.152.
 */
package kaist.cilab.parser.berkeleyadaptation;

import java.util.LinkedList;
import java.util.StringTokenizer;
import kaist.cilab.jhannanum.common.workflow.Workflow;
import kaist.cilab.jhannanum.plugin.major.morphanalyzer.impl.ChartMorphAnalyzer;
import kaist.cilab.jhannanum.plugin.major.postagger.impl.HMMTagger;
import kaist.cilab.jhannanum.plugin.supplement.MorphemeProcessor.UnknownMorphProcessor.UnknownProcessor;
import kaist.cilab.jhannanum.plugin.supplement.PlainTextProcessor.InformalSentenceFilter.InformalSentenceFilter;
import kaist.cilab.jhannanum.plugin.supplement.PlainTextProcessor.SentenceSegmentor.SentenceSegmentor;
import kaist.cilab.parser.berkeleyadaptation.Configuration;
import kaist.cilab.parser.berkeleyadaptation.Eojeol;

public class HanNanumMorphAnalWrapper {
    private static HanNanumMorphAnalWrapper instance = null;
    private Workflow han;

    private HanNanumMorphAnalWrapper() {
        try {
            this.han = new Workflow();
            this.han.appendPlainTextProcessor(new SentenceSegmentor(), null);
            this.han.appendPlainTextProcessor(new InformalSentenceFilter(), null);
            this.han.setMorphAnalyzer(new ChartMorphAnalyzer(), String.valueOf(Configuration.hanBaseDir) + "/conf/plugin/MajorPlugin/MorphAnalyzer/ChartMorphAnalyzer.json", Configuration.hanBaseDir);
            this.han.appendMorphemeProcessor(new UnknownProcessor(), null);
            this.han.setPosTagger(new HMMTagger(), String.valueOf(Configuration.hanBaseDir) + "/conf/plugin/MajorPlugin/PosTagger/HmmPosTagger.json", Configuration.hanBaseDir);
            this.han.activateWorkflow(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static HanNanumMorphAnalWrapper getInstance() {
        if (instance == null) {
            instance = new HanNanumMorphAnalWrapper();
        }
        return instance;
    }

    public Eojeol[] getAnalysisResult(String txt) throws Exception {
        this.han.analyze(txt);
        String result = this.han.getResultOfDocument();
        result = this.modifySenLevelPOSResult(result);
        StringTokenizer tok = new StringTokenizer(result, "\n\r");
        Eojeol[] ret = new Eojeol[tok.countTokens() / 2];
        int index = 0;
        int i = 0;
        while (i < txt.length()) {
            if (txt.charAt(i) != ' ' && txt.charAt(i) != '\t') {
                ret[index] = new Eojeol();
                ret[index].offset = i;
                ret[index].origEojeol = tok.nextToken();
                String analResult = tok.nextToken().trim();
                if (ret[index].origEojeol.endsWith("\uc5d0\uc11c")) {
                    analResult = String.valueOf(ret[index].origEojeol.substring(0, ret[index].origEojeol.length() - 2)) + "/ncn+\uc5d0\uc11c/jco";
                }
                StringTokenizer eachAnal = new StringTokenizer(analResult, "+");
                LinkedList<Eojeol.Token> tokTmp = new LinkedList<Eojeol.Token>();
                while (eachAnal.hasMoreElements()) {
                    String nextAnal = eachAnal.nextToken();
                    while (nextAnal.indexOf(47) == -1) {
                        nextAnal = String.valueOf(nextAnal) + eachAnal.nextToken();
                    }
                    Eojeol.Token token = ret[index].new Eojeol.Token();
                    token.word = nextAnal.substring(0, nextAnal.lastIndexOf(47));
                    token.pos = nextAnal.substring(nextAnal.lastIndexOf(47) + 1);
                    if (token.word.equals("\ubd80\ud130")) {
                        token.pos = "jca";
                    }
                    tokTmp.add(token);
                }
                ret[index].tokenList = new Eojeol.Token[tokTmp.size()];
                int tokIdx = 0;
                for (Eojeol.Token t : tokTmp) {
                    ret[index].tokenList[tokIdx++] = t;
                }
                this.integrateSamePOS(ret[index], "n");
                this.integrateSamePOS(ret[index], "j");
                i += ret[index].origEojeol.length() - 1;
                ret[index].eojeolIdx = index;
                ++index;
            }
            ++i;
        }
        return ret;
    }

    private void integrateSamePOS(Eojeol e, String pos) {
        boolean prevOK = false;
        boolean[] merged = new boolean[e.tokenList.length];
        int mergeCnt = 0;
        int mergeIdx = -1;
        int i = 0;
        while (i < e.tokenList.length) {
            merged[i] = false;
            if (e.tokenList[i].pos.startsWith(pos)) {
                if (prevOK) {
                    e.tokenList[mergeIdx].word = String.valueOf(e.tokenList[mergeIdx].word) + e.tokenList[i].word;
                    ++mergeCnt;
                    merged[i] = true;
                } else {
                    mergeIdx = i;
                }
                prevOK = true;
            } else {
                prevOK = false;
            }
            ++i;
        }
        Eojeol.Token[] tmpTokList = new Eojeol.Token[e.tokenList.length - mergeCnt];
        int tmpIdx = 0;
        int i2 = 0;
        while (i2 < e.tokenList.length) {
            if (!merged[i2]) {
                tmpTokList[tmpIdx++] = e.tokenList[i2];
            }
            ++i2;
        }
        e.tokenList = tmpTokList;
    }

    private String modifySenLevelPOSResult(String result) {
        String ret = result;
        ret = ret.replaceAll("\uac00/pvg\\+\uc544/ecx\\+\uc9c0/px", "\uac00\uc9c0\\/pvg");
        ret = ret.replaceAll("\uc785/pvg\\+\ub2c8\ub2e4/ef", "\uc774/jp\\+\u3142\ub2c8\ub2e4/ef");
        ret = ret.replaceAll("\uc77c/pvg\\+\u3142\ub2c8\ub2e4/ef", "\uc774/jp\\+\u3142\ub2c8\ub2e4/ef");
        ret = ret.replaceAll("\uc5d0\uc11c/jca\\+\ub294/jxc", "\uc5d0\uc11c\ub294/jca");
        return ret;
    }

    public String getSpacedresult(String in) throws Exception {
        Eojeol[] data = this.getAnalysisResult(in);
        String ret = "";
        int i = 0;
        while (i < data.length) {
            int j = 0;
            while (j < data[i].tokenList.length) {
                ret = String.valueOf(ret) + data[i].tokenList[j].word + " ";
                ++j;
            }
            ++i;
        }
        return ret.trim();
    }

    public static void main(String[] args) {
        try {
            HanNanumMorphAnalWrapper maw = HanNanumMorphAnalWrapper.getInstance();
            Eojeol[] ret = maw.getAnalysisResult("\uc2e0\ub77c\uba74\uc740 1\uac1c\uc5d0 505\uce7c\ub85c\ub9ac\uc758 \uc5f4\ub7c9\uc744 \uac16\uace0 \uc788\ub2e4.");
            int i = 0;
            while (i < ret.length) {
                System.out.println(ret[i]);
                System.out.println("=================================");
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

