/*
 * Decompiled with CFR 0.152.
 */
package kaist.cilab.parser.psg2dg;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.LinkedList;
import kaist.cilab.parser.util.TreeIOUtil;
import kaist.cilab.tripleextractor.util.Configuration;
import kaist.cilab.tripleextractor.util.DBMgr;

public class InsertParseToDB {
    public void doInsert() {
        try {
            DBMgr.openConnection(Configuration.database, Configuration.dbSchema, Configuration.dbID, Configuration.dbPasswd);
            Connection conn = DBMgr.getConnection();
            PreparedStatement ps_insert = conn.prepareStatement("INSERT INTO berkeley_orig_dep (senID, wordSeq, word, phraseTag, depTo, depRel, POS) VALUES (?, ?, ?, ?, ?, ?, ?)");
            LinkedList<String> fileNames = TreeIOUtil.getAbsSubFileNames("./Converted");
            String str = "";
            for (String fn : fileNames) {
                try {
                    BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fn), "UTF-8"));
                    int cnt = 0;
                    while ((str = in.readLine()) != null) {
                        String[] strArr = str.split("\t");
                        int senID = Integer.parseInt(strArr[0]);
                        int wordSeq = Integer.parseInt(strArr[1]);
                        String word = strArr[2];
                        String phraseTag = strArr[4];
                        int dept = Integer.parseInt(strArr[3]);
                        String depRel = strArr[5];
                        String POS = strArr[2];
                        if (word.length() >= 240 || POS.length() >= 145) continue;
                        ps_insert.setInt(1, senID);
                        ps_insert.setInt(2, wordSeq);
                        ps_insert.setString(3, word.trim());
                        ps_insert.setString(4, phraseTag.trim());
                        ps_insert.setInt(5, dept);
                        ps_insert.setString(6, depRel.trim());
                        ps_insert.setString(7, POS.trim());
                        ps_insert.addBatch();
                        if (++cnt % 1000 != 0) continue;
                        ps_insert.executeBatch();
                        System.out.println(cnt);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ps_insert.executeBatch();
            ps_insert.close();
            conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        InsertParseToDB a = new InsertParseToDB();
        a.doInsert();
    }
}

