/*
 * Decompiled with CFR 0.152.
 */
package kaist.cilab.parser.util;

import java.util.Hashtable;
import java.util.LinkedList;
import kaist.cilab.parser.corpusconverter.sejong2treebank.sejongtree.NonterminalNode;
import kaist.cilab.parser.corpusconverter.sejong2treebank.sejongtree.TerminalNode;
import kaist.cilab.parser.corpusconverter.sejong2treebank.sejongtree.TreeNode;

public class KoreanHeadFinder {
    private Hashtable<String, String[][]> ruleTbl = new Hashtable();
    private static KoreanHeadFinder khf;

    private KoreanHeadFinder() {
        this.ruleTbl.put("S", new String[][]{{"right"}, {"VP_"}, {"VNP_"}, {"S_"}, {"NP_", "AP_"}, {"Q_"}});
        this.ruleTbl.put("NP", new String[][]{{"right"}, {"NP_"}, {"S_"}, {"VP_"}, {"VNP_"}, {"AP_"}});
        this.ruleTbl.put("VP", new String[][]{{"right"}, {"VP_"}, {"VNP_"}, {"NP_"}, {"S_"}, {"IP_"}});
        this.ruleTbl.put("VNP", new String[][]{{"right"}, {"VNP_"}, {"NP_"}, {"S_"}});
        this.ruleTbl.put("IP", new String[][]{{"right"}, {"IP_"}, {"VNP_"}});
        this.ruleTbl.put("DP", new String[][]{{"right"}, {"DP_"}, {"VP_"}});
        this.ruleTbl.put("AP", new String[][]{{"right"}, {"AP_"}, {"VP_"}, {"NP_"}, {"S_"}});
        this.ruleTbl.put("Q", new String[][]{{"left"}, {"S_", "VP_", "VNP_", "NP_"}, {"Q_"}});
        this.ruleTbl.put("R", new String[][]{{"right"}});
        this.ruleTbl.put("L", new String[][]{{"right"}});
        this.ruleTbl.put("LP", new String[][]{{"right"}});
        this.ruleTbl.put("PPN", new String[][]{{"right"}});
        this.ruleTbl.put("X", new String[][]{{"right"}});
        this.ruleTbl.put("ROOT", new String[][]{{"right"}});
    }

    public static KoreanHeadFinder getInstance() {
        if (khf == null) {
            khf = new KoreanHeadFinder();
        }
        return khf;
    }

    private String refinePhraseTag(String phraseTag) {
        if (phraseTag.indexOf(45) > 0) {
            phraseTag = phraseTag.substring(0, phraseTag.indexOf(45));
        }
        if (phraseTag.indexOf(59) > 0) {
            phraseTag = phraseTag.substring(0, phraseTag.indexOf(59));
        }
        return phraseTag;
    }

    public TreeNode determineHead(TreeNode tn) {
        if (tn instanceof TerminalNode) {
            return null;
        }
        TreeNode[] children = this.listToArray(((NonterminalNode)tn).getChildren());
        String[] childTags = new String[children.length];
        int i = 0;
        while (i < childTags.length) {
            childTags[i] = children[i] instanceof NonterminalNode ? ((NonterminalNode)children[i]).getPhraseTag() : ((TerminalNode)children[i]).getPOS();
            ++i;
        }
        int headIdx = this.determineHeadCore(((NonterminalNode)tn).getPhraseTag(), childTags);
        return children[headIdx];
    }

    public TreeNode determinePrepreterminalHead(TreeNode tn) {
        if (tn instanceof TerminalNode) {
            return null;
        }
        if (this.isPrepreterminalNode(tn)) {
            return tn;
        }
        TreeNode[] children = this.listToArray(((NonterminalNode)tn).getChildren());
        String[] childTags = new String[children.length];
        int i = 0;
        while (i < childTags.length) {
            childTags[i] = children[i] instanceof NonterminalNode ? ((NonterminalNode)children[i]).getPhraseTag() : ((TerminalNode)children[i]).getPOS();
            ++i;
        }
        int headIdx = this.determineHeadCore(((NonterminalNode)tn).getPhraseTag(), childTags);
        return this.determinePrepreterminalHead(children[headIdx]);
    }

    private boolean isPrepreterminalNode(TreeNode tn) {
        if (tn instanceof TerminalNode) {
            return false;
        }
        NonterminalNode nn = (NonterminalNode)tn;
        LinkedList<TreeNode> children = nn.getChildren();
        for (TreeNode tn2 : children) {
            if (!(tn2 instanceof NonterminalNode)) continue;
            return false;
        }
        return true;
    }

    public int determineHeadCore(String pTag, String[] children) {
        String phraseTag = this.refinePhraseTag(pTag);
        String[][] resolveCode = this.ruleTbl.get(phraseTag);
        if (resolveCode == null) {
            return children.length - 1;
        }
        String direction = resolveCode[0][0];
        if (direction.equals("right")) {
            int i = 1;
            while (i < resolveCode.length) {
                int j = children.length - 1;
                while (j >= 0) {
                    int k = 0;
                    while (k < resolveCode[i].length) {
                        String childCompare = this.refinePhraseTag(children[j]);
                        if (resolveCode[i][k].endsWith("_") && childCompare.startsWith(resolveCode[i][k].substring(0, resolveCode[i][k].length() - 1))) {
                            return j;
                        }
                        if (!resolveCode[i][k].endsWith("_") && childCompare.equals(resolveCode[i][k])) {
                            return j;
                        }
                        ++k;
                    }
                    --j;
                }
                ++i;
            }
            return children.length - 1;
        }
        int i = 1;
        while (i < resolveCode.length) {
            int j = 0;
            while (j < children.length) {
                int k = 0;
                while (k < resolveCode[i].length) {
                    String childCompare = this.refinePhraseTag(children[j]);
                    if (resolveCode[i][k].endsWith("_") && childCompare.startsWith(resolveCode[i][k].substring(0, resolveCode[i][k].length() - 1))) {
                        return j;
                    }
                    if (!resolveCode[i][k].endsWith("_") && childCompare.equals(resolveCode[i][k])) {
                        return j;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return 0;
    }

    private TreeNode[] listToArray(LinkedList<TreeNode> tnList) {
        TreeNode[] ret = new TreeNode[tnList.size()];
        int cnt = 0;
        for (TreeNode tn : tnList) {
            ret[cnt++] = tn;
        }
        return ret;
    }
}

