/*
 * Decompiled with CFR 0.152.
 */
package kaist.cilab.parser.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import kaist.cilab.parser.corpusconverter.sejong2treebank.sejongtree.ParseTree;
import kaist.cilab.parser.util.CleanSJTree;

public class TreeIOUtil {
    public static LinkedList<ParseTree> readPennTreeBank(String pennDir, String encoding) {
        LinkedList<ParseTree> ptBank = new LinkedList<ParseTree>();
        LinkedList<String> fileNames = TreeIOUtil.getAbsSubFileNames(pennDir);
        for (String fn : fileNames) {
            System.out.println(fn);
            try {
                LinkedList<ParseTree> ptArr = TreeIOUtil.constructPennTreeBank(fn);
                for (ParseTree pt : ptArr) {
                    int cfr_ignored_0 = pt.getTerminalNodes().length;
                    ptBank.add(pt);
                    pt.setOrigFileName(fn);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ptBank;
    }

    public static LinkedList<ParseTree> readSejongTreeBank(String sejongDir, String encoding) {
        LinkedList<ParseTree> ptBank = new LinkedList<ParseTree>();
        LinkedList<String> fileNames = TreeIOUtil.getSubFileNames(sejongDir);
        for (String fn : fileNames) {
            try {
                LinkedList<ParseTree> ptArr = TreeIOUtil.constructSejongTreeBank(String.valueOf(sejongDir) + "/" + fn, encoding);
                for (ParseTree pt : ptArr) {
                    ptBank.add(pt);
                    pt.setOrigFileName(fn);
                }
                System.out.println(String.valueOf(fn) + "\t" + ptArr.size());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ptBank;
    }

    public static LinkedList<String> getSubFileNames(String dir) {
        LinkedList<String> ret = new LinkedList<String>();
        File f = new File(dir);
        TreeIOUtil.getSubFiles(f, ret);
        return ret;
    }

    private static void getSubFiles(File f, LinkedList<String> fileNames) {
        if (f.isFile()) {
            fileNames.add(f.getName());
            return;
        }
        File[] subs = f.listFiles();
        int i = 0;
        while (i < subs.length) {
            TreeIOUtil.getSubFiles(subs[i], fileNames);
            ++i;
        }
    }

    public static LinkedList<String> getAbsSubFileNames(String dir) {
        LinkedList<String> ret = new LinkedList<String>();
        File f = new File(dir);
        TreeIOUtil.getAbsSubFiles(f, ret);
        return ret;
    }

    private static void getAbsSubFiles(File f, LinkedList<String> fileNames) {
        if (f.isFile()) {
            String absPath = f.getAbsolutePath();
            fileNames.add(absPath);
            return;
        }
        File[] subs = f.listFiles();
        int i = 0;
        while (i < subs.length) {
            TreeIOUtil.getAbsSubFiles(subs[i], fileNames);
            ++i;
        }
    }

    public static LinkedList<ParseTree> constructSejongTreeBank(String fileName, String encoding) throws Exception {
        LinkedList<ParseTree> ret = new LinkedList<ParseTree>();
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), encoding));
        String str = "";
        String merging = "";
        String origSen = "";
        int curSenID = 0;
        boolean isInSentence = false;
        boolean isSepPOS = false;
        while ((str = in.readLine()) != null) {
            String orig = str;
            str = CleanSJTree.clean(str);
            str = str.replaceAll(";Q1", "");
            str = str.replaceAll(";Q2", "");
            str = str.replaceAll(";Q3", "");
            if ((str = str.replaceAll(";Q4", "")).trim().length() == 0) continue;
            if (orig.charAt(0) == ';') {
                isInSentence = true;
                if (!merging.equals("")) {
                    ParseTree pt = new ParseTree(origSen, merging, curSenID++);
                    merging = "";
                    ret.add(pt);
                }
                if (!(origSen = str.substring(1).trim()).startsWith("Q1") && !origSen.startsWith("Q2") && !origSen.startsWith("Q3") && !origSen.startsWith("Q4")) continue;
                origSen = origSen.substring(2);
                continue;
            }
            if (!isInSentence || str.trim().startsWith("<")) continue;
            if (isSepPOS && !str.trim().startsWith("(")) {
                merging = String.valueOf(merging) + " + ";
            }
            merging = String.valueOf(merging) + str.trim();
            isSepPOS = false;
            if (str.trim().endsWith(")")) continue;
            isSepPOS = true;
        }
        if (!merging.equals("")) {
            ParseTree pt = new ParseTree(origSen, merging, curSenID++);
            merging = "";
            ret.add(pt);
        }
        in.close();
        return ret;
    }

    public static LinkedList<ParseTree> constructPennTreeBank(String stringTree) throws Exception {
        System.out.println(String.valueOf(stringTree) + "=================");
        LinkedList<ParseTree> ret = new LinkedList<ParseTree>();
        System.out.println("\uc798\ub428");
        ParseTree pt = new ParseTree("TMP", stringTree, 0, true);
        ret.add(pt);
        return ret;
    }

    public static String readSejongCorpusHeader(String fileName, String encoding) {
        String ret = "";
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), encoding));
            String str = "";
            while ((str = in.readLine()) != null) {
                ret = String.valueOf(ret) + str + "\n";
                if (!(str = str.trim()).equals("<body>")) continue;
                in.close();
                return ret;
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static String readSejongCorpusTail(String fileName, String encoding) {
        String ret = "";
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), encoding));
            String str = "";
            boolean start = false;
            while ((str = in.readLine()) != null) {
                if (str.trim().equals("</body>")) {
                    start = true;
                }
                if (!start) continue;
                ret = String.valueOf(ret) + str + "\n";
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }
}

