/*
 * Decompiled with CFR 0.152.
 */
package kaist.cilab.tripleextractor.dbpedia;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.HashSet;
import kaist.cilab.tripleextractor.dbpedia.Triple;
import kaist.cilab.tripleextractor.indexer.Finder;
import org.apache.lucene.search.ScoreDoc;

public class AppropriateSentenceRetriever {
    public void printCorrespondingSentence(int index) {
        HashSet targetDoc = new HashSet();
        Finder fd = new Finder();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("./Infobox_Slice/" + index + ".txt"), "UTF-8"));
            PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("./Infobox_Slice/Sentence_" + index + ".txt"), "UTF-8"));
            String str = "";
            int cnt = 0;
            while ((str = in.readLine()) != null) {
                String[] data = str.trim().split("\t");
                Triple tp = new Triple();
                if (data.length < 4) continue;
                try {
                    tp.tid = Integer.parseInt(data[0]);
                }
                catch (Exception e) {
                    continue;
                }
                try {
                    tp.subject = URLDecoder.decode(data[1], "UTF-8").replaceAll("_", " ").trim().replaceAll("\\\"", "").replaceAll("\\\\", "");
                }
                catch (Exception e) {
                    tp.subject = data[0].replaceAll("_", " ").trim().replaceAll("\\\"", "").replaceAll("\\\\", "");
                }
                try {
                    tp.predicate = URLDecoder.decode(data[2], "UTF-8").replaceAll("_", " ").trim().replaceAll("\\\"", "").replaceAll("\\\\", "");
                }
                catch (Exception e) {
                    tp.predicate = data[1].replaceAll("_", " ").trim().replaceAll("\\\"", "").replaceAll("\\\\", "");
                }
                try {
                    tp.object = URLDecoder.decode(data[3], "UTF-8").replaceAll("_", " ").trim().replaceAll("\\\"", "").replaceAll("\\\\", "");
                }
                catch (Exception e) {
                    tp.object = data[2].replaceAll("_", " ").trim().replaceAll("\\\"", "").replaceAll("\\\\", "");
                }
                tp.subject = this.removeParenthesis(tp.subject);
                tp.object = this.removeParenthesis(tp.object);
                tp.subject = this.escapeSpecialCharacters(tp.subject);
                tp.predicate = this.escapeSpecialCharacters(tp.predicate);
                tp.object = this.escapeSpecialCharacters(tp.object);
                if (tp.subject.equals(tp.object)) {
                    if (++cnt % 1000 != 0) continue;
                    System.out.println(cnt);
                    continue;
                }
                ScoreDoc[] result = fd.findSentence(tp.subject, tp.predicate, tp.object);
                int i = 0;
                while (i < result.length) {
                    pw.println(String.valueOf(tp.tid) + "\t" + tp.subject + "\t" + tp.predicate + "\t" + tp.object);
                    pw.println(fd.searcher.doc(result[i].doc).get("Sentence_ID"));
                    pw.println(fd.searcher.doc(result[i].doc).get("sentence"));
                    pw.println(fd.searcher.doc(result[i].doc).get("Sentence_Orig"));
                    ++i;
                }
                if (++cnt % 1000 != 0) continue;
                System.out.println(cnt);
            }
            in.close();
            pw.close();
            fd.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String escapeSpecialCharacters(String arg1) {
        String ret = "";
        int i = 0;
        while (i < arg1.length()) {
            char c = arg1.charAt(i);
            if (c == '+') {
                ret = String.valueOf(ret) + "\\+";
            } else if (c == '-') {
                ret = String.valueOf(ret) + "\\-";
            } else if (c == '&' && i < arg1.length() - 1 && arg1.charAt(i + 1) == '&') {
                ret = String.valueOf(ret) + "\\&\\&";
                ++i;
            } else if (c == '|' && i < arg1.length() - 1 && arg1.charAt(i + 1) == '|') {
                ret = String.valueOf(ret) + "\\|\\|";
                ++i;
            } else {
                ret = c == '!' ? String.valueOf(ret) + "\\!" : (c == '(' ? String.valueOf(ret) + "\\(" : (c == ')' ? String.valueOf(ret) + "\\)" : (c == '{' ? String.valueOf(ret) + "\\{" : (c == '}' ? String.valueOf(ret) + "\\}" : (c == '[' ? String.valueOf(ret) + "\\[" : (c == ']' ? String.valueOf(ret) + "\\]" : (c == '^' ? String.valueOf(ret) + "\\^" : (c == '\"' ? String.valueOf(ret) + "\\\"" : (c == '~' ? String.valueOf(ret) + "\\~" : (c == '*' ? String.valueOf(ret) + "\\*" : (c == '?' ? String.valueOf(ret) + "\\?" : (c == ':' ? String.valueOf(ret) + "\\:" : (c == '\\' ? String.valueOf(ret) + "\\\\" : String.valueOf(ret) + c)))))))))))));
            }
            ++i;
        }
        return ret;
    }

    public String removeParenthesis(String arg1) {
        while (arg1.indexOf(40) > 0 && arg1.indexOf(41) > 0 && arg1.indexOf(40) < arg1.indexOf(41)) {
            arg1 = String.valueOf(arg1.substring(0, arg1.indexOf(40))) + arg1.substring(arg1.indexOf(41));
        }
        return arg1;
    }

    public static void main(String[] args) {
        AppropriateSentenceRetriever asr = new AppropriateSentenceRetriever();
        int index = Integer.parseInt("1");
        asr.printCorrespondingSentence(index);
    }
}

