/*
 * Decompiled with CFR 0.152.
 */
package kaist.cilab.tripleextractor.indexer;

import java.io.File;
import java.util.HashSet;
import java.util.LinkedList;
import kaist.cilab.tripleextractor.util.Configuration;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;

public class Finder {
    private IndexReader reader;
    public IndexSearcher searcher;
    private Analyzer analyzer;
    private QueryParser qparser;

    public Finder() {
        try {
            this.reader = IndexReader.open(FSDirectory.open(new File(Configuration.indexDir)));
            this.searcher = new IndexSearcher(this.reader);
            this.analyzer = new StandardAnalyzer(Version.LUCENE_31);
            this.qparser = new QueryParser(Version.LUCENE_34, "sentence", this.analyzer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LinkedList<String> getAllMatchingSentences(String[][] argSet) throws Exception {
        LinkedList<String> ret = new LinkedList<String>();
        HashSet<ScoreDoc> tmp = new HashSet<ScoreDoc>();
        int i = 0;
        while (i < argSet.length) {
            ScoreDoc[] matches = this.findSentence(argSet[i][0], argSet[i][1]);
            int j = 0;
            while (j < matches.length) {
                tmp.add(matches[j]);
                ++j;
            }
            ++i;
        }
        for (ScoreDoc sd : tmp) {
            ret.add(this.searcher.doc(sd.doc).get("sentence"));
        }
        return ret;
    }

    public ScoreDoc[] findSentence(String arg1, String arg2) throws Exception {
        Query q = this.qparser.parse(QueryParser.escape("sentence:(\"" + arg1 + "\" AND \"" + arg2 + "\")"));
        ScoreDoc[] sdocs = this.searcher.search((Query)q, (int)1000000).scoreDocs;
        return sdocs;
    }

    public ScoreDoc[] findSentence(String arg1, String arg2, String arg3) throws Exception {
        Query q = this.qparser.parse("Title:(\"" + arg1 + "\") AND sentence:(\"" + arg1 + "\" AND \"" + arg2 + "\" AND \"" + arg3 + "\")");
        ScoreDoc[] sdocs = this.searcher.search((Query)q, (int)1000000).scoreDocs;
        return sdocs;
    }

    public void close() {
        try {
            this.reader.close();
            this.searcher.close();
            this.analyzer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            Finder fd = new Finder();
            ScoreDoc[] result = fd.findSentence("\uc544\uc774\ud2f0 \uc758", "\uc778\ud130\ub137");
            int i = 0;
            while (i < result.length) {
                System.out.println(fd.searcher.doc(result[i].doc).get("sentence"));
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

