/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.filter;

import java.util.Hashtable;
import org.apache.ldap.common.filter.AbstractExprNode;
import org.apache.ldap.common.filter.FilterVisitor;
import org.apache.ldap.common.message.DerefAliasesEnum;

public class ScopeNode
extends AbstractExprNode {
    private final int m_scope;
    private final String m_baseDn;
    private final DerefAliasesEnum m_derefAliases;

    public ScopeNode(DerefAliasesEnum a_derefAliases, String a_baseDn, int a_scope) {
        super(7);
        this.m_scope = a_scope;
        this.m_baseDn = a_baseDn;
        this.m_derefAliases = a_derefAliases;
    }

    public ScopeNode(Hashtable a_env, String a_baseDn, int a_scope) {
        super(7);
        this.m_scope = a_scope;
        this.m_baseDn = a_baseDn;
        this.m_derefAliases = DerefAliasesEnum.getEnum(a_env);
    }

    public boolean isLeaf() {
        return true;
    }

    public int getScope() {
        return this.m_scope;
    }

    public String getBaseDn() {
        return this.m_baseDn;
    }

    public DerefAliasesEnum getDerefAliases() {
        return this.m_derefAliases;
    }

    public void printToBuffer(StringBuffer a_buf) {
        switch (this.m_scope) {
            case 0: {
                a_buf.append("OBJECT_SCOPE");
                break;
            }
            case 1: {
                a_buf.append("ONELEVEL_SCOPE");
                break;
            }
            case 2: {
                a_buf.append("SUBTREE_SCOPE (Estimated)");
                break;
            }
            default: {
                a_buf.append("UNKNOWN");
            }
        }
        if (this.getAnnotations().containsKey("count")) {
            a_buf.append(" [");
            a_buf.append(this.getAnnotations().get("count").toString());
            a_buf.append(']');
        }
    }

    public void accept(FilterVisitor a_visitor) {
        if (a_visitor.canVisit(this)) {
            a_visitor.visit(this);
        }
    }
}

