/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.ldif;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import org.apache.ldap.common.ldif.LdifIteratorMonitor;
import org.apache.ldap.common.ldif.LdifIteratorMonitorAdapter;

public class LdifIterator
implements Iterator {
    private static final boolean DEBUG = false;
    private String m_prefetched = null;
    private LdifIteratorMonitor monitor = new LdifIteratorMonitorAdapter();
    private BufferedReader m_in = null;
    private StringBuffer m_buf = new StringBuffer();

    public LdifIterator(InputStream in) throws IOException {
        this(new InputStreamReader(in));
    }

    public LdifIterator(Reader in) throws IOException {
        this.m_in = new BufferedReader(in);
        this.debug("<init>: -- opended file");
        this.prefetch();
        this.debug("<init>: -- prefetch complete");
    }

    public LdifIterator(InputStream in, LdifIteratorMonitor monitor) throws IOException {
        this(new InputStreamReader(in), monitor);
    }

    public LdifIterator(Reader in, LdifIteratorMonitor monitor) throws IOException {
        this(in);
        this.monitor = monitor;
    }

    public boolean hasNext() {
        return null != this.m_prefetched;
    }

    public Object next() {
        String l_retVal = this.m_prefetched;
        try {
            this.debug("next(): -- called");
            this.prefetch();
        }
        catch (IOException e) {
            this.error("Premature termination of LDIF iterator due to underlying stream error", e);
        }
        return l_retVal;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void error(String msg, Throwable throwable) {
        if (null == this.monitor) {
            System.err.println(msg);
            throwable.printStackTrace(System.err);
        } else {
            this.monitor.fatalFailure(msg, throwable);
        }
    }

    private void debug(String msg) {
    }

    private void debug(String msg, Throwable throwable) {
    }

    private void prefetch() throws IOException {
        boolean l_insideLdif = false;
        String l_line = null;
        while (null != (l_line = this.m_in.readLine())) {
            this.debug("readLine(): " + l_line);
            l_line = LdifIterator.filterComment(l_line).trim();
            if (l_insideLdif) {
                if (l_line.equals("")) break;
                this.debug("prefetch(): -- appending last line to buffer");
                this.m_buf.append(l_line).append('\n');
                continue;
            }
            if (l_line.equals("")) continue;
            l_insideLdif = true;
            this.debug("prefetch(): -- appending last line to buffer");
            this.m_buf.append(l_line).append('\n');
        }
        if (null == l_line && 0 == this.m_buf.length()) {
            this.debug("prefetch(): -- line was null and buffer was empty");
            this.debug("prefetch(): -- iterator has been consumed");
            this.m_prefetched = null;
        } else {
            this.debug("prefetch(): -- LDIF prefetched and set as next");
            this.m_prefetched = this.m_buf.toString();
        }
        this.m_buf.setLength(0);
        this.debug("prefetch(): -- LDIF buffer cleared");
    }

    public static String filterComment(String line) {
        int l_index = line.indexOf(35);
        if (-1 == l_index) {
            return line;
        }
        if (l_index == 0) {
            return "";
        }
        while (-1 != l_index) {
            if (l_index - 1 > 0 && '\\' == line.charAt(l_index - 1)) {
                if (l_index + 1 < line.length()) {
                    l_index = line.indexOf(35, l_index + 1);
                    continue;
                }
                return line;
            }
            return line.substring(0, l_index);
        }
        return line;
    }
}

