/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.ldif;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import org.apache.commons.collections.MultiMap;
import org.apache.ldap.common.ldif.LdifEntry;
import org.apache.ldap.common.ldif.LdifParser;
import org.apache.ldap.common.util.Base64;

public class LdifParserImpl
implements LdifParser {
    public void parse(MultiMap a_attrHash, String an_ldif) throws ParseException {
        boolean l_isBase64Encoded = false;
        int l_lineCount = 0;
        StringReader l_strIn = new StringReader(an_ldif);
        BufferedReader l_in = new BufferedReader(l_strIn);
        try {
            String l_line;
            while ((l_line = l_in.readLine()) != null) {
                String l_attrValue;
                int l_index = l_line.indexOf(58);
                if (l_index == -1) {
                    throw new ParseException("Line " + l_lineCount + " [" + l_line + "] does not correspond to an LDIF entry " + "attribute value pair.\n{" + an_ldif + "}", l_lineCount);
                }
                String l_attrName = l_line.substring(0, l_index).trim();
                if (l_line.charAt(++l_index) == ':') {
                    l_isBase64Encoded = true;
                }
                try {
                    while (l_line.charAt(++l_index) == ' ') {
                    }
                    l_attrValue = l_line.substring(l_index);
                }
                catch (StringIndexOutOfBoundsException e) {
                    l_attrValue = "";
                }
                if (l_isBase64Encoded && l_attrValue != null) {
                    a_attrHash.put(l_attrName, this.base64decode(l_attrValue));
                    l_isBase64Encoded = false;
                    continue;
                }
                a_attrHash.put(l_attrName, l_attrValue);
            }
        }
        catch (IOException e) {
            throw new ParseException(e.getMessage(), l_lineCount);
        }
    }

    public byte[] base64decode(String a_attrValue) {
        return Base64.decode(a_attrValue.toCharArray());
    }

    public void parse(Attributes an_attributes, String an_ldif) throws ParseException, NamingException {
        boolean l_isBase64Encoded = false;
        int l_lineCount = 0;
        StringReader l_strIn = new StringReader(an_ldif);
        BufferedReader l_in = new BufferedReader(l_strIn);
        try {
            String l_line;
            while ((l_line = l_in.readLine()) != null) {
                String l_attrValue;
                int l_index = l_line.indexOf(58);
                if (l_index == -1) {
                    throw new ParseException("Line " + l_lineCount + " [" + l_line + "] does not correspond to an LDIF entry " + "attribute value pair.\n{" + an_ldif + "}", l_lineCount);
                }
                String l_attrName = l_line.substring(0, l_index).trim();
                if (l_line.charAt(++l_index) == ':') {
                    l_isBase64Encoded = true;
                }
                try {
                    while (l_line.charAt(++l_index) == ' ') {
                    }
                    l_attrValue = l_line.substring(l_index);
                }
                catch (StringIndexOutOfBoundsException e) {
                    l_attrValue = "";
                }
                if (l_isBase64Encoded && l_attrValue != null) {
                    an_attributes.put(l_attrName, this.base64decode(l_attrValue));
                    l_isBase64Encoded = false;
                    continue;
                }
                an_attributes.put(l_attrName, l_attrValue);
            }
        }
        catch (IOException e) {
            throw new ParseException(e.getMessage(), l_lineCount);
        }
    }

    public LdifEntry parse(String an_ldif) throws ParseException, NamingException {
        boolean l_isBase64Encoded = false;
        int l_lineCount = 0;
        String l_attrName = new String();
        String l_attrValue = new String();
        String l_prevAttrName = null;
        String l_prevAttrValue = null;
        StringReader l_strIn = new StringReader(an_ldif);
        BufferedReader l_in = new BufferedReader(l_strIn);
        LdifEntry l_entry = new LdifEntry();
        int l_currentModOp = -1;
        try {
            String l_line;
            while ((l_line = l_in.readLine()) != null) {
                if (l_line.equalsIgnoreCase("-")) {
                    if (l_prevAttrValue != null) {
                        if (l_entry.getModType().equalsIgnoreCase("modify")) {
                            if (l_currentModOp == -1) {
                                throw new ParseException("A modification type must be supplied for a change type of modify", l_lineCount);
                            }
                            l_entry.addModificationItem(l_currentModOp, l_attrName, l_attrValue);
                        } else if (l_isBase64Encoded && l_attrValue != null) {
                            l_entry.addAttribute(l_attrName, this.base64decode(l_attrValue));
                            l_isBase64Encoded = false;
                        } else {
                            l_entry.addAttribute(l_attrName, l_attrValue);
                        }
                    }
                    l_currentModOp = -1;
                    l_prevAttrValue = null;
                    l_prevAttrName = null;
                    continue;
                }
                int l_index = l_line.indexOf(58);
                if (l_index == -1) {
                    throw new ParseException("Line " + l_lineCount + " [" + l_line + "] does not correspond to an LDIF entry " + "attribute value pair.\n{" + an_ldif + "}", l_lineCount);
                }
                l_attrName = l_line.substring(0, l_index).trim();
                if (l_line.charAt(++l_index) == ':') {
                    l_isBase64Encoded = true;
                }
                try {
                    while (l_line.charAt(++l_index) == ' ') {
                    }
                    l_attrValue = l_line.substring(l_index);
                }
                catch (StringIndexOutOfBoundsException e) {
                    l_attrValue = "";
                }
                if (l_attrName.equalsIgnoreCase("dn")) {
                    l_entry.setDn(l_attrValue);
                    continue;
                }
                if (l_attrName.equalsIgnoreCase("version")) {
                    l_entry.setVersion(Integer.parseInt(l_attrValue));
                    continue;
                }
                if (l_attrName.equalsIgnoreCase("control")) continue;
                if (l_attrName.equalsIgnoreCase("changetype")) {
                    l_entry.setModType(l_attrValue);
                    continue;
                }
                if (l_attrName.equalsIgnoreCase("add")) {
                    if (!l_entry.getModType().equalsIgnoreCase("modify")) {
                        throw new ParseException("Cannot use modification " + l_attrName + " identifier on " + l_entry.getModType() + " change type", l_lineCount);
                    }
                    l_currentModOp = 1;
                    continue;
                }
                if (l_attrName.equalsIgnoreCase("replace")) {
                    if (!l_entry.getModType().equalsIgnoreCase("modify")) {
                        throw new ParseException("Cannot use modification " + l_attrName + " identifier on " + l_entry.getModType() + " change type", l_lineCount);
                    }
                    l_currentModOp = 2;
                    continue;
                }
                if (l_attrName.equalsIgnoreCase("delete")) {
                    if (!l_entry.getModType().equalsIgnoreCase("modify")) {
                        throw new ParseException("Cannot use modification " + l_attrName + " identifier on " + l_entry.getModType() + " change type", l_lineCount);
                    }
                    l_currentModOp = 3;
                    if (l_attrValue == null) continue;
                    l_prevAttrName = l_attrName;
                    l_prevAttrValue = l_attrValue;
                    continue;
                }
                if (l_entry.getModType().equalsIgnoreCase("modify")) {
                    if (l_currentModOp == -1) {
                        throw new ParseException("A modification type must be supplied for a change type of modify", l_lineCount);
                    }
                    l_entry.addModificationItem(l_currentModOp, l_attrName, l_attrValue);
                    continue;
                }
                if (l_isBase64Encoded && l_attrValue != null) {
                    l_entry.addAttribute(l_attrName, this.base64decode(l_attrValue));
                    l_isBase64Encoded = false;
                    continue;
                }
                l_entry.addAttribute(l_attrName, l_attrValue);
            }
            return l_entry;
        }
        catch (IOException e) {
            throw new ParseException(e.getMessage(), l_lineCount);
        }
    }
}

