/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.message;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.ldap.common.filter.ExprNode;
import org.apache.ldap.common.message.AbstractRequest;
import org.apache.ldap.common.message.DerefAliasesEnum;
import org.apache.ldap.common.message.MessageTypeEnum;
import org.apache.ldap.common.message.ScopeEnum;
import org.apache.ldap.common.message.SearchRequest;

public class SearchRequestImpl
extends AbstractRequest
implements SearchRequest {
    private String m_baseDn;
    private ExprNode m_filter;
    private ScopeEnum m_scope;
    private boolean m_typesOnly;
    private BigInteger m_sizeLimit;
    private BigInteger m_timeLimit;
    private DerefAliasesEnum m_derefAliases;
    private Collection m_attributes = new ArrayList();

    public SearchRequestImpl(BigInteger a_id) {
        super(a_id, SearchRequest.TYPE, true);
    }

    public Collection getAttributes() {
        return Collections.unmodifiableCollection(this.m_attributes);
    }

    public String getBase() {
        return this.m_baseDn;
    }

    public void setBase(String a_base) {
        this.lockCheck("Attempt to alter search base of locked SearchRequest!");
        this.m_baseDn = a_base;
    }

    public DerefAliasesEnum getDerefAliases() {
        return this.m_derefAliases;
    }

    public void setDerefAliases(DerefAliasesEnum a_derefAliases) {
        this.lockCheck("Attempt to alter alias dereferencing mode of locked SearchRequest!");
        this.m_derefAliases = a_derefAliases;
    }

    public ExprNode getFilter() {
        return this.m_filter;
    }

    public void setFilter(ExprNode a_filter) {
        this.lockCheck("Attempt to alter search filter of locked SearchRequest!");
        this.m_filter = a_filter;
    }

    public MessageTypeEnum[] getResponseTypes() {
        return (MessageTypeEnum[])SearchRequest.RESPONSE_TYPES.clone();
    }

    public ScopeEnum getScope() {
        return this.m_scope;
    }

    public void setScope(ScopeEnum a_scope) {
        this.lockCheck("Attempt to alter search scope of locked SearchReqest!");
        this.m_scope = a_scope;
    }

    public BigInteger getSizeLimit() {
        return this.m_sizeLimit;
    }

    public void setSizeLimit(BigInteger a_entriesMax) {
        this.lockCheck("Attempt to alter size limit on locked SearchRequest!");
        this.m_sizeLimit = a_entriesMax;
    }

    public BigInteger getTimeLimit() {
        return this.m_timeLimit;
    }

    public void setTimeLimit(BigInteger a_secondsMax) {
        this.lockCheck("Attempt to alter time limit on locked SearchRequest!");
        this.m_timeLimit = a_secondsMax;
    }

    public boolean getTypesOnly() {
        return this.m_typesOnly;
    }

    public void setTypesOnly(boolean a_typesOnly) {
        this.lockCheck("Attempt to alter typesOnly flag of locked SearchRequest!");
        this.m_typesOnly = a_typesOnly;
    }

    public void addAttribute(String a_attribute) {
        this.lockCheck("Attempt to add return attribute to locked SearchRequest!");
        this.m_attributes.add(a_attribute);
    }

    public void removeAttribute(String a_attribute) {
        this.lockCheck("Attempt to remove return attribute from locked SearchRequest!");
        this.m_attributes.remove(a_attribute);
    }
}

