/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.xhtml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.xhtml.ValidatorHandler;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.DTDLocation;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.XMLCatalog;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.DefaultElement;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class Validator
extends Task {
    private static final String VALIDATION_FEATURE = "http://xml.org/sax/features/validation";
    private String encoding = "ISO-8859-1";
    private File outputFile;
    private XMLWriter out;
    private List filesets = new ArrayList();
    private XMLReader xmlReader;
    private ValidatorHandler validatorHandler = new ValidatorHandler();
    private XMLCatalog xmlCatalog = new XMLCatalog();

    public void setEncoding(String value) {
        this.encoding = value;
    }

    public void setOUtput(File file) {
        this.outputFile = file;
    }

    public void addConfiguredXMLCatalog(XMLCatalog catalog) {
        this.xmlCatalog.addConfiguredXMLCatalog(catalog);
    }

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void init() {
        super.init();
        this.xmlCatalog.setProject(((ProjectComponent)this).project);
    }

    public DTDLocation createDTD() {
        DTDLocation dtdLocation = new DTDLocation();
        this.xmlCatalog.addDTD(dtdLocation);
        return dtdLocation;
    }

    private void initValidator() {
        try {
            this.xmlReader = XMLReaderFactory.createXMLReader();
            this.xmlReader.setFeature(VALIDATION_FEATURE, true);
        }
        catch (SAXNotRecognizedException e) {
            throw new BuildException("Could not start validation: " + this.xmlReader + " doesn't provide validation");
        }
        catch (SAXNotSupportedException e) {
            throw new BuildException("Could not start validation: " + this.xmlReader + " doesn't provide validation");
        }
        catch (SAXException e) {
            throw new BuildException("Could not start validation: " + this.xmlReader + " not found");
        }
        this.log(this.xmlReader.getClass().getName(), 4);
        this.validatorHandler.setChainedEntityResolver((EntityResolver)this.xmlCatalog);
        this.xmlReader.setEntityResolver(this.validatorHandler);
        this.xmlReader.setErrorHandler(this.validatorHandler);
    }

    /*
     * Loose catch block
     */
    public void execute() throws BuildException {
        block16: {
            File dir = this.outputFile.getParentFile();
            if (dir != null) {
                dir.mkdirs();
            }
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding(this.encoding);
            try {
                this.out = new XMLWriter((OutputStream)new FileOutputStream(this.outputFile), format);
            }
            catch (UnsupportedEncodingException e) {
                throw new BuildException("Unsopported encoding: [" + this.encoding + "]");
            }
            catch (FileNotFoundException e) {
                throw new BuildException("Unable to write to [" + this.outputFile.getAbsolutePath() + "]");
            }
            this.initValidator();
            this.validatorHandler.setOut(this.out);
            DefaultElement validation = new DefaultElement("validation");
            this.out.startDocument();
            this.out.writeOpen((Element)validation);
            Iterator fileIterator = this.filesets.iterator();
            while (fileIterator.hasNext()) {
                FileSet fs = (FileSet)fileIterator.next();
                DirectoryScanner ds = fs.getDirectoryScanner(((ProjectComponent)this).project);
                String[] files = ds.getIncludedFiles();
                for (int j = 0; j < files.length; ++j) {
                    File srcFile = new File(fs.getDir(((ProjectComponent)this).project), files[j]);
                    DefaultElement xmlfile = new DefaultElement("file");
                    xmlfile.addAttribute("name", files[j]);
                    this.out.writeOpen((Element)xmlfile);
                    this.doValidate(srcFile);
                    this.out.writeClose((Element)xmlfile);
                }
            }
            this.out.writeClose((Element)validation);
            this.out.endDocument();
            Object var12_15 = null;
            try {
                if (this.out != null) {
                    this.out.close();
                }
                break block16;
            }
            catch (IOException e) {
                this.log("Caught IOException: " + e.getMessage(), 0);
            }
            break block16;
            {
                catch (SAXException e) {
                    this.log(e.getClass() + " " + e.getMessage(), 1);
                    e.printStackTrace();
                    throw new BuildException(e + " " + e.getMessage());
                }
                catch (Exception e) {
                    this.log(e + " " + e.getClass() + " " + e.getMessage(), 1);
                    e.printStackTrace();
                    throw new BuildException(e + " " + e.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                try {
                    if (this.out != null) {
                        this.out.close();
                    }
                }
                catch (IOException e) {
                    this.log("Caught IOException: " + e.getMessage(), 0);
                }
                throw throwable;
            }
        }
    }

    private void doValidate(File afile) {
        this.log("Validating " + afile.getName() + "... ", 2);
        this.validatorHandler.init(afile);
        try {
            InputSource is = new InputSource(new FileInputStream(afile));
            String uri = "file:" + afile.getAbsolutePath().replace('\\', '/');
            int index = uri.indexOf(35);
            while (index != -1) {
                uri = uri.substring(0, index) + "%23" + uri.substring(index + 1);
                index = uri.indexOf(35);
            }
            is.setSystemId(uri);
            is.setEncoding(this.encoding);
            this.xmlReader.parse(is);
        }
        catch (SAXException e) {
            this.logFatalError(e.getMessage());
        }
        catch (UnknownHostException e) {
            this.logFatalError("Could not validate document " + afile.getName() + "; dtd missing from repository and unable to connect (" + e.getMessage() + ")");
        }
        catch (IOException e) {
            this.logFatalError(e.getMessage());
        }
        if (this.validatorHandler.getErrors() > 0) {
            this.log(afile + ", errors=" + this.validatorHandler.getErrors(), 2);
        }
    }

    private void logFatalError(String message) {
        int endCdata;
        DefaultElement error = new DefaultElement("error");
        error.addAttribute("line", "0");
        error.addAttribute("col", "0");
        error.addAttribute("position", "0:0");
        error.addAttribute("level", "fatal");
        while (message != null && (endCdata = message.indexOf("]]>")) > -1) {
            message = message.substring(0, endCdata) + "] ] >" + message.substring(endCdata + 3, message.length());
        }
        error.addCDATA(message);
        this.writeToLog((Element)error);
    }

    private void writeToLog(Element element) {
        try {
            this.out.write(element);
        }
        catch (IOException e) {
            this.log("Caught IOException: " + e.getMessage(), 0);
        }
    }
}

