/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.xhtml;

import java.io.File;
import java.io.IOException;
import org.dom4j.Element;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.DefaultElement;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class ValidatorHandler
implements ErrorHandler,
EntityResolver {
    private int errorsFound;
    private XMLWriter out;
    private EntityResolver chainedEntityResolver;

    ValidatorHandler() {
    }

    public EntityResolver getChainedEntityResolver() {
        return this.chainedEntityResolver;
    }

    public void setChainedEntityResolver(EntityResolver chainedEntityResolver) {
        this.chainedEntityResolver = chainedEntityResolver;
    }

    public void setOut(XMLWriter writer) {
        this.out = writer;
    }

    public void init(File file) {
        this.errorsFound = 0;
    }

    public int getErrors() {
        return this.errorsFound;
    }

    public void error(SAXParseException exception) {
        ++this.errorsFound;
        this.doLog(exception, 0);
    }

    public final void fatalError(SAXParseException exception) {
        this.error(exception);
    }

    public final void warning(SAXParseException exception) {
        this.error(exception);
    }

    private void doLog(SAXParseException e, int logLevel) {
        int endCdata;
        DefaultElement error = new DefaultElement("error");
        error.addAttribute("line", "" + e.getLineNumber());
        error.addAttribute("col", "" + e.getColumnNumber());
        error.addAttribute("position", e.getLineNumber() + ":" + e.getColumnNumber());
        error.addAttribute("level", "" + logLevel);
        String message = e.getMessage();
        while (message != null && (endCdata = message.indexOf("]]>")) > -1) {
            message = message.substring(0, endCdata) + "] ] >" + message.substring(endCdata + 3, message.length());
        }
        error.addCDATA(message);
        this.writeToLog((Element)error);
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (systemId.indexOf(".dtd") != -1) {
            String name = publicId;
            if (name != null) {
                int start = name.indexOf("-//W3C//DTD ");
                int end = name.lastIndexOf("//EN");
                if (start != -1 && end > start + 12) {
                    name = name.substring(start + 12, end);
                }
            }
            DefaultElement dtd = new DefaultElement("dtd");
            dtd.addAttribute("publicId", publicId);
            dtd.addAttribute("systemId", systemId);
            dtd.addAttribute("display", name);
            this.writeToLog((Element)dtd);
        }
        return this.chainedEntityResolver.resolveEntity(publicId, systemId);
    }

    private void writeToLog(Element element) {
        try {
            this.out.write(element);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

