/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.parser.XMLParser;
import org.apache.commons.jelly.util.ClassLoaderUtils;
import org.apache.commons.jelly.util.CommandLineParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class Jelly {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$jelly$Jelly == null ? (class$org$apache$commons$jelly$Jelly = Jelly.class$("org.apache.commons.jelly.Jelly")) : class$org$apache$commons$jelly$Jelly));
    private JellyContext context;
    private URL url;
    private URL rootContext;
    private boolean loadedProperties = false;
    private String defaultNamespaceURI = null;
    private boolean validateXML = false;
    static /* synthetic */ Class class$org$apache$commons$jelly$Jelly;

    public static void main(String[] args) throws Exception {
        try {
            if (args.length <= 0) {
                System.out.println("Usage: jelly [scriptFile] [-script scriptFile -o outputFile -Dsysprop=syspropval]");
                return;
            }
            CommandLineParser.getInstance().invokeCommandLineJelly(args);
        }
        catch (JellyException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                e.printStackTrace();
            }
            cause.printStackTrace();
        }
    }

    public static String getJellyVersion() {
        return Jelly.readBuildTimestampResource("jelly-version.txt");
    }

    public static String getJellyBuildDate() {
        return Jelly.readBuildTimestampResource("jelly-build-date.txt");
    }

    private static String readBuildTimestampResource(String name) {
        Reader in = null;
        try {
            int r;
            StringWriter w = new StringWriter();
            in = new InputStreamReader((class$org$apache$commons$jelly$Jelly == null ? (class$org$apache$commons$jelly$Jelly = Jelly.class$("org.apache.commons.jelly.Jelly")) : class$org$apache$commons$jelly$Jelly).getResourceAsStream(name), "utf-8");
            while ((r = in.read()) >= 0) {
                w.write((char)r);
            }
            return w.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            try {
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new IllegalStateException("Resource \"" + name + "\" not found.");
        }
    }

    public Script compileScript() throws JellyException {
        if (!this.loadedProperties) {
            this.loadedProperties = true;
            this.loadJellyProperties();
        }
        XMLParser parser = new XMLParser();
        try {
            parser.setContext(this.getJellyContext());
        }
        catch (MalformedURLException e) {
            throw new JellyException(e.toString());
        }
        Script script = null;
        try {
            parser.setDefaultNamespaceURI(this.defaultNamespaceURI);
            parser.setValidating(this.validateXML);
            script = parser.parse(this.getUrl());
            script = script.compile();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Compiled script: " + this.getUrl()));
            }
        }
        catch (IOException e) {
            throw new JellyException("could not parse Jelly script", e);
        }
        catch (SAXException e) {
            throw new JellyException("could not parse Jelly script", e);
        }
        return script;
    }

    public void setScript(String script) throws MalformedURLException {
        this.setUrl(this.resolveURL(script));
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public URL getRootContext() throws MalformedURLException {
        if (this.rootContext == null) {
            this.rootContext = new File(System.getProperty("user.dir")).toURL();
        }
        return this.rootContext;
    }

    public void setRootContext(URL rootContext) {
        this.rootContext = rootContext;
    }

    public JellyContext getJellyContext() throws MalformedURLException {
        if (this.context == null) {
            String text = this.getUrl().toString();
            int idx = text.lastIndexOf(47);
            text = text.substring(0, idx + 1);
            this.context = new JellyContext(this.getRootContext(), new URL(text));
        }
        return this.context;
    }

    public void setDefaultNamespaceURI(String namespace) {
        this.defaultNamespaceURI = namespace;
    }

    public void setValidateXML(boolean validate) {
        this.validateXML = validate;
    }

    protected URL resolveURL(String name) throws MalformedURLException {
        URL resourceUrl = ClassLoaderUtils.getClassLoader(this.getClass()).getResource(name);
        if (resourceUrl == null) {
            File file = new File(name);
            if (file.exists()) {
                return file.toURL();
            }
            return new URL(name);
        }
        return resourceUrl;
    }

    protected void loadJellyProperties() {
        InputStream is = null;
        String userDir = System.getProperty("user.home");
        File f = new File(userDir + File.separator + "jelly.properties");
        this.loadProperties(f);
        f = new File("jelly.properties");
        this.loadProperties(f);
        is = ClassLoaderUtils.getClassLoader(this.getClass()).getResourceAsStream("jelly.properties");
        if (is != null) {
            try {
                this.loadProperties(is);
            }
            catch (Exception e) {
                log.error((Object)("Caught exception while loading jelly.properties from the classpath. Reason: " + e), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadProperties(File f) {
        FileInputStream is;
        block8: {
            is = null;
            if (!f.exists()) break block8;
            is = new FileInputStream(f);
            this.loadProperties(is);
        }
        Object var5_3 = null;
        if (is == null) return;
        try {
            ((InputStream)is).close();
            return;
        }
        catch (IOException e2) {
            if (!log.isDebugEnabled()) return;
            log.debug((Object)"error closing property input stream", (Throwable)e2);
        }
        return;
        {
            catch (Exception e) {
                log.error((Object)("Caught exception while loading: " + f.getName() + ". Reason: " + e), (Throwable)e);
                Object var5_4 = null;
                if (is == null) return;
                try {
                    ((InputStream)is).close();
                    return;
                }
                catch (IOException e2) {
                    if (!log.isDebugEnabled()) return;
                    log.debug((Object)"error closing property input stream", (Throwable)e2);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (is == null) throw throwable;
            try {
                ((InputStream)is).close();
                throw throwable;
            }
            catch (IOException e2) {
                if (!log.isDebugEnabled()) throw throwable;
                log.debug((Object)"error closing property input stream", (Throwable)e2);
            }
            throw throwable;
        }
    }

    protected void loadProperties(InputStream is) throws IOException {
        JellyContext theContext = this.getJellyContext();
        Properties props = new Properties();
        props.load(is);
        Enumeration<?> propsEnum = props.propertyNames();
        while (propsEnum.hasMoreElements()) {
            String key = (String)propsEnum.nextElement();
            String value = props.getProperty(key);
            theContext.setVariable(key, value);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

