/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.repository;

import java.net.URI;
import java.util.Collection;
import org.mevenide.project.dependency.IDependencyResolver;
import org.mevenide.repository.IRepositoryReader;
import org.mevenide.repository.RepoPathElement;

abstract class AbstractRepositoryReader
implements IRepositoryReader {
    private URI rootURI;

    protected AbstractRepositoryReader(URI root) {
        this.rootURI = root;
    }

    public URI getRootURI() {
        return this.rootURI;
    }

    protected final RepoPathElement newChild(RepoPathElement parent) {
        RepoPathElement el = new RepoPathElement(this, parent);
        el.setArtifactId(parent.getArtifactId());
        el.setGroupId(parent.getGroupId());
        el.setType(parent.getType());
        el.setVersion(parent.getVersion());
        return el;
    }

    protected final RepoPathElement levelArtifactCheck(RepoPathElement parent, IDependencyResolver resolver) {
        if (parent.getType().equals(resolver.guessType()) && parent.getArtifactId().equals(resolver.guessArtifactId()) && resolver.guessVersion() != null) {
            boolean keep = false;
            if ("plugin".equals(parent.getType()) && "jar".equals(resolver.guessExtension())) {
                keep = true;
            } else if ("distribution".equals(parent.getType()) && "zip".equals(resolver.guessExtension())) {
                keep = true;
            } else if (resolver.guessType().equals(resolver.guessExtension())) {
                keep = true;
            }
            if (keep) {
                RepoPathElement elem = this.newChild(parent);
                elem.setVersion(resolver.guessVersion());
                elem.setExtension(resolver.guessExtension());
                return elem;
            }
        }
        return null;
    }

    protected final RepoPathElement levelTypeCheck(RepoPathElement parent, IDependencyResolver resolver, Collection knownArtifacts) {
        if (parent.getType().equals(resolver.guessType()) && resolver.guessArtifactId() != null && !knownArtifacts.contains(resolver.guessArtifactId())) {
            boolean keep = false;
            if ("plugin".equals(parent.getType()) && "jar".equals(resolver.guessExtension())) {
                keep = true;
            } else if ("distribution".equals(parent.getType()) && ("zip".equals(resolver.guessExtension()) || "tar.gz".equals(resolver.guessExtension()))) {
                keep = true;
            } else if (resolver.guessType().equals(resolver.guessExtension())) {
                keep = true;
            }
            if (keep) {
                knownArtifacts.add(resolver.guessArtifactId());
                RepoPathElement elem = this.newChild(parent);
                elem.setArtifactId(resolver.guessArtifactId());
                elem.setExtension(resolver.guessExtension());
                return elem;
            }
        }
        return null;
    }
}

