/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.repository;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.methods.GetMethod;
import org.mevenide.project.dependency.IDependencyResolver;
import org.mevenide.project.dependency.URIDependencyResolver;
import org.mevenide.repository.AbstractRepositoryReader;
import org.mevenide.repository.RepoPathElement;

class HttpRepositoryReader
extends AbstractRepositoryReader {
    private String proxyhost;
    private String proxyport;
    private String proxyuser;
    private String proxypasswd;

    public HttpRepositoryReader(URI rootUri) {
        super(rootUri);
    }

    public HttpRepositoryReader(URI rootUri, String host, String port) {
        this(rootUri);
        this.proxyhost = host;
        this.proxyport = port;
    }

    public HttpRepositoryReader(URI rootUri, String host, String port, String user, String passwd) {
        this(rootUri, host, port);
        this.proxyuser = user;
        this.proxypasswd = passwd;
    }

    private HttpClient getClient() {
        HttpClient client = new HttpClient();
        if (this.proxyhost != null) {
            HostConfiguration config = new HostConfiguration();
            config.setProxy(this.proxyhost, Integer.parseInt(this.proxyport));
            client.setHostConfiguration(config);
        }
        if (this.proxyuser != null) {
            client.getState().setProxyCredentials(null, this.proxyhost, (Credentials)new UsernamePasswordCredentials(this.proxyuser, this.proxypasswd));
        }
        return client;
    }

    public RepoPathElement[] readElements(RepoPathElement element) throws Exception {
        if (element.isLeaf()) {
            return new RepoPathElement[0];
        }
        String part = element.getPartialURIPath();
        StringBuffer complete = new StringBuffer(this.getRootURI().toString());
        if (!this.getRootURI().toString().endsWith("/")) {
            complete.append("/");
        }
        complete.append(part);
        return this.getChildren(element, URI.create(complete.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RepoPathElement[] getChildren(RepoPathElement element, URI uri) throws Exception {
        GetMethod method = new GetMethod(uri.toString());
        try {
            this.getClient().executeMethod((HttpMethod)method);
            String response = method.getResponseBodyAsString();
            RepoPathElement[] repoPathElementArray = this.createChildren(element, this.getNames(response), uri);
            return repoPathElementArray;
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        finally {
            method.releaseConnection();
        }
        return new RepoPathElement[0];
    }

    StructureWrapper[] getNames(String output) {
        StringTokenizer tok = new StringTokenizer(output, "\n");
        Pattern folderPattern = Pattern.compile(".*<IMG SRC=\"/icons/folder.gif\" ALT=\"\\[DIR\\]\"> <A HREF=\"(.*)/\">(.*)/</A>.*", 2);
        Pattern filePattern = Pattern.compile(".*<IMG SRC=\"/icons/unknown.gif\" ALT=\"\\[   \\]\"> <A HREF=\"(.*)\">(.*)</A>.*", 2);
        ArrayList<StructureWrapper> items = new ArrayList<StructureWrapper>();
        while (tok.hasMoreTokens()) {
            String line = tok.nextToken();
            Matcher match = folderPattern.matcher(line);
            if (match.matches()) {
                String dir = match.group(1);
                items.add(new StructureWrapper(dir, true));
                continue;
            }
            match = filePattern.matcher(line);
            if (!match.matches()) continue;
            String file = match.group(1);
            items.add(new StructureWrapper(file, false));
        }
        StructureWrapper[] str = new StructureWrapper[items.size()];
        return items.toArray(str);
    }

    private RepoPathElement[] createChildren(RepoPathElement element, StructureWrapper[] files, URI uri) {
        ArrayList<RepoPathElement> col = new ArrayList<RepoPathElement>();
        URIDependencyResolver resolver = new URIDependencyResolver();
        HashSet knownArtifacts = new HashSet();
        for (int i = 0; i < files.length; ++i) {
            URI path;
            RepoPathElement elem = null;
            if (element.getLevel() == 0) {
                if (files[i].isDirectory() && !"Global Project".equals(files[i].getName())) {
                    elem = this.newChild(element);
                    elem.setGroupId(files[i].getName());
                }
            } else if (element.getLevel() == 1) {
                if (files[i].isDirectory() && files[i].getName().endsWith("s")) {
                    elem = this.newChild(element);
                    String type = files[i].getName();
                    elem.setType(type.substring(0, type.length() - 1));
                }
            } else if (element.getLevel() == 2) {
                if (files[i].isFile()) {
                    path = URI.create(uri.toString() + "/" + files[i].getName());
                    resolver.setURI(path);
                    elem = this.levelTypeCheck(element, (IDependencyResolver)resolver, knownArtifacts);
                }
            } else if (element.getLevel() == 3 && files[i].isFile() && files[i].getName().startsWith(element.getArtifactId())) {
                path = URI.create(uri.toString() + "/" + files[i].getName());
                resolver.setURI(path);
                elem = this.levelArtifactCheck(element, (IDependencyResolver)resolver);
            }
            if (elem == null) continue;
            col.add(elem);
        }
        if (element.getLevel() == 2) {
            Iterator it = col.iterator();
            while (it.hasNext()) {
                RepoPathElement chil = (RepoPathElement)it.next();
                RepoPathElement[] ch = this.createChildren(chil, files, uri);
                chil.setChildren(ch);
            }
        }
        RepoPathElement[] elems = new RepoPathElement[col.size()];
        return col.toArray(elems);
    }

    private static class StructureWrapper {
        private String name;
        private boolean folder;

        public StructureWrapper(String nm, boolean dir) {
            this.folder = dir;
            this.name = nm;
        }

        public boolean isDirectory() {
            return this.folder;
        }

        public boolean isFile() {
            return !this.folder;
        }

        public String getName() {
            return this.name;
        }
    }
}

