/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.repository;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.mevenide.project.dependency.IDependencyResolver;
import org.mevenide.project.dependency.URIDependencyResolver;
import org.mevenide.repository.AbstractRepositoryReader;
import org.mevenide.repository.RepoPathElement;

class LocalRepositoryReader
extends AbstractRepositoryReader {
    private File rootRepository;

    public LocalRepositoryReader(File rootFile) {
        super(rootFile.toURI());
        this.rootRepository = rootFile;
    }

    public RepoPathElement[] readElements(RepoPathElement element) throws Exception {
        if (element.isLeaf()) {
            return new RepoPathElement[0];
        }
        String part = element.getPartialURIPath();
        File fil = new File(this.rootRepository, part);
        if (fil.exists()) {
            File[] fls = fil.listFiles();
            return this.getChildren(fls, element);
        }
        return new RepoPathElement[0];
    }

    private RepoPathElement[] getChildren(File[] files, RepoPathElement element) {
        ArrayList<RepoPathElement> col = new ArrayList<RepoPathElement>();
        URIDependencyResolver resolver = new URIDependencyResolver();
        HashSet knownArtifacts = new HashSet();
        for (int i = 0; i < files.length; ++i) {
            RepoPathElement elem = null;
            if (element.getLevel() == 0) {
                if (files[i].isDirectory() && !"Global Project".equals(files[i].getName())) {
                    elem = this.newChild(element);
                    elem.setGroupId(files[i].getName());
                }
            } else if (element.getLevel() == 1) {
                if (files[i].isDirectory() && files[i].getName().endsWith("s")) {
                    elem = this.newChild(element);
                    String type = files[i].getName();
                    elem.setType(type.substring(0, type.length() - 1));
                }
            } else if (element.getLevel() == 2) {
                if (files[i].isFile()) {
                    resolver.setURI(files[i].toURI());
                    elem = this.levelTypeCheck(element, (IDependencyResolver)resolver, knownArtifacts);
                }
            } else if (element.getLevel() == 3 && files[i].isFile() && files[i].getName().startsWith(element.getArtifactId())) {
                resolver.setURI(files[i].toURI());
                elem = this.levelArtifactCheck(element, (IDependencyResolver)resolver);
            }
            if (elem == null) continue;
            col.add(elem);
        }
        if (element.getLevel() == 2) {
            Iterator it = col.iterator();
            while (it.hasNext()) {
                RepoPathElement chil = (RepoPathElement)it.next();
                RepoPathElement[] ch = this.getChildren(files, chil);
                chil.setChildren(ch);
            }
        }
        RepoPathElement[] elems = new RepoPathElement[col.size()];
        return col.toArray(elems);
    }
}

