/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.repository;

import java.net.URI;
import org.mevenide.repository.IRepositoryReader;

public final class RepoPathElement {
    public static final int LEVEL_ROOT = 0;
    public static final int LEVEL_GROUP = 1;
    public static final int LEVEL_TYPE = 2;
    public static final int LEVEL_ARTIFACT = 3;
    public static final int LEVEL_VERSION = 4;
    private String groupId;
    private String artifactId;
    private String version;
    private String type;
    private String extension;
    private IRepositoryReader reader;
    private RepoPathElement parent;
    private RepoPathElement[] children;

    public RepoPathElement(IRepositoryReader reader) {
        this.reader = reader;
    }

    public RepoPathElement(IRepositoryReader reader, RepoPathElement parent) {
        this.reader = reader;
        this.parent = parent;
    }

    public RepoPathElement(IRepositoryReader read, RepoPathElement parent, String groupId, String type, String version, String artifactId, String ext) {
        this(read, parent);
        this.setGroupId(groupId);
        this.setType(type);
        this.setVersion(version);
        this.setArtifactId(artifactId);
        this.setExtension(ext);
    }

    public RepoPathElement getParent() {
        return this.parent;
    }

    public String getGroupId() {
        return this.groupId;
    }

    void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    void setVersion(String version) {
        this.version = version;
    }

    public String getType() {
        return this.type;
    }

    void setType(String type) {
        this.type = type;
    }

    public String getExtension() {
        return this.extension;
    }

    void setExtension(String extension) {
        this.extension = extension;
    }

    public boolean isLeaf() {
        return this.getLevel() == 4;
    }

    public boolean isRoot() {
        return this.getLevel() == 0;
    }

    boolean isRepoDirectory() {
        return this.getLevel() == 0 || this.getLevel() == 1 || this.getLevel() == 2;
    }

    public int getLevel() {
        if (this.groupId == null) {
            return 0;
        }
        if (this.type == null) {
            return 1;
        }
        if (this.artifactId == null) {
            return 2;
        }
        if (this.version == null) {
            return 3;
        }
        return 4;
    }

    String getPartialURIPath() {
        StringBuffer buf = new StringBuffer();
        if (this.groupId != null) {
            buf.append(this.groupId);
            if (this.type != null) {
                buf.append("/");
                buf.append(this.type);
                buf.append("s");
            }
        }
        return buf.toString();
    }

    public String getRelativeURIPath() {
        StringBuffer buf = new StringBuffer();
        if (this.groupId != null) {
            buf.append(this.groupId);
            if (this.type != null) {
                buf.append("/");
                buf.append(this.type);
                buf.append("s");
                if (this.artifactId != null) {
                    buf.append("/");
                    buf.append(this.artifactId);
                    if (this.version != null) {
                        buf.append("-");
                        buf.append(this.version);
                    }
                    if (this.extension != null) {
                        buf.append(".");
                        buf.append(this.extension);
                    }
                }
            }
        }
        return buf.toString();
    }

    public URI getRootURI() {
        return this.reader.getRootURI();
    }

    public URI getURI() {
        String root = this.getRootURI().toString();
        if (!root.endsWith("/")) {
            root = root + "/";
        }
        return URI.create(root + this.getRelativeURIPath());
    }

    public RepoPathElement[] getChildren() throws Exception {
        if (this.children == null) {
            this.children = this.reader.readElements(this);
        }
        return this.children;
    }

    void setChildren(RepoPathElement[] childs) {
        this.children = childs;
    }

    public boolean isRemote() {
        return this.reader.getRootURI().toString().startsWith("http://");
    }

    public IRepositoryReader getReader() {
        return this.reader;
    }

    public void reset() {
        this.children = null;
    }

    public boolean isLoaded() {
        return this.children != null;
    }
}

