/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.repository;

import java.io.File;
import java.net.URI;
import org.mevenide.repository.HttpRepositoryReader;
import org.mevenide.repository.IRepositoryReader;
import org.mevenide.repository.LocalRepositoryReader;

public final class RepositoryReaderFactory {
    private RepositoryReaderFactory() {
    }

    public static IRepositoryReader createLocalRepositoryReader(File root) {
        return new LocalRepositoryReader(root);
    }

    public static IRepositoryReader createRemoteRepositoryReader(URI uri) {
        if (uri.toString().startsWith("http://")) {
            return new HttpRepositoryReader(uri);
        }
        if (uri.toString().startsWith("file://")) {
            return RepositoryReaderFactory.createLocalRepositoryReader(new File(uri));
        }
        return null;
    }

    public static IRepositoryReader createRemoteRepositoryReader(URI uri, String proxyHost, String proxyPort) {
        if (uri.toString().startsWith("http://")) {
            return new HttpRepositoryReader(uri, proxyHost, proxyPort);
        }
        return null;
    }

    public static IRepositoryReader createRemoteRepositoryReader(URI uri, String proxyHost, String proxyPort, String proxyUser, String proxyPasswd) {
        if (uri.toString().startsWith("http://")) {
            return new HttpRepositoryReader(uri, proxyHost, proxyPort, proxyUser, proxyPasswd);
        }
        return null;
    }
}

