/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.css;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.container.ContainerRequest;
import org.milyn.css.StyleSheetStore;
import org.milyn.device.UAContext;
import org.milyn.device.UAContextUtil;
import org.milyn.magger.CSSParser;
import org.milyn.magger.CSSProperty;
import org.milyn.magger.CSSRule;
import org.milyn.magger.CSSStylesheet;
import org.milyn.resource.ExternalResourceLocator;
import org.w3c.css.sac.SACMediaList;
import org.w3c.dom.Element;

public class CSSAccessor {
    private static Log logger = LogFactory.getLog((Class)(class$org$milyn$css$CSSAccessor == null ? (class$org$milyn$css$CSSAccessor = CSSAccessor.class$("org.milyn.css.CSSAccessor")) : class$org$milyn$css$CSSAccessor));
    private StyleSheetStore stylesheetStore;
    private ContainerRequest request;
    private static final String REQUEST_REQUESTKEY = (class$org$milyn$css$CSSAccessor == null ? (class$org$milyn$css$CSSAccessor = CSSAccessor.class$("org.milyn.css.CSSAccessor")) : class$org$milyn$css$CSSAccessor) + "#request";
    private static final String ELEMENT_STYLE_DECL_REQUESTKEY = (class$org$milyn$css$CSSAccessor == null ? (class$org$milyn$css$CSSAccessor = CSSAccessor.class$("org.milyn.css.CSSAccessor")) : class$org$milyn$css$CSSAccessor) + "#elementStyleDecls";
    static /* synthetic */ Class class$org$milyn$css$CSSAccessor;

    private CSSAccessor(ContainerRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("null 'request' arg in constructor call.");
        }
        this.request = request;
        this.stylesheetStore = StyleSheetStore.getStore(request);
    }

    public static CSSAccessor getInstance(ContainerRequest request) {
        CSSAccessor accessor = (CSSAccessor)request.getAttribute(REQUEST_REQUESTKEY);
        if (accessor == null) {
            accessor = new CSSAccessor(request);
            request.setAttribute(REQUEST_REQUESTKEY, (Object)accessor);
        }
        return accessor;
    }

    public CSSProperty getProperty(Element domElement, String propertyName) {
        String internPropertyName = propertyName.intern();
        List elementStyleRules = this.getElementStyleRules(domElement);
        if (elementStyleRules != null) {
            for (int i = 0; i < elementStyleRules.size(); ++i) {
                CSSRule elementRule = (CSSRule)elementStyleRules.get(i);
                if (elementRule.getProperty().getName() != internPropertyName) continue;
                return elementRule.getProperty();
            }
        }
        Iterator ssIterator = this.stylesheetStore.iterator();
        CSSRule matchingRule = null;
        while (ssIterator.hasNext()) {
            StyleSheetStore.StoreEntry storeEntry = (StyleSheetStore.StoreEntry)ssIterator.next();
            CSSStylesheet styleSheet = storeEntry.getStylesheet();
            List rules = styleSheet.getRules();
            int ruleCount = rules.size();
            for (int i = 0; i < ruleCount; ++i) {
                CSSRule nextRule = (CSSRule)rules.get(i);
                CSSProperty nextProperty = nextRule.getProperty();
                if (nextProperty.getName() != internPropertyName || !nextRule.getSelector().match(domElement, null) || !this.isForDevice(nextRule)) continue;
                if (matchingRule == null) {
                    matchingRule = nextRule;
                    continue;
                }
                if (nextRule.getSelector().getSpecificity() < matchingRule.getSelector().getSpecificity()) continue;
                matchingRule = nextRule;
            }
        }
        return matchingRule != null ? matchingRule.getProperty() : null;
    }

    private boolean isForDevice(CSSRule rule) {
        SACMediaList targetMediaList = rule.getMediaList();
        if (targetMediaList == null || targetMediaList.getLength() == 0) {
            return true;
        }
        UAContext uaContext = this.request.getUseragentContext();
        int listLen = targetMediaList.getLength();
        for (int i = 0; i < listLen; ++i) {
            String media = targetMediaList.item(i);
            if (!UAContextUtil.isDeviceOrProfile((String)media, (UAContext)uaContext)) continue;
            return true;
        }
        return false;
    }

    private List getElementStyleRules(Element domElement) {
        Hashtable elementStyleDecls;
        List rules = null;
        String styleAttrib = domElement.getAttribute("style");
        if (styleAttrib != null && (rules = (List)(elementStyleDecls = this.getElementStyleDeclCache(this.request)).get(domElement)) == null) {
            CSSParser cssParser = new CSSParser((ExternalResourceLocator)this.request.getContext().getResourceLocator());
            try {
                String styleToParse = domElement.getTagName() + " {" + styleAttrib + "}";
                CSSStylesheet styleSheet = cssParser.parse(styleToParse, this.request.getRequestURI(), null);
                rules = styleSheet.getRules();
                elementStyleDecls.put(domElement, rules);
            }
            catch (Throwable throwable) {
                logger.warn((Object)("Unable to parse element CSS: " + styleAttrib), throwable);
            }
        }
        return rules;
    }

    private Hashtable getElementStyleDeclCache(ContainerRequest request2) {
        Hashtable elementStyleDecls = (Hashtable)this.request.getAttribute(ELEMENT_STYLE_DECL_REQUESTKEY);
        if (elementStyleDecls == null) {
            elementStyleDecls = new Hashtable();
            this.request.setAttribute(ELEMENT_STYLE_DECL_REQUESTKEY, elementStyleDecls);
        }
        return elementStyleDecls;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

