/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.css;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.container.ContainerRequest;
import org.milyn.css.StyleSheetStore;
import org.milyn.delivery.assemble.AbstractAssemblyUnit;
import org.milyn.device.profile.ProfileSet;
import org.milyn.dom.DomUtils;
import org.milyn.magger.CSSParser;
import org.milyn.magger.CSSStylesheet;
import org.milyn.resource.ExternalResourceLocator;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.Element;

public class CSSStyleScraper
extends AbstractAssemblyUnit {
    private static Log logger = LogFactory.getLog((Class)(class$org$milyn$css$CSSStyleScraper == null ? (class$org$milyn$css$CSSStyleScraper = CSSStyleScraper.class$("org.milyn.css.CSSStyleScraper")) : class$org$milyn$css$CSSStyleScraper));
    private boolean checkMediaAttribute = true;
    private boolean checkTypeAttribute = true;
    private boolean checkRelAttributeForStylesheet = true;
    private boolean checkRelAttributeForAlternate = true;
    static /* synthetic */ Class class$org$milyn$css$CSSStyleScraper;

    public CSSStyleScraper(SmooksResourceConfiguration resourceConfig) {
        super(resourceConfig);
        this.checkMediaAttribute = resourceConfig.getBoolParameter("checkMediaAttribute", true);
        this.checkTypeAttribute = resourceConfig.getBoolParameter("checkTypeAttribute", true);
        this.checkRelAttributeForStylesheet = resourceConfig.getBoolParameter("checkRelAttributeForStylesheet", true);
        this.checkRelAttributeForAlternate = resourceConfig.getBoolParameter("checkRelAttributeForAlternate", true);
    }

    public boolean visitBefore() {
        return false;
    }

    public void visit(Element element, ContainerRequest request) {
        String media = DomUtils.getAttributeValue((Element)element, (String)"media");
        String type = DomUtils.getAttributeValue((Element)element, (String)"type");
        if (this.checkMediaAttribute && media != null && !this.hasMediaProfile(media, request.getUseragentContext().getProfileSet())) {
            logger.info((Object)("Bypassing style. [" + request.getRequestURI() + "]. Requesting device [" + request.getUseragentContext() + "] does not have required media profile [" + media + "]."));
            return;
        }
        if (this.checkTypeAttribute && type != null && !(type = type.trim().toLowerCase()).equals("text/css")) {
            logger.info((Object)("Bypassing style. [" + request.getRequestURI() + "]. 'type' attribute set but value not 'text/css'."));
            return;
        }
        if (element.getTagName().equals("style")) {
            this.visitStyle(element, request, media);
        } else if (element.getTagName().equals("link")) {
            this.visitLink(element, request, media);
        }
    }

    private boolean hasMediaProfile(String media, ProfileSet profileSet) {
        StringTokenizer tokenizer = new StringTokenizer(media, ",");
        while (tokenizer.hasMoreTokens()) {
            if (!profileSet.isMember(tokenizer.nextToken().trim())) continue;
            return true;
        }
        return false;
    }

    private void visitStyle(Element element, ContainerRequest request, String media) {
        String style = DomUtils.getAllText((Element)element, (boolean)false);
        if (!style.trim().equals("")) {
            try {
                CharArrayReader reader = new CharArrayReader(style.toCharArray());
                this.parseCSS(element, request, media, new InputSource((Reader)reader));
            }
            catch (Throwable throwable) {
                logger.warn((Object)("Unable to parse inline style element css. [" + request.getRequestURI() + "]"), throwable);
            }
        }
    }

    private void visitLink(Element element, ContainerRequest request, String media) {
        InputStream cssStream;
        URI cssURI;
        String href = DomUtils.getAttributeValue((Element)element, (String)"href");
        String rel = DomUtils.getAttributeValue((Element)element, (String)"rel");
        if (href == null || href.trim().equals("")) {
            return;
        }
        if (rel != null) {
            rel = rel.trim().toLowerCase();
            if (this.checkRelAttributeForStylesheet && rel.indexOf("stylesheet") == -1) {
                logger.info((Object)("Bypassing link element. [" + request.getRequestURI() + "]. 'rel' attribute set but 'stylesheet' not in value."));
                return;
            }
            if (this.checkRelAttributeForAlternate && rel.indexOf("alternate") != -1) {
                logger.info((Object)("Bypassing linked style element css. [" + request.getRequestURI() + "]. 'rel' attribute declares css as being 'alternate'."));
                return;
            }
        }
        try {
            cssURI = request.getRequestURI().resolve(new URI(href));
        }
        catch (URISyntaxException e) {
            logger.warn((Object)("Bypassing linked style element css. [" + request.getRequestURI() + "]. Invalid css link 'href' [" + href + "]."));
            return;
        }
        try {
            cssStream = request.getContext().getResourceLocator().getResource(cssURI.toString());
        }
        catch (IOException e) {
            logger.warn((Object)("Bypassing linked style element css. [" + request.getRequestURI() + "]. CSS stream read failure."), (Throwable)e);
            return;
        }
        try {
            this.parseCSS(element, request, media, new InputSource((Reader)new InputStreamReader(cssStream)));
        }
        catch (Throwable throwable) {
            logger.warn((Object)("Unable to parse linked css. [" + request.getRequestURI() + "]"), throwable);
        }
    }

    private void parseCSS(Element element, ContainerRequest request, String media, InputSource inputSource) throws CSSException, IOException {
        CSSParser parser = new CSSParser((ExternalResourceLocator)request.getContext().getResourceLocator());
        StyleSheetStore store = StyleSheetStore.getStore(request);
        CSSStylesheet styleSheet = parser.parse(inputSource, request.getRequestURI(), null, null);
        store.add(styleSheet, element);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

